/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MTab;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_CC_CollectiveIntelligence;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public class ModCCOnlyReadForUsers
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCOnlyReadForUsers.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("CC_CollectiveIntelligence", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_CC_CollectiveIntelligence.Table_ID) {
            String tabName;
            String winName = OFBForward.ReadLogicWindowCC();
            if (winName.equals("N")) {
                winName = "Registro M\u00e9dico";
            }
            if ((tabName = OFBForward.ReadLogicTabCC()).equals("N")) {
                tabName = "Inteligencia Colectiva";
            }
            String userConnectID = Env.getContext(Env.getCtx(), "#AD_User_ID");
            String[] context = Env.getEntireContext(po.getCtx());
            ArrayList<String> contextList = new ArrayList<String>(Arrays.asList(context));
            String windowsopens = "";
            int i = 0;
            while (i < contextList.size()) {
                if (contextList.get(i).contains("WindowName")) {
                    windowsopens = String.valueOf(windowsopens) + "," + contextList.get(i);
                }
                ++i;
            }
            if (windowsopens.contains(winName)) {
                int AD_Window_ID = DB.getSQLValue(po.get_TrxName(), "select coalesce(max(w.AD_Window_ID),0) from AD_Window w left join AD_Window_Trl wt on (wt.AD_Window_ID = w.AD_Window_ID) where lower(wt.name) like lower('" + winName + "')");
                int tabID = MTab.getTab_ID(AD_Window_ID, tabName);
                String readOnlyLogic = DB.getSQLValueString(po.get_TrxName(), "select coalesce(max(readonlylogic),'') from ad_tab where ad_tab_id =" + tabID, new Object[0]);
                String isReadOnly = "";
                if (readOnlyLogic.contains("#AD_User_ID")) {
                    isReadOnly = readOnlyLogic.replace("@#AD_User_ID@", userConnectID);
                    if ((isReadOnly = DB.getSQLValueString(null, isReadOnly, new Object[0])).equals("Y")) {
                        String msg = "";
                        msg = Msg.getMsg(Env.getLanguage(po.getCtx()), "OFB_UserReadOnly");
                        throw new AdempiereException(msg);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

