/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCCGenTwoInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCGenTwoInvoice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder ord;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 8 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).getC_Order_ID() > 0 && (ord = new MOrder(po.getCtx(), inv.getC_Order_ID(), po.get_TrxName())).isSOTrx()) {
            MDocType dt = MDocType.get(po.getCtx(), ord.getC_DocType_ID());
            MInvoice inv2 = this.createInvoice(dt, inv.getDateInvoiced(), ord, po, inv);
            BigDecimal factor1 = new BigDecimal("50.0");
            BigDecimal factor2 = new BigDecimal("50.0");
            MInvoiceLine[] lines = inv.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                line.setPrice(line.getPriceEntered().multiply(factor1));
                line.setLineNetAmt();
                line.setTaxAmt();
                line.saveEx();
                inv.calculateTaxTotal();
                inv.saveEx();
                ++i;
            }
            MInvoiceLine[] lines2 = inv2.getLines(false);
            int a = 0;
            while (a < lines2.length) {
                MInvoiceLine line2 = lines2[a];
                line2.setPrice(line2.getPriceEntered().multiply(factor2));
                line2.setLineNetAmt();
                line2.setTaxAmt();
                line2.saveEx();
                inv2.calculateTaxTotal();
                inv2.saveEx();
                ++a;
            }
            int ID_Payment2 = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Payment_ID) FROM C_Payment  WHERE C_Invoice_ID = " + inv2.get_ID() + " AND DocStatus IN ('CO','DR','IP','IN')");
            if (ID_Payment2 > 0) {
                MPayment pay2 = new MPayment(po.getCtx(), ID_Payment2, po.get_TrxName());
                pay2.setPayAmt(inv2.getGrandTotal());
                pay2.saveEx(po.get_TrxName());
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    private MInvoice createInvoice(MDocType dt, Timestamp invoiceDate, MOrder order, PO po, MInvoice inv) {
        log.info(dt.toString());
        MInvoice invoice = new MInvoice(order, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        invoice.setDescription("Generado desde factura " + inv.getDocumentNo() + " y orden " + order.getDocumentNo());
        invoice.setC_BPartner_ID(2007319);
        if (!invoice.save(po.get_TrxName())) {
            throw new AdempiereException("Could not create Invoice");
        }
        MOrderLine[] oLines = order.getLines();
        int i = 0;
        while (i < 3) {
            MOrderLine oLine = oLines[i];
            MInvoiceLine iLine = new MInvoiceLine(invoice);
            iLine.setOrderLine(oLine);
            iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
            if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                iLine.setQtyEntered(iLine.getQtyInvoiced());
            } else {
                iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4));
            }
            if (!iLine.save(po.get_TrxName())) {
                throw new AdempiereException("Could not create Invoice Line from Order Line");
            }
            ++i;
        }
        invoice.saveEx(po.get_TrxName());
        return invoice;
    }
}

