/*
 * Decompiled with CFR 0.152.
 */
package org.cencosud.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.compiere.model.X_HR_WorkHours;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RedFileWriteDHL
extends SvrProcess {
    private String rutaArchivo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null && name.equals("rutaArchivo")) {
                this.rutaArchivo = para[i].getParameterAsString();
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String pFile = this.rutaArchivo;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datos.toString());
            String[] cabecera = new String[30];
            int a = 0;
            while (a < 30) {
                cabecera[a] = ((String[])datos.get(0))[a];
                ++a;
            }
            int x = 1;
            while (x <= cantLines) {
                try {
                    int idCol = 6;
                    int flag = 1;
                    String rut = "";
                    rut = ((String[])datos.get(x))[0];
                    if (rut != null) {
                        rut = rut.replace("-", "");
                        rut = rut.substring(0, rut.length() - 1);
                    }
                    int ID_BPartner = DB.getSQLValue(this.get_TrxName(), "SELECT C_Bpartner_ID FROM C_Bpartner  WHERE IsActive = 'Y' AND value like '" + rut + "' ");
                    while (flag > 0) {
                        if (!this.isDate(cabecera[idCol])) continue;
                        X_HR_WorkHours wHour = new X_HR_WorkHours(this.getCtx(), 0, this.get_TrxName());
                        wHour.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                        if (ID_BPartner > 0) {
                            wHour.setC_BPartner_ID(ID_BPartner);
                        } else {
                            wHour.setErrorMsg("ERROR: Socio de Negocio Inexistente:" + ((String[])datos.get(x))[0] + " / " + ((String[])datos.get(x))[1]);
                        }
                        wHour.setDateTrx(this.convertDate(cabecera[idCol]));
                        if (RedFileWriteDHL.isNumber(((String[])datos.get(x))[idCol])) {
                            wHour.setQty((BigDecimal)decimalFormat.parse(((String[])datos.get(x))[idCol]));
                        } else {
                            wHour.setDescription(((String[])datos.get(x))[idCol]);
                        }
                        wHour.save(this.get_TrxName());
                        if (++idCol != 30) continue;
                        flag = -1;
                    }
                }
                catch (Exception e) {
                    this.log.config("ERROR: " + e);
                }
                ++x;
            }
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        return "Se han cargado " + (cantLines - 1) + " lineas de archivo";
    }

    public String DeleteEjecucion(String files) {
        Runtime aplicacion = Runtime.getRuntime();
        try {
            aplicacion.exec("cmd.exe /K del " + files);
        }
        catch (Exception e) {
            return e.toString();
        }
        return "Proceso OK";
    }

    public String DeleteEjecucionCompleta(String rutaBatDelete) {
        Runtime aplicacion = Runtime.getRuntime();
        try {
            aplicacion.exec("cmd.exe /K " + rutaBatDelete);
        }
        catch (Exception e) {
            return e.toString();
        }
        return "Proceso OK";
    }

    private boolean isDate(String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
            Date parsedDate = dateFormat.parse(dateStr);
            Timestamp timestamp = new Timestamp(parsedDate.getTime());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Timestamp convertDate(String dateStr) {
        Timestamp timestamp = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
            Date parsedDate = dateFormat.parse(dateStr);
            timestamp = new Timestamp(parsedDate.getTime());
        }
        catch (Exception e) {
            this.log.config("ERRRO:" + e);
        }
        return timestamp;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isNumber(String numberStr) {
        if (numberStr == null || numberStr.isEmpty()) {
            return false;
        }
        numberStr = numberStr.trim();
        numberStr = numberStr.replace(",", "");
        numberStr = numberStr.replace(".", "");
        int i = 0;
        if (numberStr.charAt(0) == '-') {
            if (numberStr.length() <= 1) {
                return false;
            }
            ++i;
        }
        while (i < numberStr.length()) {
            if (!Character.isDigit(numberStr.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

