/*
 * Decompiled with CFR 0.152.
 */
package org.cencosud.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_M_LocatorSetAmt;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LoadDDS
extends SvrProcess {
    private String p_PathFile;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("archivo")) {
                    this.p_PathFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String rutaArchivo;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String pFile = rutaArchivo = this.p_PathFile;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        int cant = 0;
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config("Se ha leido " + cantLines + " desde archivo");
            BigDecimal qty = Env.ZERO;
            int x = 1;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[0] + "'");
                int ID_PGroup = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Product_Group_ID) FROM M_Product_Group WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[1] + "'");
                int flag = 0;
                if (ID_Locator > 0 && ID_PGroup > 0) {
                    X_M_LocatorSetAmt lAmt;
                    qty = (BigDecimal)decimalFormat.parse(((String[])datos.get(x))[2].trim());
                    flag = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_LocatorSetAmt_ID) FROM M_LocatorSetAmt  WHERE IsActive='Y' AND M_Locator_ID=" + ID_Locator + " AND M_Product_Group_ID=" + ID_PGroup);
                    if (flag > 0) {
                        lAmt = new X_M_LocatorSetAmt(this.getCtx(), flag, this.get_TrxName());
                        lAmt.setQty(qty);
                        lAmt.saveEx(this.get_TrxName());
                    } else {
                        lAmt = new X_M_LocatorSetAmt(this.getCtx(), 0, this.get_TrxName());
                        lAmt.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                        lAmt.setM_Locator_ID(ID_Locator);
                        lAmt.setM_Product_Group_ID(ID_PGroup);
                        lAmt.setQty(qty);
                        lAmt.saveEx(this.get_TrxName());
                        ++cant;
                    }
                }
                ++x;
            }
            datos = null;
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        return "Se han cargado " + cant + " lineas";
    }
}

