/*
 * Decompiled with CFR 0.152.
 */
package org.cencosud.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductCategory;
import org.compiere.model.X_I_InventoryCencosud;
import org.compiere.model.X_I_OrderCencosud;
import org.compiere.model.X_M_Product_GroupReplenish;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPForecastDefinition;
import org.eevolution.model.MPPForecastDefinitionLine;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class GenOCCencosudOld
extends SvrProcess {
    private Timestamp p_dateTrx;
    private Timestamp p_dateInv;
    private int p_ID_PCategory;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_dateTrx = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateAcct")) {
                    this.p_dateInv = para[i].getParameterAsTimestamp();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_ID_PCategory = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order = null;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String rutaArchivo = OFBForward.CencosudRutaStock();
        DB.executeUpdate("DELETE FROM I_InventoryCencosud", this.get_TrxName());
        String pFile = rutaArchivo;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datos.toString());
            int x = 1;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[0] + "'");
                int ID_PGroup = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Product_Group_ID) FROM M_Product_Group WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[1] + "'");
                BigDecimal qty = (BigDecimal)decimalFormat.parse(((String[])datos.get(x))[3].trim());
                if (ID_Locator > 0 && ID_PGroup > 0 && qty != null) {
                    X_I_InventoryCencosud inv = new X_I_InventoryCencosud(this.getCtx(), 0, this.get_TrxName());
                    inv.setAD_Org_ID(0);
                    inv.setM_Locator_ID(ID_Locator);
                    inv.setM_Product_Group_ID(ID_PGroup);
                    inv.setQtyOnHand(qty);
                    inv.save(this.get_TrxName());
                }
                ++x;
            }
            datos = null;
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        DB.executeUpdate("DELETE FROM I_OrderCencosud", this.get_TrxName());
        String pFileO = rutaArchivo = OFBForward.CencosudRutaEnTransito();
        ArrayList<String[]> datosO = new ArrayList<String[]>();
        cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFileO);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datosO.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datosO.toString());
            int x = 1;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datosO.get(x))[1] + "'");
                int ID_Product = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Product_ID) FROM M_Product WHERE IsActive = 'Y' AND value like '" + ((String[])datosO.get(x))[4] + "'");
                BigDecimal qty = (BigDecimal)decimalFormat.parse(((String[])datosO.get(x))[10].trim());
                Timestamp fePedido = null;
                Timestamp feEntrega = null;
                if (DateUtils.isDateddMMyyyy(((String[])datosO.get(x))[11].trim().toString())) {
                    fePedido = DateUtils.convertDateddMMyyyy(((String[])datosO.get(x))[11].trim());
                } else if (DateUtils.isDateddMMyyyy(((String[])datosO.get(x))[11].trim().toString().replace(".", "-"))) {
                    fePedido = DateUtils.convertDateddMMyyyy(((String[])datosO.get(x))[11].trim().replace(".", "-"));
                }
                if (DateUtils.isDateddMMyyyy(((String[])datosO.get(x))[12].trim().toString())) {
                    feEntrega = DateUtils.convertDateddMMyyyy(((String[])datosO.get(x))[12].trim());
                } else if (DateUtils.isDateddMMyyyy(((String[])datosO.get(x))[12].trim().toString().replace(".", "-"))) {
                    feEntrega = DateUtils.convertDateddMMyyyy(((String[])datosO.get(x))[12].trim().replace(".", "-"));
                }
                if (ID_Locator > 0 && ID_Product > 0 && qty != null && fePedido != null && feEntrega != null) {
                    X_I_OrderCencosud iOrder = new X_I_OrderCencosud(this.getCtx(), 0, this.get_TrxName());
                    iOrder.setAD_Org_ID(0);
                    iOrder.setDocumentNo(((String[])datosO.get(x))[0]);
                    iOrder.setM_Locator_ID(ID_Locator);
                    iOrder.setM_Product_ID(ID_Product);
                    iOrder.setMovementQty(qty);
                    iOrder.setDateAcct(fePedido);
                    iOrder.setDateTrx(feEntrega);
                    iOrder.save(this.get_TrxName());
                }
                ++x;
            }
            datosO = null;
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        String pFileF = rutaArchivo = OFBForward.CencosudRutaForecast();
        ArrayList<String[]> datosF = new ArrayList<String[]>();
        cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFileF);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datosF.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datosF.toString());
            String[] cabecera = new String[12];
            int a = 0;
            while (a < 12) {
                cabecera[a] = ((String[])datosF.get(0))[a];
                ++a;
            }
            int x = 1;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datosF.get(x))[0] + "'");
                int ID_PGroup = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Product_Group_ID) FROM M_Product_Group WHERE IsActive = 'Y' AND value like '" + ((String[])datosF.get(x))[1] + "'");
                if (ID_Locator > 0 && ID_PGroup > 0) {
                    DB.executeUpdate("DELETE FROM PP_ForecastDefinitionLine WHERE IsActive = 'Y' AND M_Locator_ID = " + ID_Locator + " AND M_Product_Group_ID=" + ID_PGroup, this.get_TrxName());
                    int idCol = 3;
                    int flag = 1;
                    int seqNo = 10;
                    while (flag > 0) {
                        if (!DateUtils.isDateddMMyyyy(cabecera[idCol])) continue;
                        int id_Fore = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(PP_ForecastDefinition_ID) FROM PP_ForecastDefinition WHERE IsActive = 'Y' AND M_Locator_ID = " + ID_Locator);
                        if (id_Fore < 1) {
                            MPPForecastDefinition def = new MPPForecastDefinition(this.getCtx(), 0, this.get_TrxName());
                            def.setAD_Org_ID(0);
                            def.setName("Pronostico" + ((String[])datosF.get(x))[0]);
                            def.set_CustomColumn("M_Locator_ID", ID_Locator);
                            def.save(this.get_TrxName());
                            id_Fore = def.get_ID();
                            seqNo = 10;
                        }
                        MPPForecastDefinitionLine line = new MPPForecastDefinitionLine(this.getCtx(), 0, this.get_TrxName());
                        line.setPP_ForecastDefinition_ID(id_Fore);
                        line.setM_Product_Group_ID(ID_PGroup);
                        line.set_CustomColumn("M_Locator_ID", ID_Locator);
                        line.set_CustomColumn("Date1", DateUtils.convertDateddMMyyyy(cabecera[idCol]));
                        line.set_CustomColumn("Qty", (BigDecimal)decimalFormat.parse(((String[])datosF.get(x))[idCol]));
                        line.setSeqNo(seqNo);
                        line.save(this.get_TrxName());
                        ++seqNo;
                        if (++idCol != 12) continue;
                        flag = -1;
                    }
                }
                ++x;
            }
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        this.commitEx();
        String pFileM = rutaArchivo = OFBForward.CencosudRutaMin();
        ArrayList<String[]> datosM = new ArrayList<String[]>();
        cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFileM);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datosM.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datosM.toString());
            int x = 1;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datosM.get(x))[0] + "'");
                int ID_PGroup = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Product_Group_ID) FROM M_Product_Group WHERE IsActive = 'Y' AND upper(value) like '" + ((String[])datosM.get(x))[1].toUpperCase() + "'");
                BigDecimal qty = (BigDecimal)decimalFormat.parse(((String[])datosM.get(x))[3].trim());
                if (ID_Locator > 0 && ID_PGroup > 0 && qty != null) {
                    DB.executeUpdate("DELETE FROM M_Product_GroupReplenish WHERE IsActive = 'Y' AND M_Locator_ID = " + ID_Locator + " AND M_Product_Group_ID=" + ID_PGroup, this.get_TrxName());
                    X_M_Product_GroupReplenish rep = new X_M_Product_GroupReplenish(this.getCtx(), 0, this.get_TrxName());
                    rep.setAD_Org_ID(0);
                    rep.setM_Locator_ID(ID_Locator);
                    rep.setM_Product_Group_ID(ID_PGroup);
                    rep.setLevel_Min(qty);
                    rep.save(this.get_TrxName());
                }
                ++x;
            }
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        String pFileTV = rutaArchivo = OFBForward.CencosudRutaTetrisV();
        ArrayList<String[]> datosTV = new ArrayList<String[]>();
        cantLines = 0;
        FileInputStream fis = new FileInputStream(pFileTV);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
        BufferedReader br = new BufferedReader(isr);
        String linea = br.readLine();
        while (linea != null) {
            if (linea.substring(linea.length() - 1).compareTo(";") == 0) {
                linea = String.valueOf(linea) + "-";
            }
            datosTV.add(linea.split(";"));
            linea = br.readLine();
            ++cantLines;
        }
        br.close();
        isr.close();
        fis.close();
        DB.executeUpdate("DELETE FROM M_Inventory WHERE IsActive = 'Y' AND  docstatus IN ('DR')", this.get_TrxName());
        int x = 2;
        while (x < cantLines) {
            int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datosTV.get(x))[0] + "'");
            if (ID_Locator > 0) {
                MLocator loc = new MLocator(this.getCtx(), ID_Locator, this.get_TrxName());
                int y = 8;
                while (y <= 15) {
                    if (((String[])datosTV.get(x))[y] != null && ((String[])datosTV.get(x))[y].trim().length() > 0 && ((String[])datosTV.get(x))[y].trim().compareTo("-") != 0) {
                        MInventory inv = new MInventory(this.getCtx(), 0, this.get_TrxName());
                        inv.set_CustomColumn("M_Locator_ID", ID_Locator);
                        inv.set_CustomColumn("ViaAbast", ((String[])datosTV.get(x))[1]);
                        inv.set_CustomColumn("DayOrder", this.devuelveDia(((String[])datosTV.get(x))[y]));
                        inv.set_CustomColumn("DayReception", this.devuelveDia(((String[])datosTV.get(1))[y]));
                        int dayOrder = Integer.parseInt(this.devuelveDia(((String[])datosTV.get(x))[y]));
                        int dayReception = Integer.parseInt(this.devuelveDia(((String[])datosTV.get(1))[y]));
                        int dif = 0;
                        if (dayOrder < dayReception) {
                            dif = dayReception - dayOrder;
                        } else if (dayReception < dayOrder) {
                            dif = 8 - dayOrder;
                            dif += dayReception - 1;
                        }
                        inv.set_CustomColumn("Days", dif);
                        inv.setM_Warehouse_ID(loc.getM_Warehouse_ID());
                        inv.saveEx(this.get_TrxName());
                    }
                    ++y;
                }
                String sqlSec = "select M_Inventory_ID,viaAbast from M_Inventory where m_locator_id = " + ID_Locator + " order by viaAbast, dayorder";
                CPreparedStatement pstmtSec = null;
                pstmtSec = DB.prepareStatement(sqlSec, this.get_TrxName());
                ResultSet rsSec = null;
                rsSec = pstmtSec.executeQuery();
                int ind = 1;
                String viaAbastValid = "";
                while (rsSec.next()) {
                    if (viaAbastValid.compareTo(rsSec.getString("viaAbast")) != 0) {
                        ind = 1;
                    }
                    DB.executeUpdate("UPDATE M_Inventory SET sequence = " + ind + " WHERE M_Inventory_ID = " + rsSec.getInt("M_Inventory_ID"), this.get_TrxName());
                    ++ind;
                    viaAbastValid = rsSec.getString("viaAbast");
                }
            }
            ++x;
        }
        this.commitEx();
        MProductCategory pCat = new MProductCategory(this.getCtx(), this.p_ID_PCategory, this.get_TrxName());
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setClientOrg(Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
        order.setC_DocTypeTarget_ID(2000140);
        order.setIsSOTrx(false);
        order.setC_BPartner_ID(2001562);
        order.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
        order.setBill_BPartner_ID(2001562);
        order.setDescription("Pedido Generado automaticamente. " + pCat.getName());
        order.setM_PriceList_ID(2000005);
        order.setM_Warehouse_ID(2000002);
        order.setSalesRep_ID(2000012);
        order.setAD_OrgTrx_ID(Env.getAD_Org_ID(this.getCtx()));
        order.setDateOrdered(this.p_dateTrx);
        order.setDatePromised(this.p_dateTrx);
        order.setDateAcct(this.p_dateInv);
        order.setC_ConversionType_ID(114);
        order.saveEx(this.get_TrxName());
        int cantLine = 10;
        String sql = "SELECT M_Locator_ID, pg.M_Product_Group_ID FROM M_Product_Group pg INNER JOIN M_Product_GroupReplenish mi ON (pg.M_Product_Group_ID = mi.M_Product_Group_ID ) WHERE M_Product_Category_ID = " + this.p_ID_PCategory + " GROUP BY M_Locator_ID, pg.M_Product_Group_ID";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, this.get_TrxName());
        ResultSet rs = null;
        rs = pstmt.executeQuery();
        while (rs.next()) {
            BigDecimal aux;
            BigDecimal q2;
            BigDecimal q3;
            BigDecimal q4;
            BigDecimal q5;
            BigDecimal qtyInv;
            BigDecimal kgCaja;
            MLocator loc = new MLocator(this.getCtx(), rs.getInt("M_Locator_ID"), this.get_TrxName());
            if (this.p_dateTrx == null) continue;
            int dayWeek = this.p_dateTrx.getDay() + 1;
            String dayW = "0" + dayWeek;
            String viaAbast = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(ViaAbast) FROM M_Product_GroupActive  WHERE M_Locator_ID = " + loc.get_ID() + " AND M_Product_Group_ID = ?", rs.getInt("M_Product_Group_ID"));
            int exist = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM M_Inventory  WHERE IsActive = 'Y' AND M_Locator_ID = " + loc.get_ID() + " AND DayOrder = '" + dayW + "' AND ViaAbast = '" + viaAbast + "'");
            if (exist <= 0) continue;
            if (rs.getInt("M_Product_Group_ID") == 2000022 && loc.get_ID() == 2000030) {
                this.log.config("log debug");
            }
            int cantD = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(Days) FROM M_Inventory  WHERE IsActive = 'Y' AND M_Locator_ID = " + loc.get_ID() + " AND DayOrder = '" + dayW + "' AND ViaAbast = '" + viaAbast + "'");
            Timestamp newDate = this.p_dateTrx;
            if (cantD > 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(this.p_dateTrx.getTime());
                cal.add(5, cantD);
                newDate = new Timestamp(cal.getTimeInMillis());
            }
            if ((kgCaja = DB.getSQLValueBD(this.get_TrxName(), "SELECT Qty FROM M_Product_Group WHERE M_Product_Group_ID = " + rs.getInt("M_Product_Group_ID"), new Object[0])) == null) {
                kgCaja = Env.ONE;
            }
            if ((qtyInv = DB.getSQLValueBD(this.get_TrxName(), "SELECT QtyMultiplier FROM M_Product_Group WHERE M_Product_Group_ID = " + rs.getInt("M_Product_Group_ID"), new Object[0])) == null) {
                qtyInv = Env.ONE;
            }
            if ((q5 = DB.getSQLValueBD(this.get_TrxName(), "SELECT MAX(Level_Min) FROM M_Product_GroupReplenish WHERE IsActive='Y'  AND M_Locator_ID=" + loc.get_ID() + " AND M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID"), new Object[0])) == null) {
                q5 = Env.ZERO;
            }
            if ((q4 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM PP_ForecastDefinitionLine WHERE IsActive='Y'  AND M_Locator_ID=" + loc.get_ID() + " AND M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID") + " AND Date1 Between ? AND ?", this.p_dateTrx, newDate)) == null) {
                q4 = Env.ZERO;
            }
            if ((q3 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(MovementQty) FROM I_OrderCencosud o INNER JOIN M_Product mp ON (o.M_Product_ID = mp.M_Product_ID) WHERE o.IsActive = 'Y' AND o.M_Locator_ID=" + loc.get_ID() + " AND mp.M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID") + " AND o.DateTrx Between ? AND ?", this.p_dateTrx, newDate)) == null) {
                q3 = Env.ZERO;
            }
            if ((q2 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(QtyOnHand) FROM I_InventoryCencosud WHERE IsActive='Y'  AND M_Locator_ID=" + loc.get_ID() + " AND M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID"), new Object[0])) == null) {
                q2 = Env.ZERO;
            }
            q2 = q2.multiply(qtyInv);
            Timestamp p_dateTrxTemp = DateUtils.addDays(this.p_dateTrx, -1);
            BigDecimal q3Temp = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(MovementQty) FROM I_OrderCencosud o INNER JOIN M_Product mp ON (o.M_Product_ID = mp.M_Product_ID) WHERE o.IsActive = 'Y' AND o.M_Locator_ID=" + loc.get_ID() + " AND mp.M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID") + " AND o.DateTrx Between ? AND ?", this.p_dateInv, p_dateTrxTemp);
            if (q3Temp == null) {
                q3Temp = Env.ZERO;
            }
            q2 = q2.add(q3Temp);
            BigDecimal q4Temp = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM PP_ForecastDefinitionLine WHERE IsActive='Y'  AND M_Locator_ID=" + loc.get_ID() + " AND M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID") + " AND Date1 Between ? AND ?", this.p_dateInv, p_dateTrxTemp);
            if (q4Temp == null) {
                q4Temp = Env.ZERO;
            }
            q2 = q2.subtract(q4Temp);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(newDate.getTime());
            cal.add(5, 1);
            Timestamp startDateP2 = new Timestamp(cal.getTimeInMillis());
            int seq = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(Sequence) FROM M_Inventory  WHERE IsActive = 'Y' AND M_Locator_ID=" + loc.get_ID() + " AND DayOrder = '" + dayW + "'");
            if (++seq == 4) {
                seq = 1;
            }
            String dayFinP2Str = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(DayReception) FROM M_Inventory  WHERE IsActive = 'Y' AND M_Locator_ID=" + loc.get_ID() + " AND Sequence = " + seq, new Object[0]);
            int dayFinP2 = 0;
            if (dayFinP2Str == null) continue;
            dayFinP2 = Integer.parseInt(dayFinP2Str);
            dayWeek = startDateP2.getDay() + 1;
            cal = Calendar.getInstance();
            cal.setTimeInMillis(startDateP2.getTime());
            while (dayWeek != dayFinP2) {
                cal.add(5, 1);
                if (++dayWeek != 9) continue;
                dayWeek = 2;
            }
            Timestamp endDateP2 = new Timestamp(cal.getTimeInMillis());
            BigDecimal q1 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM PP_ForecastDefinitionLine WHERE IsActive='Y'  AND M_Locator_ID=" + loc.get_ID() + " AND M_Product_Group_ID=" + rs.getInt("M_Product_Group_ID") + " AND Date1 Between ? AND ?", startDateP2, endDateP2);
            if (q1 == null) {
                q1 = Env.ZERO;
            }
            if ((aux = q2.add(q3).subtract(q4)) == null || aux.compareTo(Env.ZERO) <= 0) {
                aux = Env.ZERO;
            }
            BigDecimal qtyTotal = q1;
            qtyTotal = qtyTotal.subtract(aux);
            qtyTotal = qtyTotal.add(q5);
            MOrderLine line = new MOrderLine(order);
            line.setLine(cantLine);
            line.setM_Product_ID(2004195);
            line.setQty(qtyTotal);
            line.setPrice();
            line.setTax();
            line.setLineNetAmt();
            line.setC_Tax_ID(2000002);
            line.setDescription("Cantidades: Q1=" + q1 + " / Q2=" + q2 + " / Q3=" + q3 + " / Q4=" + q4 + " / Q5=" + q5 + " / Pedido=" + qtyTotal.divide(kgCaja, 0, RoundingMode.HALF_EVEN) + " cajas." + " valores temporales: q3Temp=" + q3Temp + " q4Temp=" + q4Temp);
            line.set_CustomColumn("M_Locator_ID", loc.get_ID());
            line.set_CustomColumn("Q1", q1);
            line.set_CustomColumn("Q2", q2);
            line.set_CustomColumn("Q2Box", q2.divide(qtyInv, 0, RoundingMode.HALF_EVEN));
            line.set_CustomColumn("Q3", q3);
            line.set_CustomColumn("Q4", q4);
            line.set_CustomColumn("Q5", q5);
            line.set_CustomColumn("qty", qtyTotal.divide(kgCaja, 0, RoundingMode.HALF_EVEN));
            line.setDatePromised(newDate);
            line.set_CustomColumn("M_Product_Group_ID", rs.getInt("M_Product_Group_ID"));
            line.saveEx(this.get_TrxName());
            cantLine += 10;
        }
        rs.close();
        rs = null;
        pstmt.close();
        pstmt = null;
        return "ORDEN GENERADA " + order.getDocumentNo();
    }

    public String devuelveDia(String valor) {
        if (valor == null) {
            return "";
        }
        if (valor.compareToIgnoreCase("LU") == 0) {
            return "02";
        }
        if (valor.compareToIgnoreCase("MA") == 0) {
            return "03";
        }
        if (valor.compareToIgnoreCase("W") == 0 || valor.compareToIgnoreCase("MI") == 0) {
            return "04";
        }
        if (valor.compareToIgnoreCase("JU") == 0) {
            return "05";
        }
        if (valor.compareToIgnoreCase("VI") == 0 || valor.compareToIgnoreCase("SAI") == 0) {
            return "06";
        }
        if (valor.compareToIgnoreCase("SA") == 0) {
            return "07";
        }
        if (valor.compareToIgnoreCase("DO") == 0) {
            return "08";
        }
        return "";
    }
}

