/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.blumos.model.BlumosUtilities;
import org.compiere.model.MUser;
import org.compiere.model.X_T_BL_VAC_MOVIMIENTOS;
import org.compiere.model.X_T_BL_VAC_SOLICITUD;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessVacations
extends SvrProcess {
    private int Record_ID;
    private String p_Action;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DocAction")) {
                this.p_Action = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        CPreparedStatement pstmtSM;
        String sendMail;
        String el_correo;
        String el_subject;
        X_T_BL_VAC_SOLICITUD solVac = new X_T_BL_VAC_SOLICITUD(this.getCtx(), this.Record_ID, this.get_TrxName());
        MUser user = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        String v_mail_usuario = DB.getSQLValueString(this.get_TrxName(), "SELECT damemail(bp.c_bpartner_id,1) FROM c_bpartner bp  inner join t_bl_cargos tc on (bp.t_bl_cargos_id=tc.t_bl_cargos_id) left join c_bpartner bpj on (tc.supervisor_id=bpj.t_bl_cargos_id) where bp.c_bpartner_id=?", solVac.getC_BPartner_ID());
        String v_mail_jefe = DB.getSQLValueString(this.get_TrxName(), "SELECT damemail(bpj.c_bpartner_id,1) FROM c_bpartner bp  inner join t_bl_cargos tc on (bp.t_bl_cargos_id=tc.t_bl_cargos_id) left join c_bpartner bpj on (tc.supervisor_id=bpj.t_bl_cargos_id) where bp.c_bpartner_id=?", solVac.getC_BPartner_ID());
        int cargo_id = DB.getSQLValue(this.get_TrxName(), "SELECT tc.t_bl_cargos_id FROM c_bpartner bp  inner join t_bl_cargos tc on (bp.t_bl_cargos_id=tc.t_bl_cargos_id) left join c_bpartner bpj on (tc.supervisor_id=bpj.t_bl_cargos_id) where bp.c_bpartner_id=?", user.getC_BPartner_ID());
        String v_mail_gerente = BlumosUtilities.DameMail(solVac.getC_BPartner_ID(), 2, this.getCtx(), this.get_TrxName());
        MUser updatedBy = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        String pptext = "";
        pptext = solVac.isPROGRESIVO() ? "SI" : "NO";
        if (this.p_Action.compareTo("SO") == 0 && solVac.getDocStatus().compareTo("DR") == 0) {
            if (solVac.getDESDE() == null) {
                throw new AdempiereException("DEBE ESPECIFICAR FECHA DE INICIO DE FERIADO. PUSO: " + solVac.getDESDE());
            }
            if (solVac.getHASTA() == null) {
                throw new AdempiereException("DEBE ESPECIFICAR FECHA DE FIN DE FERIADO. PUSO: " + solVac.getHASTA());
            }
            if (solVac.getHASTA().compareTo(solVac.getDESDE()) < 0) {
                throw new AdempiereException("FECHA DE FIN NO PUEDE SER ANTERIOR A FECHA DE INICIO. PUSO DESDE: " + solVac.getDESDE() + " HASTA: " + solVac.getHASTA());
            }
            if (solVac.getDIAS().compareTo(new BigDecimal("0.5")) == 0 && BlumosUtilities.DameDiasHabiles(solVac.getDESDE(), solVac.getHASTA(), this.getCtx(), this.get_TrxName()) != 1) {
                throw new AdempiereException("RANGO DE FECHAS EXCESIVO PARA SOLICITAR MEDIO DIA DE VACACIONES. CAMBIE EL RANGO DE FECHAS O VERIFIQUE QUE ESTE SOLICITANDO UN DIA H\u00c1BIL");
            }
            if (solVac.getDESDE().getMonth() != solVac.getHASTA().getMonth()) {
                throw new AdempiereException(" FECHA DE INICIO Y FIN DEBE ESTAR EN EL MISMO MES. PUSO DESDE: " + solVac.getDESDE() + " HASTA " + solVac.getHASTA());
            }
            if (BlumosUtilities.DameVacFechaUsada(solVac.getC_BPartner_ID(), solVac.getDESDE(), solVac.getHASTA(), this.getCtx(), this.get_TrxName())) {
                throw new AdempiereException(" YA HA SOLICITADO VACACIONES EN UNO O MAS DIAS INCLUIDOS EN EL RANGO DE FECHAS. REVISE SU HISTORIAL ");
            }
            if (solVac.getCOMENTARIOS() == null || solVac.getCOMENTARIOS().trim().length() < 1) {
                throw new AdempiereException(" DEBE INGRESAR ALGUN COMENTARIO  ");
            }
            el_subject = "Solicitud de vacaciones";
            el_correo = "<pre>" + el_subject + ", Trabajador: " + solVac.getC_BPartner().getName() + " \n " + " Fecha Solicitud: " + BlumosUtilities.formatDate(solVac.getFECHA_MOVIMIENTO(), true) + " \n " + " Descripci\u00f3n: " + solVac.getCOMENTARIOS() + " \n \n " + " D\u00edas solicitados: " + solVac.getDIAS() + ", Desde: " + BlumosUtilities.formatDate(solVac.getDESDE(), true) + " Hasta " + BlumosUtilities.formatDate(solVac.getHASTA(), true) + " \n " + " Progresivo: " + pptext + " \n \n " + " Saldos ANTES de esta solicitud: \n " + " D\u00edas Normales: " + solVac.getSALDO_NORMAL() + " \n " + " D\u00edas proporcionales: " + solVac.getSALDO_PP() + " \n " + " D\u00edas Progresivos: " + solVac.getSALDO_PROGRESIVO() + " \n " + " Saldo TOTAL: " + solVac.getSALDO_TOTAL() + " \n \n " + " Generado por: " + updatedBy.getName();
            this.log.config("correo: " + el_correo);
            sendMail = "SELECT send_mail('adempiere@blumos.cl','" + v_mail_jefe + "','" + v_mail_usuario + "'|| ',' ||'" + v_mail_gerente + "','cmendoza@blumos.cl','" + el_subject + "','" + el_correo + "</pre>')";
            pstmtSM = DB.prepareStatement(sendMail, this.get_TrxName());
            pstmtSM.execute();
            solVac.setDocStatus("IP");
            solVac.save(this.get_TrxName());
        }
        if (this.p_Action.compareTo("AP") == 0 && solVac.getDocStatus().compareTo("IP") == 0) {
            if (solVac.getDIAS().compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("NO PUEDE SOLICITAR 0 DIAS");
            }
            String v_raiz = DB.getSQLValueString(this.get_TrxName(), "SELECT t_bl_cargos.raiz FROM c_bpartner inner join t_bl_cargos on (c_bpartner.t_bl_cargos_id=t_bl_cargos.t_bl_cargos_id) where c_bpartner_id=" + solVac.getC_BPartner_ID(), new Object[0]);
            if (solVac.getC_BPartner_ID() == updatedBy.getC_BPartner_ID() && v_raiz.compareTo("Y") != 0) {
                solVac.setAPROBAR(false);
                throw new AdempiereException("NO PUEDE APROBAR SUS PROPIAS VACACIONES: " + updatedBy.getName() + " = " + solVac.getC_BPartner().getName() + " (ID:" + solVac.getC_BPartner_ID() + "=" + updatedBy.getC_BPartner_ID());
            }
            if (BlumosUtilities.DameVacFechaUsada(solVac.getC_BPartner_ID(), solVac.getDESDE(), solVac.getHASTA(), this.getCtx(), this.get_TrxName())) {
                throw new AdempiereException("YA SE HA APROBADO VACACIONES EN UNO O MAS DIAS INCLUIDOS EN EL RANGO DE FECHAS. REVISE EL HISTORIAL");
            }
            if (!BlumosUtilities.IsDependiente(solVac.getC_BPartner_ID(), cargo_id, this.getCtx(), this.get_TrxName())) {
                throw new AdempiereException("NO PUEDE APROBAR ESTA SOLICITUD, " + solVac.getC_BPartner().getName() + " NO EST\u00c1 BAJO SU DEPENDENCIA");
            }
            String el_subject2 = "Solicitud de vacaciones APROBADA";
            String el_correo2 = "<pre>" + el_subject2 + ", Trabajador: " + solVac.getC_BPartner().getName() + " \n " + " Fecha Solicitud: " + BlumosUtilities.formatDate(solVac.getFECHA_MOVIMIENTO(), true) + " \n " + " Descripci\u00f3n: " + solVac.getCOMENTARIOS() + " \n \n " + " D\u00edas solicitados: " + solVac.getDIAS() + ", Desde: " + BlumosUtilities.formatDate(solVac.getDESDE(), true) + " Hasta " + BlumosUtilities.formatDate(solVac.getHASTA(), true) + " \n " + " Progresivo: " + pptext + " \n \n " + " Saldos ANTES de esta solicitud: \n " + " D\u00edas Normales: " + solVac.getSALDO_NORMAL() + " \n " + " D\u00edas proporcionales: " + solVac.getSALDO_PP() + " \n " + " D\u00edas Progresivos: " + solVac.getSALDO_PROGRESIVO() + " \n " + " Saldo TOTAL: " + solVac.getSALDO_TOTAL() + " \n \n " + " Solicitud APROBADA por: " + updatedBy.getName();
            this.log.config("correo: " + el_correo2);
            String sendMail2 = "SELECT send_mail('adempiere@blumos.cl','" + v_mail_jefe + "','" + v_mail_usuario + "'|| ',' ||'" + v_mail_gerente + ",ltoloza@blumos.cl','cmendoza@blumos.cl','" + el_subject2 + "','" + el_correo2 + "</pre>')";
            CPreparedStatement pstmtSM2 = DB.prepareStatement(sendMail2, this.get_TrxName());
            pstmtSM2.execute();
            X_T_BL_VAC_MOVIMIENTOS newMov = new X_T_BL_VAC_MOVIMIENTOS(this.getCtx(), 0, this.get_TrxName());
            newMov.setAD_Org_ID(solVac.getAD_Org_ID());
            newMov.setC_BPartner_ID(solVac.getC_BPartner_ID());
            newMov.setFECHA_MOVIMIENTO(solVac.getFECHA_MOVIMIENTO());
            newMov.setTIPO_MOVIMIENTO("C");
            newMov.setDESDE(solVac.getDESDE());
            newMov.setHASTA(solVac.getHASTA());
            newMov.setPROGRESIVO(solVac.isPROGRESIVO());
            newMov.setDIAS(solVac.getDIAS().negate());
            newMov.setCOMENTARIOS(solVac.getCOMENTARIOS());
            newMov.setProcessed(true);
            newMov.setIMPRIME_COMPROBANTE("N");
            newMov.setT_BL_VAC_SOLICITUD_ID(solVac.get_ID());
            newMov.save(this.get_TrxName());
            solVac.setProcessed(true);
            solVac.setDocStatus("CO");
            solVac.setT_BL_VAC_MOVIMIENTOS_ID(newMov.get_ID());
            solVac.saveEx(this.get_TrxName());
        }
        if (this.p_Action.compareTo("VO") == 0 && !solVac.isProcessed()) {
            if (solVac.getC_BPartner_ID() == updatedBy.getC_BPartner_ID()) {
                solVac.setANULAR(false);
                solVac.save(this.get_TrxName());
                throw new AdempiereException("NO PUEDE ANULAR SUS PROPIAS VACACIONES: " + updatedBy.getName() + " = " + solVac.getC_BPartner().getName() + " (ID:" + solVac.getC_BPartner_ID() + "=" + updatedBy.getC_BPartner_ID());
            }
            solVac.setProcessed(true);
            solVac.setDocStatus("VO");
            solVac.save(this.get_TrxName());
            el_subject = "Solicitud de vacaciones DENEGADA";
            el_correo = String.valueOf(el_subject) + ", Trabajador: " + solVac.getC_BPartner().getName() + " \n " + " Fecha Solicitud: " + BlumosUtilities.formatDate(solVac.getFECHA_MOVIMIENTO(), true) + " \n " + " Descripci\u00f3n: " + solVac.getCOMENTARIOS() + " \n \n " + " D\u00edas solicitados: " + solVac.getDIAS() + ", Desde: " + BlumosUtilities.formatDate(solVac.getDESDE(), true) + " Hasta " + BlumosUtilities.formatDate(solVac.getHASTA(), true) + " \n " + " Progresivo: " + pptext + " \n \n " + " Saldos ANTES de esta solicitud: \n " + " D\u00edas Normales: " + solVac.getSALDO_NORMAL() + " \n " + " D\u00edas proporcionales: " + solVac.getSALDO_PP() + " \n " + " D\u00edas Progresivos: " + solVac.getSALDO_PROGRESIVO() + " \n " + " Saldo TOTAL: " + solVac.getSALDO_TOTAL() + " \n \n " + " Solicitud RECHAZADA por: : " + updatedBy.getName();
            this.log.config("correo: " + el_correo);
            sendMail = "SELECT send_mail('adempiere@blumos.cl','" + v_mail_jefe + "','" + v_mail_usuario + "'|| ',' ||'" + v_mail_gerente + "','cmendoza@blumos.cl','" + el_subject + "','" + el_correo + "</pre>')";
            pstmtSM = DB.prepareStatement(sendMail, this.get_TrxName());
            pstmtSM.execute();
        }
        if (this.p_Action.compareTo("RE") == 0 && solVac.isProcessed()) {
            if (solVac.getC_BPartner_ID() == updatedBy.getC_BPartner_ID()) {
                solVac.setANULAR(false);
                solVac.save(this.get_TrxName());
                throw new AdempiereException("NO PUEDE ANULAR SUS PROPIAS VACACIONES: " + updatedBy.getName() + " = " + solVac.getC_BPartner().getName() + " (ID:" + solVac.getC_BPartner_ID() + "=" + updatedBy.getC_BPartner_ID());
            }
            solVac.setProcessed(true);
            solVac.setDocStatus("VO");
            solVac.save(this.get_TrxName());
            X_T_BL_VAC_MOVIMIENTOS newMov = new X_T_BL_VAC_MOVIMIENTOS(this.getCtx(), 0, this.get_TrxName());
            newMov.setAD_Org_ID(solVac.getAD_Org_ID());
            newMov.setC_BPartner_ID(solVac.getC_BPartner_ID());
            newMov.setFECHA_MOVIMIENTO(solVac.getFECHA_MOVIMIENTO());
            newMov.setTIPO_MOVIMIENTO("C");
            newMov.setDESDE(solVac.getDESDE());
            newMov.setHASTA(solVac.getHASTA());
            newMov.setPROGRESIVO(solVac.isPROGRESIVO());
            newMov.setDIAS(solVac.getDIAS());
            newMov.setCOMENTARIOS("ANULA ID " + solVac.getT_BL_VAC_MOVIMIENTOS_ID());
            newMov.setProcessed(true);
            newMov.setIMPRIME_COMPROBANTE("N");
            newMov.setT_BL_VAC_SOLICITUD_ID(solVac.get_ID());
            newMov.save(this.get_TrxName());
            solVac.setProcessed(true);
            solVac.setDocStatus("VO");
            solVac.setT_BL_VAC_MOVIMIENTOS_ID(newMov.get_ID());
            solVac.save(this.get_TrxName());
        }
        return "Solicitud de Vacaciones ID " + solVac.get_ID() + " ejecutado. DIAS:" + BlumosUtilities.DameDiasHabiles(solVac.getDESDE(), solVac.getHASTA(), this.getCtx(), this.get_TrxName());
    }
}

