/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModBlumosFechaInOut
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosFechaInOut.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInOut.Table_ID) {
            MInOut InOut = (MInOut)po;
            if (InOut.getDocStatus().compareTo("VO") != 0 || InOut.getDocStatus().compareTo("RE") != 0) {
                DB.executeUpdate("UPDATE C_Order SET isSelected='N'  WHERE C_Order_id = " + InOut.getC_Order_ID(), po.get_TrxName());
            }
            Timestamp today = new Timestamp(System.currentTimeMillis());
            today.setHours(0);
            today.setMinutes(0);
            today.setSeconds(0);
            today.setNanos(0);
            Timestamp movDay = InOut.getMovementDate();
            movDay.setHours(0);
            movDay.setMinutes(0);
            movDay.setSeconds(0);
            movDay.setNanos(0);
            if (InOut.getM_Warehouse_ID() == 1000000) {
                if (movDay.compareTo(today) != 0 && InOut.getDocStatus().compareTo("CO") != 0 && InOut.getDocStatus().compareTo("CL") != 0 && InOut.getDocStatus().compareTo("VO") != 0) {
                    InOut.set_CustomColumn("Bandera_Fecha", false);
                } else {
                    InOut.set_CustomColumn("Bandera_Fecha", true);
                }
            } else {
                InOut.set_CustomColumn("Bandera_Fecha", true);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInOut InOut;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 1 && po.get_Table_ID() == MInOut.Table_ID) {
            InOut = (MInOut)po;
            InOut.set_CustomColumn("Bandera_Fecha", false);
            InOut.save(po.get_TrxName());
        }
        if (timing == 10 && po.get_Table_ID() == MInOut.Table_ID && (InOut = (MInOut)po).getC_Order_ID() > 0 && InOut.isSOTrx()) {
            DB.executeUpdate("UPDATE C_Order SET isSelected='Y'  WHERE C_Order_id = " + InOut.getC_Order_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

