/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModBlumosAsignaVendedor
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosAsignaVendedor.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)po;
            if (order.isSOTrx()) {
                BigDecimal qty;
                if (order.getC_DocTypeTarget_ID() == 1000029) {
                    order.setDeliveryRule("F");
                }
                if (Env.getAD_Role_ID(po.getCtx()) == 1000020) {
                    order.setSalesRep_ID(Env.getAD_User_ID(po.getCtx()));
                }
                if ((qty = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(ol.qty) FROM c_orderline ol WHERE ol.c_order_id=" + order.get_ID(), new Object[0])) == null) {
                    qty = Env.ZERO;
                }
                if (qty.compareTo(Env.ZERO) == 0) {
                    order.set_CustomColumn("Signature3", true);
                } else {
                    order.set_CustomColumn("Signature3", false);
                }
                if (order.getC_DocTypeTarget_ID() == 1000057) {
                    order.setBill_BPartner_ID(1001197);
                }
                if (order.getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("CL") != 0) {
                    if (!order.get_ValueAsBoolean("signature1") && order.getAD_Client_ID() == 1000000) {
                        order.set_CustomColumn("IsSelected", false);
                    } else {
                        order.set_CustomColumn("IsSelected", false);
                        if (order.getC_DocTypeTarget_ID() == 1000029) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000030 && qty.compareTo(Env.ZERO) == 0) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000033) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000050 && order.getM_Warehouse_ID() != 1000000) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000054 && qty.compareTo(Env.ZERO) == 0) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000056) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000057 && qty.compareTo(Env.ZERO) == 0) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getC_DocTypeTarget_ID() == 1000057 && qty.compareTo(Env.ZERO) == 0) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                        if (order.getAD_Client_ID() != 1000000 && qty.compareTo(Env.ZERO) == 0) {
                            order.set_CustomColumn("IsSelected", true);
                        }
                    }
                }
            }
            if (order.getC_BPartner().getPaymentRule() != null && order.getPaymentRule() != null && order.getC_BPartner().getPaymentRule().compareTo(order.getPaymentRule()) != 0) {
                order.setPaymentRule(order.getC_BPartner().getPaymentRule());
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

