/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProcessPurchaseOrder
extends SvrProcess {
    private int p_Order_ID = 0;
    private String p_Action = "PR";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Order_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Order_ID > 0) {
            MOrder ord = new MOrder(this.getCtx(), this.p_Order_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (ord.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "IP";
                newAction = "IP";
            } else if (ord.getDocStatus().compareTo("IP") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (ord.getDocStatus().compareTo("IN") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "IP";
                newAction = "IP";
            } else if (ord.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (ord.getDocStatus().compareTo("IP") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            }
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID(this.getCtx()) + " AND C_DocType_ID = " + ord.getC_DocTypeTarget_ID());
            MOrderLine[] oLines = ord.getLines(false, null);
            int i = 0;
            while (i < oLines.length) {
                MOrderLine line = oLines[i];
                if (line.getC_Charge_ID() < 1 && line.getM_Product_ID() < 1) {
                    throw new AdempiereException(String.valueOf(Msg.getMsg(Env.getCtx(), "ARTILEC_NoLineNoProductOC", true)) + ". Linea " + line.getLine());
                }
                if (line.getPriceEntered().compareTo(Env.ZERO) == 0) {
                    throw new AdempiereException(String.valueOf(Msg.getMsg(Env.getCtx(), "ARTILEC_NoPriceOC", true)) + ". Linea " + line.getLine());
                }
                if (line.getQtyEntered().compareTo(Env.ZERO) == 0) {
                    throw new AdempiereException(String.valueOf(Msg.getMsg(Env.getCtx(), "ARTILEC_NoQtyOC", true)) + ". Linea " + line.getLine());
                }
                ++i;
            }
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                if (newAction.compareTo("CO") != 0) {
                    ord.setDocStatus(newStatus);
                    ord.save();
                    String ln = System.getProperty("line.separator");
                    StringBuilder str = new StringBuilder();
                    str.append("Estimados");
                    str.append(ln);
                    str.append(ln);
                    str.append("Se comunica que la orden " + ord.getDocumentNo());
                    str.append(ln);
                    str.append(" se encuentra en estado 'En Proceso' ");
                    str.append(ln);
                    MClient client = new MClient(ord.getCtx(), ord.getAD_Client_ID(), ord.get_TrxName());
                    String direccionenvio = "bcalderon@artilec.net";
                    EMail mail = new EMail(client, client.getRequestEMail(), direccionenvio, "Orden de Compra", str.toString());
                    mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                    mail.send();
                    this.log.config("Correo Enviado a " + direccionenvio);
                    this.log.config("Errores Correo: " + mail.getSentMsg());
                } else if (newAction.compareTo("CO") == 0) {
                    if (ord.getC_DocTypeTarget_ID() == 2000138) {
                        String sql = "select ad_attachment_id from ad_attachment where ad_table_id = 259 and record_id = " + ord.get_ID();
                        CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        ResultSet rs = pstmt.executeQuery();
                        int att = 0;
                        while (rs.next()) {
                            ++att;
                        }
                        if (att <= 0) {
                            throw new AdempiereException("No se ha encontrado adjuntos");
                        }
                    }
                    MUser usuario = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
                    this.log.config("usuario " + usuario.getName());
                    String sqlmonto = "SELECT ApprovalAmt from ad_user where ad_user_id = " + Env.getAD_User_ID(this.getCtx());
                    CPreparedStatement pstmt2 = DB.prepareStatement(sqlmonto, this.get_TrxName());
                    ResultSet rs2 = pstmt2.executeQuery();
                    BigDecimal montoaprobacion = Env.ZERO;
                    if (rs2.next()) {
                        montoaprobacion = rs2.getBigDecimal("ApprovalAmt");
                    }
                    this.log.config("monto aprob " + montoaprobacion);
                    if (ord.getCurrencyISO().compareToIgnoreCase("CLP") == 0) {
                        if (montoaprobacion.compareTo(ord.getGrandTotal()) < 0) {
                            throw new AdempiereException("Monto de aprobaci\u00f3n insuficiente");
                        }
                    } else if (ord.getCurrencyISO().compareToIgnoreCase("CLP") != 0) {
                        String sqlmoneda = "SELECT coalesce(DivideRate,0) from C_Conversion_Rate where isactive='Y' AND ValidFrom <= '" + ord.getDateOrdered() + "' AND ValidTo >= '" + ord.getDateOrdered() + "' AND C_Currency_ID = " + ord.getC_Currency_ID() + " AND C_Currency_ID_To =228";
                        BigDecimal dividerate = DB.getSQLValueBD(this.get_TrxName(), sqlmoneda, new Object[0]);
                        this.log.config("sql moneda " + sqlmoneda);
                        this.log.config("dividerate es " + dividerate);
                        if (dividerate.compareTo(Env.ZERO) <= 0) {
                            throw new AdempiereException("No hay tasa de cambio");
                        }
                        BigDecimal multiplicando = dividerate.multiply(ord.getGrandTotal());
                        this.log.config("monto oc " + multiplicando);
                        this.log.config("total oc  " + ord.getGrandTotal());
                        if (montoaprobacion.compareTo(multiplicando) < 0) {
                            throw new AdempiereException("Monto de aprobaci\u00f3n insuficiente");
                        }
                    }
                    ord.setDocStatus("IP");
                    ord.processIt("CO");
                    ord.save();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

