/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GDERestSendDocument
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = "";
        msg = this.CreateXMLCGBoleta(inv);
        return msg;
    }

    public String CreateXMLCGBoleta(MInvoice invoice) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        MOrg org = new MOrg(invoice.getCtx(), invoice.getAD_Org_ID(), invoice.get_TrxName());
        String fechaResolucion = org.get_ValueAsString("FchResol");
        int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "ID_" + invoice.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element FechaResolEle = document.createElement("FechaResol");
            Text textFchResol = document.createTextNode(fechaResolucion);
            FechaResolEle.appendChild(textFchResol);
            Encabezado2.appendChild(FechaResolEle);
            Element NroResolEle = document.createElement("NroResol");
            Text textNroResol = document.createTextNode(Integer.toString(numeroResolucion));
            NroResolEle.appendChild(textNroResol);
            Encabezado2.appendChild(NroResolEle);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element IndServicio = document.createElement("IndServicio");
            Text IndServTxt = document.createTextNode("1");
            IndServicio.appendChild(IndServTxt);
            IdDoc2.appendChild(IndServicio);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS(invoice.get_TrxName(), "SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", invoice.get_ID());
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue(invoice.get_TrxName(), "SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID());
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSocEmisor");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmisor");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            String dirRecepStr = String.valueOf(bloc.getLocation(true).getAddress1()) + "-" + bloc.getPhone();
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            String CmnaRecepStr = null;
            if (bloc.getLocation(true).getAddress2() != null) {
                CmnaRecepStr = bloc.getLocation(true).getAddress2();
            } else if (bloc.getLocation(true).getC_City_ID() > 0) {
                CmnaRecepStr = MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName();
            }
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            String ciudadTxt = "";
            ciudadTxt = bloc.getLocation(true).getC_Region_ID() == 1000001 || bloc.getLocation(true).getC_City_ID() <= 0 ? "SANTIAGO" : bloc.getC_Location().getCity();
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(ciudadTxt != null ? ciudadTxt : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            boolean lineDiscount = false;
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(++lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element cdgItem = document.createElement("CdgItem");
                    Detalle2.appendChild(cdgItem);
                    Element TpoCodigo = document.createElement("TpoCodigo");
                    Text descTpoCod = document.createTextNode("INT");
                    TpoCodigo.appendChild(descTpoCod);
                    cdgItem.appendChild(TpoCodigo);
                    Element VlrCodigo = document.createElement("VlrCodigo");
                    Text descVlrCod = document.createTextNode(iLine.getProduct().getValue());
                    VlrCodigo.appendChild(descVlrCod);
                    cdgItem.appendChild(VlrCodigo);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    if (iLine.getProduct() != null) {
                        pname = String.valueOf(iLine.getProduct().getValue()) + "-" + iLine.getProduct().getName();
                        if (iLine.getM_Product().getUPC() != null && iLine.getM_Product().getUPC().trim().length() > 0) {
                            pname = String.valueOf(pname) + iLine.getM_Product().getUPC();
                        }
                    } else {
                        pname = iLine.getC_Charge().getName();
                    }
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    String unmdItemStr = "";
                    unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                    if (unmdItemStr == null) {
                        unmdItemStr = "UN";
                    }
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UM = document.createTextNode(unmdItemStr);
                    UnmdItem.appendChild(UM);
                    Detalle2.appendChild(UnmdItem);
                    BigDecimal prcItem = null;
                    BigDecimal mntItem = null;
                    BigDecimal prcItemTax = null;
                    BigDecimal mntItemTax = null;
                    if (invoice.getC_DocType().getDocBaseType().compareToIgnoreCase("ARI") == 0 && invoice.getC_DocType().getName().toLowerCase().contains("boleta") && iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                        prcItemTax = iLine.getPriceActual().multiply(iLine.getC_Tax().getRate());
                        prcItemTax = prcItemTax.divide(Env.ONEHUNDRED);
                        prcItem = iLine.getPriceActual().add(prcItemTax);
                        mntItemTax = iLine.getLineNetAmt().multiply(iLine.getC_Tax().getRate());
                        mntItemTax = mntItemTax.divide(Env.ONEHUNDRED);
                        mntItem = iLine.getLineNetAmt().add(mntItemTax);
                    } else {
                        prcItem = iLine.getPriceActual();
                        mntItem = iLine.getLineNetAmt();
                    }
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(prcItem.setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(mntItem.setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            this.log.config("XML enviado: " + file.toString());
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception Item) {
                // empty catch block
            }
            this.log.config("XML enviado base64: " + encodedFile.toString());
            String ambiente = "T";
            if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                ambiente = "T";
            } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                ambiente = "P";
            }
            boolean tipoPdf417 = true;
            String apiURL = "http://192.168.0.200/api/Core.svc/Core";
            String apiAuth = OFBForward.GDEapiAuth();
            String ResponseText = "";
            try {
                String invokeURI = "http://192.168.0.200/api/Core.svc/core/SendDocumentAsXML";
                try {
                    String request = "<SendDocumentAsXMLRequest xmlns=\"http://gdexpress.cl/api\"><Environment>T</Environment>  <Content>" + encodedFile + "</Content>" + "<ResolutionDate>2019-01-01</ResolutionDate>" + "<ResolutionNumber>80</ResolutionNumber>" + "<PDF417Columns></PDF417Columns>" + "<PDF417Level></PDF417Level>" + "<PDF417Type></PDF417Type>" + "<TED></TED>" + "</SendDocumentAsXMLRequest>";
                    URL url = new URL(invokeURI);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("AuthKey", apiAuth);
                    conn.setRequestProperty("Accept", "application/xml");
                    conn.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.write(request.getBytes("UTF-8"));
                    wr.flush();
                    wr.close();
                    InputStream is = conn.getInputStream();
                    DataInputStream dis = new DataInputStream(is);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2028];
                    int read = 0;
                    while ((read = dis.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    byte[] ResponseBytes = baos.toByteArray();
                    ResponseText = new String(ResponseBytes);
                    System.out.println(ResponseText);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                invoice.set_CustomColumn("DescriptionGDE", ResponseText);
                invoice.saveEx(invoice.get_TrxName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG Generated " + wsRespuesta;
    }
}

