/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.Servicio;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.process.SvrProcess;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class GDEGetPDFInOut
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_InOut_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_M_InOut_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInOut ship = new MInOut(this.m_ctx, this.p_M_InOut_ID, this.get_TrxName());
        String msg = "";
        msg = this.GetPDF(ship);
        return msg;
    }

    public String GetPDF(MInOut inOut) {
        block15: {
            String ambiente = "T";
            if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                ambiente = "T";
            } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                ambiente = "P";
            }
            GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
            MOrg org = MOrg.get(inOut.getCtx(), inOut.getAD_Org_ID());
            String rut = (String)org.get_Value("Rut");
            MDocType docType = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
            int tipoDTE = 33;
            tipoDTE = docType.get_ValueAsString("DocumentNo").compareTo("33") == 0 ? 33 : (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0 ? 34 : (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0 ? 52 : (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0 ? 56 : (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0 ? 61 : 52))));
            long folio = Long.parseLong(inOut.getDocumentNo());
            String apiURL = "http://192.168.0.200/api/Core.svc/Core";
            String apiAuth = OFBForward.GDEapiAuth();
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoRecuperarPDF resultado = servicio.RecuperarPdf(ambiente, grupo, rut, tipoDTE, folio);
            if (resultado.getResultadoServicio().getEstado() == 0 || resultado.getResultadoServicio().getEstado() == 1) {
                this.log.config("datos Usados: apiURL=" + apiURL + " - apiAuth=" + apiAuth + " - ambiente=" + ambiente + " - grupo=" + grupo + " - rut=" + rut + " - tipoDTE=" + tipoDTE + " - folio=" + folio);
                this.log.config("log resultado: " + resultado.getResultadoServicio().getDescripcion() + " - " + resultado.getResultadoServicio().getExcepcionOriginal() + " - " + resultado.getResultadoServicio().getEstado());
                byte[] pdf = resultado.getDatos();
                if (pdf != null) {
                    String ExportDir = "";
                    try {
                        String pathServer = OFBForward.PathGDEServer();
                        String pathCliente = OFBForward.PathGDEClient();
                        if (pathServer == null || pathCliente == null || pathServer.trim().length() <= 0 || pathCliente.trim().length() <= 0) break block15;
                        File theDir = new File(pathServer);
                        if (!theDir.exists()) {
                            ExportDir = pathCliente;
                        }
                        this.log.config("Archivo a guardar: " + ExportDir + folio + ".pdf");
                        FileOutputStream out = new FileOutputStream(String.valueOf(ExportDir) + folio + ".pdf");
                        ((OutputStream)out).write(pdf);
                        ((OutputStream)out).close();
                        String remote_working_dir_path = OFBForward.GDEDirPath();
                        String local_filepath = String.valueOf(ExportDir) + folio + ".pdf";
                        String remote_filename = String.valueOf(folio) + ".pdf";
                        String finalURL = String.valueOf(OFBForward.GDERemoteURL()) + folio + ".pdf";
                        FTPClient client = new FTPClient();
                        try (FileInputStream fis = new FileInputStream(local_filepath);){
                            try {
                                client.setBufferSize(512);
                                client.connect(OFBForward.GDEFTPServer(), OFBForward.GDEFTPServerPort());
                                client.login(OFBForward.GDEFTPUser(), OFBForward.GDEFTPPass());
                                client.enterLocalPassiveMode();
                                client.setFileType(2);
                                client.changeWorkingDirectory(remote_working_dir_path);
                                boolean uploadFile = client.storeFile(remote_filename, (InputStream)fis);
                                client.logout();
                                client.disconnect();
                                if (!uploadFile) {
                                    throw new Exception("Error al subir el fichero");
                                }
                                inOut.set_CustomColumn("UrlGde", finalURL);
                                inOut.saveEx(this.get_TrxName());
                            }
                            catch (Exception eFTPClient) {
                                this.log.config("ERROR: " + eFTPClient.toString());
                                fis.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String error = resultado.getResultadoServicio().getDescripcion();
                return error;
            }
        }
        return null;
    }

    public void sendMail(MInvoice inv) {
        if (inv.getAD_User_ID() > 0 && inv.getAD_User().getEMail() != null && inv.getAD_User().getEMail().trim().length() > 0) {
            String ln = System.getProperty("line.separator");
            StringBuilder str = new StringBuilder();
            str.append("Estimado Usuario:");
            str.append(ln);
            str.append(ln);
            str.append("Se a generado la factura numero " + inv.getDocumentNo());
            str.append(ln);
            str.append(ln);
            str.append("URL: " + inv.get_ValueAsString("UrlGde"));
            MClient client = new MClient(this.getCtx(), inv.getAD_Client_ID(), this.get_TrxName());
            EMail mail = new EMail(client, client.getRequestEMail(), inv.getAD_User().getEMail(), "Factura n\u00famero " + inv.getDocumentNo(), str.toString());
            mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
            mail.send();
        }
    }
}

