/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_IndTraslado;
import DocumentoDTE.SiiDte.IdDoc_TipoDespacho;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.Servicio;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrg;
import org.compiere.model.X_C_Province;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class GDEExportDTEMoveArtilec
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_Inout_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_M_Inout_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MMovement mov = new MMovement(this.m_ctx, this.p_M_Inout_ID, this.get_TrxName());
        String msg = "";
        msg = this.CreateXML(mov);
        return msg;
    }

    public String CreateXML(MMovement mov) {
        String pdf417;
        String ted;
        String error;
        block65: {
            error = "";
            ted = "";
            pdf417 = "";
            try {
                DTEDefType dte = new DTEDefType();
                dte.setDTE_Choice(new DTE_Choice());
                MOrg org = MOrg.get(mov.getCtx(), mov.getAD_Org_ID());
                MDocType docType = new MDocType(mov.getCtx(), mov.getC_DocType_ID(), mov.get_TrxName());
                dte.getDTE_Choice().setDocumento(new Documento());
                Documento doc = dte.getDTE_Choice().getDocumento();
                doc.setEncabezado(new Encabezado());
                IdDoc idDoc = new IdDoc();
                if (docType.get_ValueAsString("DocumentNo").compareTo("33") == 0) {
                    idDoc.setTipoDTE(DTEType.n33);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0) {
                    idDoc.setTipoDTE(DTEType.n34);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0) {
                    idDoc.setTipoDTE(DTEType.n56);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0) {
                    idDoc.setTipoDTE(DTEType.n61);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0) {
                    idDoc.setTipoDTE(DTEType.n52);
                } else {
                    idDoc.setTipoDTE(DTEType.n52);
                }
                idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(mov.getDocumentNo())));
                idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(mov.getMovementDate())));
                idDoc.setTipoDespacho(IdDoc_TipoDespacho.n2);
                String IndTrl = "5";
                if (IndTrl.compareTo("1") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n1);
                } else if (IndTrl.compareTo("2") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n2);
                } else if (IndTrl.compareTo("3") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n3);
                } else if (IndTrl.compareTo("4") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n4);
                } else if (IndTrl.compareTo("5") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n5);
                } else if (IndTrl.compareTo("6") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n6);
                } else if (IndTrl.compareTo("7") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n7);
                } else if (IndTrl.compareTo("8") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n8);
                } else if (IndTrl.compareTo("9") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n9);
                }
                doc.getEncabezado().setIdDoc(idDoc);
                Emisor emisor = new Emisor();
                emisor.setRUTEmisor((String)org.get_Value("Rut"));
                String nameRzn = org.getDescription();
                if (nameRzn == null) {
                    nameRzn = " ";
                }
                if ((nameRzn = nameRzn.trim()).length() < 2) {
                    nameRzn = org.getName();
                }
                emisor.setRznSoc(nameRzn);
                String giroEmisStr = (String)org.get_Value("Giro");
                giroEmisStr = giroEmisStr.replace("'", "");
                giroEmisStr = giroEmisStr.replace("\"", "");
                emisor.setGiroEmis(giroEmisStr);
                emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("Acteco"))));
                emisor.setDirOrigen((String)org.get_Value("Address1"));
                emisor.setCmnaOrigen((String)org.get_Value("Comuna"));
                emisor.setCiudadOrigen((String)org.get_Value("City"));
                if (mov.getSalesRep_ID() > 0) {
                    emisor.setCdgVendedor(mov.getSalesRep().getName());
                }
                doc.getEncabezado().setEmisor(emisor);
                MBPartner BP = new MBPartner(mov.getCtx(), mov.getC_BPartner_ID(), mov.get_TrxName());
                MBPartnerLocation bloc = new MBPartnerLocation(mov.getCtx(), mov.getC_BPartner_Location_ID(), mov.get_TrxName());
                Receptor receptor = new Receptor();
                receptor.setRUTRecep(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
                String RznSocRecepStr = BP.getName();
                RznSocRecepStr = RznSocRecepStr.replace("'", "");
                RznSocRecepStr = RznSocRecepStr.replace("\"", "");
                receptor.setRznSocRecep(RznSocRecepStr);
                String dirRecepStr = bloc.get_ValueAsString("Address1");
                dirRecepStr = dirRecepStr.replace("'", "");
                dirRecepStr = dirRecepStr.replace("\"", "");
                receptor.setDirRecep(dirRecepStr);
                String CmnaRecepStr = null;
                if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                    MCity dCity = new MCity(mov.getCtx(), bloc.get_ValueAsInt("C_City_ID"), mov.get_TrxName());
                    CmnaRecepStr = dCity.getName();
                }
                receptor.setCmnaRecep(CmnaRecepStr);
                String ciudadTxt = "";
                if (bloc.get_ValueAsInt("C_Province_ID") > 0) {
                    X_C_Province prov = new X_C_Province(mov.getCtx(), bloc.get_ValueAsInt("C_Province_ID"), mov.get_TrxName());
                    ciudadTxt = prov.getName();
                }
                receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
                receptor.setGiroRecep((String)BP.get_Value("Giro"));
                String strContacto = bloc.get_ValueAsString("Phone");
                dirRecepStr = dirRecepStr.replace("'", "");
                dirRecepStr = dirRecepStr.replace("\"", "");
                receptor.setContacto(strContacto);
                doc.getEncabezado().setReceptor(receptor);
                BigDecimal amountGrandT = Env.ZERO;
                BigDecimal priceT = Env.ZERO;
                BigDecimal taxIVAAmtAcu = Env.ZERO;
                BigDecimal taxExeAmtAcu = Env.ZERO;
                BigDecimal taxNetoAmtAcu = Env.ZERO;
                BigDecimal amtAcum = Env.ZERO;
                MMovementLine[] iLines = mov.getLines(true);
                int i = 0;
                while (i < iLines.length) {
                    MMovementLine iLine = iLines[i];
                    if (iLine.getM_Product_ID() != 0 && iLine.getM_Product_ID() > 0) {
                        priceT = DB.getSQLValueBD(mov.get_TrxName(), "SELECT PriceStd FROM M_ProductPrice WHERE M_PriceList_Version_ID=2000004 AND M_Product_ID=" + iLine.getM_Product_ID(), new Object[0]);
                        if (priceT == null) {
                            priceT = new BigDecimal("9990.0");
                        }
                        amtAcum = amtAcum.add(priceT.multiply(iLine.getMovementQty()));
                    }
                    ++i;
                }
                taxNetoAmtAcu = amtAcum;
                taxIVAAmtAcu = taxNetoAmtAcu.multiply(new BigDecimal("0.19"));
                taxIVAAmtAcu = taxIVAAmtAcu.setScale(0, RoundingMode.HALF_EVEN);
                amountGrandT = taxNetoAmtAcu.add(taxIVAAmtAcu);
                Totales totales = new Totales();
                totales.setMntTotal(amountGrandT.toBigInteger());
                totales.setMntNeto(taxNetoAmtAcu.toBigInteger());
                totales.setMntExe(taxExeAmtAcu.toBigInteger());
                if (taxNetoAmtAcu.signum() > 0) {
                    totales.setTasaIVA(BigDecimal.valueOf(19L));
                }
                totales.setIVA(taxIVAAmtAcu.toBigInteger());
                doc.getEncabezado().setTotales(totales);
                int lineInvoice = 0;
                int i2 = 0;
                while (i2 < iLines.length) {
                    MMovementLine iLine = iLines[i2];
                    if (iLine.getM_Product_ID() != 0) {
                        ++lineInvoice;
                        Detalle det = new Detalle();
                        CdgItem cdgItem = new CdgItem();
                        cdgItem.setTpoCodigo("INT1");
                        cdgItem.setVlrCodigo(iLine.getProduct().getValue());
                        det.getCdgItem().add(cdgItem);
                        det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                        String pname = "";
                        if (iLine.getProduct() != null) {
                            pname = iLine.getProduct().getName();
                            if (iLine.getM_Product().getUPC() != null && iLine.getM_Product().getUPC().trim().length() > 0) {
                                pname = String.valueOf(pname) + iLine.getM_Product().getUPC();
                            }
                            pname = pname.replace("'", "");
                            pname = pname.replace("\"", "");
                            det.setNmbItem(pname);
                            det.setQtyItem(iLine.getMovementQty());
                            priceT = DB.getSQLValueBD(mov.get_TrxName(), "SELECT PriceStd FROM M_ProductPrice WHERE M_PriceList_Version_ID=2000004 AND M_Product_ID=" + iLine.getM_Product_ID(), new Object[0]);
                            if (priceT == null) {
                                priceT = new BigDecimal("9990.0");
                            }
                            BigDecimal prcRefMnt = priceT;
                            BigDecimal mtoItem = prcRefMnt.multiply(iLine.getMovementQty());
                            det.setPrcItem(prcRefMnt.setScale(0, 4));
                            det.setMontoItem(mtoItem.setScale(0, 4).toBigInteger());
                            if (iLine.getDescription() != null && iLine.getDescription() != "" && mov.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                                det.setDscItem(iLine.getDescription() == null ? " " : iLine.getDescription());
                            }
                            String unmdItemStr = "";
                            unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                            if (unmdItemStr == null) {
                                unmdItemStr = "UN";
                            }
                            det.setUnmdItem(unmdItemStr);
                            doc.getDetalle().add(det);
                        }
                    }
                    ++i2;
                }
                String tiporeferencia = new String();
                String folioreferencia = new String();
                String fechareferencia = new String();
                int tipo_Ref = 0;
                if (mov.getPOReference() != null && mov.getPOReference().length() > 0 && mov.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && mov.getPOReference().compareTo("0") != 0) {
                    tiporeferencia = "801";
                    folioreferencia = mov.getPOReference();
                    fechareferencia = mov.getDateReceived() != null ? this.ConverDateToString(mov.getDateReceived()) : this.ConverDateToString(mov.getMovementDate());
                    tipo_Ref = 2;
                }
                int indice = 0;
                if (tipo_Ref > 0) {
                    ++indice;
                    Referencia reference = new Referencia();
                    try {
                        reference.setNroLinRef(BigInteger.valueOf(indice));
                        reference.setTpoDocRef(tiporeferencia);
                        reference.setFolioRef(folioreferencia);
                        reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                        reference.setCodRef(Referencia_CodRef.n1);
                        String razonRefTxt = mov.get_ValueAsString("RazonRef");
                        if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                            reference.setRazonRef(razonRefTxt);
                        }
                        doc.getReferencia().add(reference);
                    }
                    catch (LtException e) {
                        e.printStackTrace();
                    }
                }
                PersonalizadosA personalizados = new PersonalizadosA();
                dte.setPersonalizados(personalizados);
                if (mov.getDescription() != null) {
                    personalizados.setDocPersonalizado(new DocPersonalizadoA());
                    CampoStringA campoString = new CampoStringA();
                    campoString.setName("Notas");
                    campoString.setPrimitiveValue(mov.getDescription());
                    personalizados.getDocPersonalizado().getCampoString().add(campoString);
                }
                String ambiente = "T";
                if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                    ambiente = "T";
                } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                    ambiente = "P";
                }
                String fechaResolucion = org.get_ValueAsString("FchResol");
                int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
                int tipoPdf417 = 1;
                String apiURL = "http://192.168.0.200/api/Core.svc/Core";
                String apiAuth = OFBForward.GDEapiAuth();
                Servicio servicio = new Servicio(apiURL, apiAuth);
                ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
                dte.toXml();
                this.log.config("dte " + dte.toXml());
                this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
                if (resultado.getResultadoServicio().getEstado() == 0) {
                    ted = resultado.getTED();
                    pdf417 = resultado.getPDF417();
                    error = resultado.getResultadoServicio().getDescripcion();
                } else {
                    error = resultado.getResultadoServicio().getDescripcion();
                }
                mov.set_CustomColumn("DescriptionGDE", error);
                mov.saveEx(mov.get_TrxName());
                Thread.sleep(4000L);
                GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
                int tipoDTE = 33;
                tipoDTE = docType.get_ValueAsString("DocumentNo").compareTo("33") == 0 ? 33 : (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0 ? 34 : (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0 ? 56 : (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0 ? 52 : (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0 ? 61 : 52))));
                long folio = Long.parseLong(mov.getDocumentNo());
                ResultadoRecuperarPDF resultadoPDF = servicio.RecuperarPdf(ambiente, grupo, (String)org.get_Value("Rut"), tipoDTE, folio);
                if (resultadoPDF.getResultadoServicio().getEstado() == 0 || resultadoPDF.getResultadoServicio().getEstado() == 1) {
                    this.log.config("datos Usados: apiURL=" + apiURL + " - apiAuth=" + apiAuth + " - ambiente=" + ambiente + " - grupo=" + grupo + " - rut=" + (String)org.get_Value("Rut") + " - tipoDTE=" + tipoDTE + " - folio=" + folio);
                    this.log.config("log resultado: " + resultadoPDF.getResultadoServicio().getDescripcion() + " - " + resultadoPDF.getResultadoServicio().getExcepcionOriginal() + " - " + resultadoPDF.getResultadoServicio().getEstado());
                    byte[] pdf = resultadoPDF.getDatos();
                    if (pdf == null) break block65;
                    String ExportDir = "";
                    try {
                        String pathServer = OFBForward.PathGDEServer();
                        String pathCliente = OFBForward.PathGDEClient();
                        if (pathServer == null || pathCliente == null || pathServer.trim().length() <= 0 || pathCliente.trim().length() <= 0) break block65;
                        File theDir = new File(pathServer);
                        if (!theDir.exists()) {
                            ExportDir = pathCliente;
                        }
                        this.log.config("Archivo a guardar: " + ExportDir + folio + ".pdf");
                        FileOutputStream out = new FileOutputStream(String.valueOf(ExportDir) + folio + ".pdf");
                        ((OutputStream)out).write(pdf);
                        ((OutputStream)out).close();
                        String remote_working_dir_path = OFBForward.GDEDirPath();
                        String local_filepath = String.valueOf(ExportDir) + folio + ".pdf";
                        String remote_filename = String.valueOf(folio) + ".pdf";
                        String finalURL = String.valueOf(OFBForward.GDERemoteURL()) + folio + ".pdf";
                        FileInputStream fis = new FileInputStream(local_filepath);
                        FTPClient client = new FTPClient();
                        try {
                            try {
                                client.setBufferSize(512);
                                client.connect(OFBForward.GDEFTPServer(), OFBForward.GDEFTPServerPort());
                                client.login(OFBForward.GDEFTPUser(), OFBForward.GDEFTPPass());
                                client.enterLocalPassiveMode();
                                client.setFileType(2);
                                client.changeWorkingDirectory(remote_working_dir_path);
                                boolean uploadFile = client.storeFile(remote_filename, (InputStream)fis);
                                client.logout();
                                client.disconnect();
                                if (!uploadFile) {
                                    throw new Exception("Error al subir el fichero");
                                }
                                mov.set_CustomColumn("UrlGde", finalURL);
                                mov.saveEx(this.get_TrxName());
                            }
                            catch (Exception eFTPClient) {
                                this.log.config("ERROR: " + eFTPClient.toString());
                                fis.close();
                                break block65;
                            }
                        }
                        catch (Throwable throwable) {
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block65;
                }
                error = String.valueOf(error) + resultado.getResultadoServicio().getDescripcion();
            }
            catch (Exception e) {
                this.log.config(e.toString());
                error = e.toString();
            }
        }
        return "Procesado" + error + " - " + ted + " - " + pdf417;
    }

    public String ConverDateToString(Timestamp fecha) {
        String dateReturn = "";
        this.log.config("month" + fecha.getMonth() + 1);
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }
}

