/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import DocumentoBoleta.SiiDte.BOLETADefType;
import DocumentoBoleta.SiiDte.Detalle;
import DocumentoBoleta.SiiDte.Documento;
import DocumentoBoleta.SiiDte.Encabezado;
import DocumentoBoleta.SiiDte.IdDoc;
import DocumentoBoleta.SiiDte.IdDoc_IndServicio;
import DocumentoBoleta.SiiDte.Totales;
import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.DineroPorcentajeType;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.DscRcgGlobal;
import DocumentoDTE.SiiDte.DscRcgGlobal_TpoMov;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.IdDoc_FmaPago;
import DocumentoDTE.SiiDte.MntPagos;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoDocumentos;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.Servicio;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Province;
import org.compiere.model.X_M_InOut;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GDEExportDTEInvoiceArtilec
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = "";
        MDocType docTypeCab = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        msg = docTypeCab.get_ValueAsString("DocumentNo").compareTo("39") == 0 || docTypeCab.get_ValueAsString("DocumentNo").compareTo("41") == 0 ? this.CreateXMLBoleta(inv) : this.CreateXML(inv);
        Thread.sleep(15000L);
        this.commitEx();
        msg = String.valueOf(msg) + this.GetPDFGDE(inv);
        return msg;
    }

    public String CreateXML(MInvoice invoice) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            String DocNoHES;
            PO refdoc;
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            MOrg org = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
            dte.getDTE_Choice().setDocumento(new DocumentoDTE.SiiDte.Documento());
            DocumentoDTE.SiiDte.Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new DocumentoDTE.SiiDte.Encabezado());
            DocumentoDTE.SiiDte.IdDoc idDoc = new DocumentoDTE.SiiDte.IdDoc();
            if (docType.get_ValueAsString("DocumentNo").compareTo("33") == 0) {
                idDoc.setTipoDTE(DTEType.n33);
            } else if (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0) {
                idDoc.setTipoDTE(DTEType.n34);
            } else if (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0) {
                idDoc.setTipoDTE(DTEType.n56);
            } else if (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0) {
                idDoc.setTipoDTE(DTEType.n61);
            } else if (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0) {
                idDoc.setTipoDTE(DTEType.n52);
            } else {
                idDoc.setTipoDTE(DTEType.n33);
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            if (invoice.getPaymentRule().compareToIgnoreCase("M") == 0) {
                idDoc.setFmaPago(IdDoc_FmaPago.n1);
            } else {
                idDoc.setFmaPago(IdDoc_FmaPago.n2);
            }
            doc.getEncabezado().setIdDoc(idDoc);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS(invoice.get_TrxName(), "SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", invoice.get_ID());
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue(invoice.get_TrxName(), "SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID());
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            idDoc.setFchVenc(new DateTime(DateTimeType.date, this.ConverDateToString(fchVencCal)));
            doc.getEncabezado().setIdDoc(idDoc);
            MntPagos mntPago = new MntPagos();
            mntPago.setFchPago(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            mntPago.setMntPago(invoice.getGrandTotal().toBigInteger());
            String GlosaP = DB.getSQLValueString(invoice.get_TrxName(), "SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'", new Object[0]);
            String GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = String.valueOf(GlosaPFull) + "-" + GlosaP;
            }
            mntPago.setGlosaPagos(GlosaPFull);
            idDoc.setTermPagoGlosa(GlosaPFull);
            idDoc.getMntPagos().add(mntPago);
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor((String)org.get_Value("Rut"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("Acteco"))));
            emisor.setDirOrigen((String)org.get_Value("Address1"));
            emisor.setCmnaOrigen((String)org.get_Value("Comuna"));
            emisor.setCiudadOrigen((String)org.get_Value("City"));
            if (invoice.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(invoice.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptor.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            if (bloc.get_ValueAsInt("C_Province_ID") > 0) {
                X_C_Province prov = new X_C_Province(invoice.getCtx(), bloc.get_ValueAsInt("C_Province_ID"), invoice.get_TrxName());
                ciudadTxt = prov.getName();
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep((String)BP.get_Value("Giro"));
            String strContacto = bloc.get_ValueAsString("Phone");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setContacto(strContacto);
            doc.getEncabezado().setReceptor(receptor);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            DocumentoDTE.SiiDte.Totales totales = new DocumentoDTE.SiiDte.Totales();
            totales.setMntTotal(invoice.getGrandTotal().toBigInteger());
            totales.setMntNeto(amountNeto.toBigInteger());
            totales.setMntExe(amountex.toBigInteger());
            if (amountNeto.signum() > 0) {
                totales.setTasaIVA(BigDecimal.valueOf(19L));
            }
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            totales.setIVA(ivaamt.toBigInteger());
            doc.getEncabezado().setTotales(totales);
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int lineDiscount = 0;
            HashMap<String, BigDecimal> HashCodeQty = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> HashCodeAmount = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeName = new HashMap<String, String>();
            HashMap<String, String> HashCodeUPC = new HashMap<String, String>();
            HashMap<String, String> HashCodeUOM = new HashMap<String, String>();
            HashMap<String, BigDecimal> HashCodeRate = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeDesc = new HashMap<String, String>();
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    String valuecod = "";
                    String namecod = "";
                    String upccod = "";
                    String uomcod = "";
                    if (iLine.getM_Product_ID() > 0) {
                        String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        String result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID());
                        this.log.config("sql = " + sql);
                        this.log.config("product " + iLine.getM_Product_ID());
                        this.log.config(" partner = " + iLine.getC_Invoice().getC_BPartner_ID());
                        if (result == null || result.compareTo("-") == 0) {
                            sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                            result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), 2045812);
                            this.log.config("sql = " + sql);
                            this.log.config("product " + iLine.getM_Product_ID());
                            valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                        } else {
                            valuecod = result;
                        }
                        sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID());
                        if (result == null || result.compareTo("-") == 0) {
                            sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                            result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), 2045812);
                            this.log.config("sql = " + sql);
                            this.log.config("product " + iLine.getM_Product_ID());
                            namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                        } else {
                            namecod = result;
                        }
                        if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                            uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                        }
                        if (iLine.getM_Product().getUPC() != null) {
                            upccod = "-".concat(iLine.getM_Product().getUPC());
                        }
                    } else {
                        valuecod = "CARGO";
                        namecod = iLine.getC_Charge().getName();
                        upccod = "- ";
                        uomcod = "UN";
                    }
                    HashCodeName.put(valuecod, namecod);
                    HashCodeUPC.put(valuecod, upccod);
                    HashCodeUOM.put(valuecod, uomcod);
                    HashCodeDesc.put(valuecod, iLine.getDescription() != null ? iLine.getDescription() : " ");
                    if (iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                        HashCodeRate.put(valuecod, iLine.getC_Tax().getRate());
                    } else {
                        HashCodeRate.put(valuecod, Env.ZERO);
                    }
                    if (HashCodeQty.get(valuecod) != null) {
                        HashCodeQty.put(valuecod, ((BigDecimal)HashCodeQty.get(valuecod)).add(iLine.getQtyInvoiced()));
                        HashCodeAmount.put(valuecod, ((BigDecimal)HashCodeAmount.get(valuecod)).add(iLine.getLineNetAmt()));
                    } else {
                        HashCodeQty.put(valuecod, iLine.getQtyInvoiced());
                        HashCodeAmount.put(valuecod, iLine.getLineNetAmt());
                    }
                }
                ++i;
            }
            for (String i2 : HashCodeQty.keySet()) {
                if (((BigDecimal)HashCodeRate.get(i2)).compareTo(Env.ZERO) >= 0) {
                    ++lineInvoice;
                    DocumentoDTE.SiiDte.Detalle det = new DocumentoDTE.SiiDte.Detalle();
                    CdgItem cdgItem = new CdgItem();
                    cdgItem.setTpoCodigo("INT1");
                    cdgItem.setVlrCodigo(i2);
                    det.getCdgItem().add(cdgItem);
                    det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                    String pname = "";
                    pname = i2.concat("-").concat((String)HashCodeName.get(i2)).concat((String)HashCodeUPC.get(i2));
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    det.setNmbItem(pname);
                    det.setQtyItem((BigDecimal)HashCodeQty.get(i2));
                    this.log.config("HashCodeAmount " + HashCodeAmount.get(i2));
                    this.log.config("HashCodeQty " + HashCodeQty.get(i2));
                    BigDecimal unitario = ((BigDecimal)HashCodeAmount.get(i2)).divide((BigDecimal)HashCodeQty.get(i2), RoundingMode.HALF_UP);
                    this.log.config("unitario " + unitario);
                    det.setPrcItem(unitario.setScale(0, 4));
                    det.setMontoItem(((BigDecimal)HashCodeAmount.get(i2)).setScale(0, 4).toBigInteger());
                    det.setDscItem((String)HashCodeDesc.get(i2));
                    String unmdItemStr = "";
                    unmdItemStr = (String)HashCodeUOM.get(i2);
                    det.setUnmdItem(unmdItemStr);
                    doc.getDetalle().add(det);
                    continue;
                }
                DscRcgGlobal dscRcgGlobal = new DscRcgGlobal();
                dscRcgGlobal.setNroLinDR(BigInteger.valueOf(++lineDiscount));
                dscRcgGlobal.setTpoMov(DscRcgGlobal_TpoMov.D);
                dscRcgGlobal.setTpoValor(DineroPorcentajeType.Dollar);
                dscRcgGlobal.setValorDR(((BigDecimal)HashCodeAmount.get(i2)).abs().setScale(0, 4));
                String pname = "";
                pname = i2.concat("-").concat((String)HashCodeName.get(i2)).concat((String)HashCodeUPC.get(i2));
                pname = pname.replace("'", "");
                pname = pname.replace("\"", "");
                dscRcgGlobal.setGlosaDR(pname);
                doc.getDscRcgGlobal().add(dscRcgGlobal);
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_ValueAsInt("C_RefDoc_ID") > 0) {
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = this.ConverDateToString(((X_C_Invoice)refdoc).getDateInvoiced());
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0 && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && invoice.getPOReference().compareTo("0") != 0) {
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered() != null ? this.ConverDateToString(invoice.getDateOrdered()) : this.ConverDateToString(invoice.getDateInvoiced());
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = this.ConverDateToString(((X_M_InOut)refdoc).getMovementDate());
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(indice));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    String razonRefTxt = invoice.get_ValueAsString("RazonRef");
                    if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                        reference.setRazonRef(razonRefTxt);
                    }
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            int ID_Ship = 0;
            try {
                if (invoice.getC_Order_ID() > 0) {
                    ID_Ship = DB.getSQLValue(invoice.get_TrxName(), "SELECT COALESCE((MAX(M_InOut_ID)),0) FROM M_InOut mi INNER JOIN C_Order co ON (mi.C_Order_ID = co.C_Order_ID) WHERE mi.docstatus IN ('CO','CL','VO') AND mi.C_Order_ID = " + invoice.getC_Order_ID());
                }
            }
            catch (Exception e) {
                ID_Ship = 0;
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            if (ID_Ship > 0) {
                ++indice;
                String docRef = "52";
                MInOut inOutref = new MInOut(invoice.getCtx(), ID_Ship, invoice.get_TrxName());
                MDocType docTShip = new MDocType(invoice.getCtx(), inOutref.getC_DocType_ID(), invoice.get_TrxName());
                docRef = docTShip.get_ValueAsBoolean("CreateXML") ? "52" : "52";
                Referencia reference2 = new Referencia();
                try {
                    reference2.setNroLinRef(BigInteger.valueOf(indice));
                    reference2.setTpoDocRef(docRef);
                    reference2.setFolioRef(inOutref.getDocumentNo());
                    reference2.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(inOutref.getMovementDate())));
                    doc.getReferencia().add(reference2);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if ((DocNoHES = invoice.get_ValueAsString("POReferenceHES")) != null && DocNoHES.trim().length() > 0 && DocNoHES.compareTo("0") != 0) {
                ++indice;
                String docRef = "HES";
                Referencia reference3 = new Referencia();
                try {
                    reference3.setNroLinRef(BigInteger.valueOf(indice));
                    reference3.setTpoDocRef(docRef);
                    reference3.setFolioRef(DocNoHES);
                    Timestamp dateHES = (Timestamp)invoice.get_Value("DateHES");
                    if (dateHES == null) {
                        dateHES = invoice.getDateInvoiced();
                    }
                    reference3.setFchRef(new DateTime(DateTimeType.date, this.ConverDateToString(dateHES)));
                    doc.getReferencia().add(reference3);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            if (invoice.getDescription() != null && invoice.getDescription().trim().length() > 0) {
                PersonalizadosA personalizados = new PersonalizadosA();
                dte.setPersonalizados(personalizados);
                personalizados.setDocPersonalizado(new DocPersonalizadoA());
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(invoice.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            String ambiente = "T";
            if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                ambiente = "T";
            } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                ambiente = "P";
            }
            String fechaResolucion = org.get_ValueAsString("FchResol");
            int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
            int tipoPdf417 = 1;
            String apiURL = "http://192.168.0.200/api/Core.svc/Core";
            String apiAuth = OFBForward.GDEapiAuth();
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            invoice.set_CustomColumn("DescriptionGDE", error);
            invoice.saveEx(invoice.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado" + ted + " - " + pdf417 + " - " + error;
    }

    public String ConverDateToString(Timestamp fecha) {
        String dateReturn = "";
        this.log.config("month" + fecha.getMonth() + 1);
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }

    public String CreateXMLBoleta(MInvoice invoice) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        MOrg org = new MOrg(invoice.getCtx(), invoice.getAD_Org_ID(), invoice.get_TrxName());
        String fechaResolucion = org.get_ValueAsString("FchResol");
        int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "ID_" + invoice.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element FechaResolEle = document.createElement("FechaResol");
            Text textFchResol = document.createTextNode(fechaResolucion);
            FechaResolEle.appendChild(textFchResol);
            Encabezado2.appendChild(FechaResolEle);
            Element NroResolEle = document.createElement("NroResol");
            Text textNroResol = document.createTextNode(Integer.toString(numeroResolucion));
            NroResolEle.appendChild(textNroResol);
            Encabezado2.appendChild(NroResolEle);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element IndServicio = document.createElement("IndServicio");
            Text IndServTxt = document.createTextNode("3");
            IndServicio.appendChild(IndServTxt);
            IdDoc2.appendChild(IndServicio);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS(invoice.get_TrxName(), "SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", invoice.get_ID());
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue(invoice.get_TrxName(), "SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID());
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSocEmisor");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmisor");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode("66666666-6");
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            String RznSocRecepStr = "Cliente Boletas";
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            String dirRecepStr = String.valueOf(bloc.getLocation(true).getAddress1()) + "-" + bloc.getPhone();
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            if (CmnaRecepStr == null) {
                CmnaRecepStr = "Santiago";
            }
            if (CmnaRecepStr.length() > 20) {
                CmnaRecepStr = CmnaRecepStr.substring(0, 20);
            }
            this.log.config("CmnaRecep = " + CmnaRecepStr);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            String ciudadTxt = "";
            ciudadTxt = bloc.getLocation(true).getC_Region_ID() == 1000001 || bloc.getLocation(true).getC_City_ID() <= 0 ? "SANTIAGO" : bloc.getC_Location().getCity();
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(ciudadTxt != null ? ciudadTxt : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int lineDiscount = 0;
            HashMap<String, BigDecimal> HashCodeQty = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> HashCodeAmount = new HashMap<String, BigDecimal>();
            HashMap<String, String> HashCodeName = new HashMap<String, String>();
            HashMap<String, String> HashCodeUPC = new HashMap<String, String>();
            HashMap<String, String> HashCodeUOM = new HashMap<String, String>();
            HashMap<String, BigDecimal> HashCodeRate = new HashMap<String, BigDecimal>();
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    String valuecod = "";
                    String namecod = "";
                    String upccod = "";
                    String uomcod = "";
                    if (iLine.getM_Product_ID() > 0) {
                        String sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        String result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID());
                        if (result == null || result.compareTo("-") == 0) {
                            sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                            result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), 2045812);
                            this.log.config("sql = " + sql);
                            this.log.config("product " + iLine.getM_Product_ID());
                            valuecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getValue() : result;
                        } else {
                            valuecod = result;
                        }
                        sql = "SELECT coalesce(description,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                        result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), iLine.getC_Invoice().getC_BPartner_ID());
                        if (result == null || result.compareTo("-") == 0) {
                            sql = "SELECT coalesce(vendorproductno,'-') from c_bpartner_product  WHERE m_product_Id = ? and c_bpartner_id = ? and isactive='Y'";
                            result = DB.getSQLValueString(this.get_TrxName(), sql, iLine.getM_Product_ID(), 2045812);
                            this.log.config("sql = " + sql);
                            this.log.config("product " + iLine.getM_Product_ID());
                            namecod = result == null || result.compareTo("-") == 0 ? iLine.getM_Product().getName() : result;
                        } else {
                            namecod = result;
                        }
                        if (iLine.getM_Product().getC_UOM().getUOMSymbol() != null) {
                            uomcod = iLine.getM_Product().getC_UOM().getUOMSymbol();
                        }
                        if (iLine.getM_Product().getUPC() != null) {
                            upccod = iLine.getM_Product().getUPC();
                        }
                    } else {
                        valuecod = "CARGO";
                        namecod = iLine.getC_Charge().getName();
                        upccod = " ";
                        uomcod = "UN";
                    }
                    HashCodeName.put(valuecod, namecod);
                    HashCodeUPC.put(valuecod, upccod);
                    HashCodeUOM.put(valuecod, uomcod);
                    if (iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                        HashCodeRate.put(valuecod, iLine.getC_Tax().getRate());
                    } else {
                        HashCodeRate.put(valuecod, Env.ZERO);
                    }
                    if (HashCodeQty.get(valuecod) != null) {
                        HashCodeQty.put(valuecod, ((BigDecimal)HashCodeQty.get(valuecod)).add(iLine.getQtyInvoiced()));
                        HashCodeAmount.put(valuecod, ((BigDecimal)HashCodeAmount.get(valuecod)).add(iLine.getLineNetAmt()));
                    } else {
                        HashCodeQty.put(valuecod, iLine.getQtyInvoiced());
                        HashCodeAmount.put(valuecod, iLine.getLineNetAmt());
                    }
                }
                ++i;
            }
            for (String i2 : HashCodeQty.keySet()) {
                if (((BigDecimal)HashCodeAmount.get(i2)).compareTo(Env.ZERO) >= 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(++lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element cdgItem = document.createElement("CdgItem");
                    Detalle2.appendChild(cdgItem);
                    Element TpoCodigo = document.createElement("TpoCodigo");
                    Text descTpoCod = document.createTextNode("INT");
                    TpoCodigo.appendChild(descTpoCod);
                    cdgItem.appendChild(TpoCodigo);
                    Element VlrCodigo = document.createElement("VlrCodigo");
                    Text descVlrCod = document.createTextNode(i2);
                    VlrCodigo.appendChild(descVlrCod);
                    cdgItem.appendChild(VlrCodigo);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = ((String)HashCodeName.get(i2)).concat((String)HashCodeUPC.get(i2));
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(((BigDecimal)HashCodeQty.get(i2)).toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    String unmdItemStr = "";
                    unmdItemStr = (String)HashCodeUOM.get(i2);
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UM = document.createTextNode(unmdItemStr);
                    UnmdItem.appendChild(UM);
                    Detalle2.appendChild(UnmdItem);
                    BigDecimal prcItem = null;
                    BigDecimal mntItem = null;
                    BigDecimal prcItemTax = null;
                    BigDecimal mntItemTax = null;
                    BigDecimal unitario = ((BigDecimal)HashCodeAmount.get(i2)).divide((BigDecimal)HashCodeQty.get(i2), RoundingMode.HALF_UP);
                    this.log.config("unitario " + unitario);
                    if (invoice.getC_DocType().getDocBaseType().compareToIgnoreCase("ARI") == 0 && invoice.getC_DocType().getName().toLowerCase().contains("boleta") && ((BigDecimal)HashCodeRate.get(i2)).compareTo(Env.ZERO) != 0) {
                        prcItemTax = unitario.multiply((BigDecimal)HashCodeRate.get(i2));
                        prcItemTax = prcItemTax.divide(Env.ONEHUNDRED);
                        prcItem = unitario.add(prcItemTax);
                        mntItemTax = ((BigDecimal)HashCodeAmount.get(i2)).multiply((BigDecimal)HashCodeRate.get(i2));
                        mntItemTax = mntItemTax.divide(Env.ONEHUNDRED);
                        mntItem = ((BigDecimal)HashCodeAmount.get(i2)).add(mntItemTax);
                    } else {
                        prcItem = unitario;
                        mntItem = (BigDecimal)HashCodeAmount.get(i2);
                    }
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(prcItem.setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(mntItem.setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                    continue;
                }
                Element Descuento = document.createElement("DscRcgGlobal");
                Documento2.appendChild(Descuento);
                Element NroLinDis = document.createElement("NroLinDR");
                Text lineDis = document.createTextNode(Integer.toString(++lineDiscount));
                NroLinDis.appendChild(lineDis);
                Descuento.appendChild(NroLinDis);
                Element Tpomov = document.createElement("TpoMov");
                Text descMov = document.createTextNode("D");
                Tpomov.appendChild(descMov);
                Descuento.appendChild(Tpomov);
                String pnameDis = "";
                pnameDis = ((String)HashCodeName.get(i2)).concat((String)HashCodeUPC.get(i2));
                Element GlosaDR = document.createElement("GlosaDR");
                Text descGlosaDR = document.createTextNode(pnameDis);
                GlosaDR.appendChild(descGlosaDR);
                Descuento.appendChild(GlosaDR);
                Element TpoValor = document.createElement("TpoValor");
                Text descTpoValor = document.createTextNode("$");
                TpoValor.appendChild(descTpoValor);
                Descuento.appendChild(TpoValor);
                Element TpoValorDRValor = document.createElement("ValorDR");
                Text descValorDR = document.createTextNode(((BigDecimal)HashCodeAmount.get(i2)).abs().setScale(0, 4).toString());
                TpoValorDRValor.appendChild(descValorDR);
                Descuento.appendChild(TpoValorDRValor);
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            this.log.config("XML enviado: " + file.toString());
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception TpoValorDRValor) {
                // empty catch block
            }
            this.log.config("XML enviado base64: " + encodedFile.toString());
            String ambiente = "T";
            if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                ambiente = "T";
            } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                ambiente = "P";
            }
            boolean tipoPdf417 = true;
            String apiURL = "http://192.168.0.200/api/Core.svc/Core";
            String apiAuth = OFBForward.GDEapiAuth();
            String ResponseText = "";
            try {
                String invokeURI = "http://192.168.0.200/api/Core.svc/core/SendDocumentAsXML";
                try {
                    String request = "<SendDocumentAsXMLRequest xmlns=\"http://gdexpress.cl/api\"><Environment>" + ambiente + "</Environment>  " + "<Content>" + encodedFile + "</Content>" + "<ResolutionDate>" + fechaResolucion + "</ResolutionDate>" + "<ResolutionNumber>" + numeroResolucion + "</ResolutionNumber>" + "<PDF417Columns></PDF417Columns>" + "<PDF417Level></PDF417Level>" + "<PDF417Type></PDF417Type>" + "<TED></TED>" + "</SendDocumentAsXMLRequest>";
                    URL url = new URL(invokeURI);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("AuthKey", apiAuth);
                    conn.setRequestProperty("Accept", "application/xml");
                    conn.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.write(request.getBytes("UTF-8"));
                    wr.flush();
                    wr.close();
                    InputStream is = conn.getInputStream();
                    DataInputStream dis = new DataInputStream(is);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2028];
                    int read = 0;
                    while ((read = dis.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    byte[] ResponseBytes = baos.toByteArray();
                    ResponseText = new String(ResponseBytes);
                    System.out.println(ResponseText);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            invoice.set_CustomColumn("DescriptionGDE", ResponseText);
            invoice.saveEx(invoice.get_TrxName());
            if (ResponseText.contains("<Result>0</Result>")) {
                wsRespuesta = "DTE Enviado OK";
                this.log.config(wsRespuesta);
            } else {
                wsRespuesta = "ERROR en DTE Enviado";
                this.log.config(wsRespuesta);
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG Generated " + wsRespuesta;
    }

    public String GetPDF(MInvoice invoice) {
        block15: {
            String ambiente = "T";
            if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                ambiente = "T";
            } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                ambiente = "P";
            }
            GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
            MOrg org = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            String rut = (String)org.get_Value("Rut");
            MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
            int tipoDTE = 33;
            tipoDTE = docType.get_ValueAsString("DocumentNo").compareTo("33") == 0 ? 33 : (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0 ? 34 : (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0 ? 56 : (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0 ? 61 : (docType.get_ValueAsString("DocumentNo").compareTo("39") == 0 ? 39 : (docType.get_ValueAsString("DocumentNo").compareTo("41") == 0 ? 41 : 33)))));
            long folio = Long.parseLong(invoice.getDocumentNo());
            String apiURL = "http://192.168.0.200/api/Core.svc/Core";
            String apiAuth = OFBForward.GDEapiAuth();
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoRecuperarPDF resultado = servicio.RecuperarPdf(ambiente, grupo, rut, tipoDTE, folio);
            if (resultado.getResultadoServicio().getEstado() == 0 || resultado.getResultadoServicio().getEstado() == 1) {
                this.log.config("datos Usados: apiURL=" + apiURL + " - apiAuth=" + apiAuth + " - ambiente=" + ambiente + " - grupo=" + grupo + " - rut=" + rut + " - tipoDTE=" + tipoDTE + " - folio=" + folio);
                this.log.config("log resultado: " + resultado.getResultadoServicio().getDescripcion() + " - " + resultado.getResultadoServicio().getExcepcionOriginal() + " - " + resultado.getResultadoServicio().getEstado());
                byte[] pdf = resultado.getDatos();
                if (pdf != null) {
                    String ExportDir = "";
                    try {
                        String pathServer = OFBForward.PathGDEServer();
                        String pathCliente = OFBForward.PathGDEClient();
                        if (pathServer == null || pathCliente == null || pathServer.trim().length() <= 0 || pathCliente.trim().length() <= 0) break block15;
                        File theDir = new File(pathServer);
                        if (!theDir.exists()) {
                            ExportDir = pathCliente;
                        }
                        this.log.config("Archivo a guardar: " + ExportDir + folio + ".pdf");
                        FileOutputStream out = new FileOutputStream(String.valueOf(ExportDir) + folio + ".pdf");
                        ((OutputStream)out).write(pdf);
                        ((OutputStream)out).close();
                        String remote_working_dir_path = OFBForward.GDEDirPath();
                        String local_filepath = String.valueOf(ExportDir) + folio + ".pdf";
                        String remote_filename = String.valueOf(folio) + ".pdf";
                        String finalURL = String.valueOf(OFBForward.GDERemoteURL()) + folio + ".pdf";
                        FTPClient client = new FTPClient();
                        try (FileInputStream fis = new FileInputStream(local_filepath);){
                            try {
                                client.setBufferSize(512);
                                client.connect(OFBForward.GDEFTPServer(), OFBForward.GDEFTPServerPort());
                                client.login(OFBForward.GDEFTPUser(), OFBForward.GDEFTPPass());
                                client.enterLocalPassiveMode();
                                client.setFileType(2);
                                client.changeWorkingDirectory(remote_working_dir_path);
                                boolean uploadFile = client.storeFile(remote_filename, (InputStream)fis);
                                client.logout();
                                client.disconnect();
                                if (!uploadFile) {
                                    throw new Exception("Error al subir el fichero");
                                }
                                invoice.set_CustomColumn("UrlGde", finalURL);
                                invoice.saveEx(this.get_TrxName());
                            }
                            catch (Exception eFTPClient) {
                                this.log.config("ERROR: " + eFTPClient.toString());
                                fis.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String error = resultado.getResultadoServicio().getDescripcion();
                return error;
            }
        }
        return null;
    }

    public String GetPDFGDE(MInvoice invoice) throws InterruptedException {
        String ambiente = "T";
        if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
            ambiente = "T";
        } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
            ambiente = "P";
        }
        GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
        String folio2 = String.valueOf(Integer.parseInt(invoice.getDocumentNo()));
        long folio = Long.parseLong(folio2);
        String apiURL = "http://192.168.0.200/api/Core.svc/Core";
        String apiAuth = OFBForward.GDEapiAuth();
        MDocType docType = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        String DTE = null;
        DTE = docType.get_ValueAsString("DocumentNo").compareTo("33") == 0 ? "33" : (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0 ? "34" : (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0 ? "56" : (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0 ? "61" : (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0 ? "52" : (docType.get_ValueAsString("DocumentNo").compareTo("39") == 0 ? "39" : (docType.get_ValueAsString("DocumentNo").compareTo("41") == 0 ? "41" : "33"))))));
        MOrg org = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
        String rutEmisor = (String)org.get_Value("Rut");
        Servicio servicio = new Servicio(apiURL, apiAuth);
        String Consulta = "(TipoDTE:" + DTE + " AND RUTEmisor:" + rutEmisor + " AND Folio:" + folio + ")";
        int pagina = 0;
        int tamannopagina = 300;
        ResultadoDocumentos resultado = servicio.BuscarDocumentos(ambiente, grupo, Consulta, pagina, tamannopagina);
        String xml = resultado.getXml();
        if (xml != null) {
            int po_URL1 = xml.indexOf("<DownloadCustomerDocumentUrl>");
            int po_URL2 = xml.indexOf("</DownloadCustomerDocumentUrl>");
            String URL2 = "<DownloadCustomerDocumentUrl>";
            if (po_URL1 != -1 && po_URL2 != -1) {
                String finalURL = xml.substring(po_URL1 + URL2.length(), po_URL2);
                invoice.set_CustomColumn("UrlGde", finalURL);
                invoice.set_CustomColumn("DescriptionGDE", "");
                invoice.saveEx(this.get_TrxName());
            } else {
                Thread.sleep(5000L);
                ResultadoDocumentos resultado2 = servicio.BuscarDocumentos(ambiente, grupo, Consulta, pagina, tamannopagina);
                String xml2 = resultado2.getXml();
                if (xml2 != null) {
                    int po_URLs1 = xml.indexOf("<DownloadCustomerDocumentUrl>");
                    int po_URLs2 = xml.indexOf("</DownloadCustomerDocumentUrl>");
                    String URLs = "<DownloadCustomerDocumentUrl>";
                    if (po_URLs1 != -1 && po_URLs2 != -1) {
                        String finalURL2 = xml.substring(po_URLs1 + URLs.length(), po_URLs2);
                        invoice.set_CustomColumn("UrlGde", finalURL2);
                        invoice.set_CustomColumn("DescriptionGDE", "");
                        invoice.saveEx(this.get_TrxName());
                    } else if (invoice.get_Value("DescriptionGDE").toString().length() > 0 && invoice.get_Value("DescriptionGDE").toString().compareTo("Envio OK") == 0) {
                        invoice.set_CustomColumn("DescriptionGDE", "No esta presente la URL del PDF");
                        invoice.saveEx(this.get_TrxName());
                    } else if (invoice.get_Value("DescriptionGDE").toString() == null || invoice.get_Value("DescriptionGDE").toString().length() <= 0) {
                        invoice.set_CustomColumn("DescriptionGDE", "No esta presente la URL del PDF");
                        invoice.saveEx(this.get_TrxName());
                    }
                }
            }
        } else if (invoice.get_Value("DescriptionGDE").toString().length() > 0 && invoice.get_Value("DescriptionGDE").toString().compareTo("Envio OK") == 0) {
            invoice.set_CustomColumn("DescriptionGDE", "No se encontro XML");
            invoice.saveEx(this.get_TrxName());
        } else if (invoice.get_Value("DescriptionGDE").toString() == null || invoice.get_Value("DescriptionGDE").toString().length() <= 0) {
            invoice.set_CustomColumn("DescriptionGDE", "No se encontro XML");
            invoice.saveEx(this.get_TrxName());
        }
        return null;
    }

    public void enviarBoletaArtilec(MInvoice invoice) throws Exception {
        BOLETADefType boleta = new BOLETADefType();
        Documento doc = new Documento();
        boleta.setDocumento(doc);
        doc.setEncabezado(new Encabezado());
        IdDoc idDoc = new IdDoc();
        doc.getEncabezado().setIdDoc(idDoc);
        idDoc.setTipoDTE(DocumentoBoleta.SiiDte.DTEType.n39);
        idDoc.setFolio(BigInteger.valueOf(2L));
        idDoc.setFchEmis(new DateTime(DateTimeType.date, "2020-10-21"));
        idDoc.setIndServicio(IdDoc_IndServicio.n3);
        DocumentoBoleta.SiiDte.Emisor emisor = new DocumentoBoleta.SiiDte.Emisor();
        doc.getEncabezado().setEmisor(emisor);
        emisor.setRUTEmisor("79796310-0");
        emisor.setRznSocEmisor("Soc Comercial Artilec Art Electronicos De Proteccion Ltda");
        emisor.setGiroEmisor("Prod Impy Exp de Alarmas Art Electricos ");
        emisor.setDirOrigen("Santa Marta de Huechuraba 6570");
        emisor.setCmnaOrigen("HUECHURABA");
        DocumentoBoleta.SiiDte.Receptor receptor = new DocumentoBoleta.SiiDte.Receptor();
        doc.getEncabezado().setReceptor(receptor);
        receptor.setRUTRecep("66666666-6");
        receptor.setRznSocRecep("Cliente Boletas");
        Totales totales = new Totales();
        doc.getEncabezado().setTotales(totales);
        totales.setMntTotal(BigInteger.valueOf(1190L));
        totales.setMntNeto(BigInteger.valueOf(1000L));
        totales.setIVA(BigInteger.valueOf(190L));
        Detalle det = new Detalle();
        doc.getDetalle().add(det);
        det.setNroLinDet(BigInteger.valueOf(1L));
        det.setNmbItem("Nombre del detalle");
        det.setMontoItem(BigInteger.valueOf(1190L));
        det.setQtyItem(BigDecimal.valueOf(1L));
        det.setPrcItem(BigDecimal.valueOf(1190L));
        String ambiente = "T";
        String fechaResolucion = "2013-04-01";
        int numeroResolucion = 0;
        int tipoPdf417 = 1;
        String apiURL = "http://192.168.0.200/api/Core.svc/Core";
        String apiAuth = "2ec64694-829f-4a6e-b369-dc8936320e09";
        Servicio servicio = new Servicio(apiURL, apiAuth);
        ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(boleta, ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
        this.log.config("metodo nuevo: " + boleta.toXml());
        if (resultado.getResultadoServicio().getEstado() == 0) {
            String ted = resultado.getTED();
            String pdf417 = resultado.getPDF417();
            invoice.set_CustomColumn("DescriptionGDE", "Envio OK");
            invoice.saveEx(invoice.get_TrxName());
        } else {
            String error = resultado.getResultadoServicio().getDescripcion();
            System.out.println("Error: " + error);
            invoice.set_CustomColumn("DescriptionGDE", error);
            invoice.saveEx(invoice.get_TrxName());
            resultado.getResultadoServicio().getExcepcionOriginal().printStackTrace();
        }
    }
}

