/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_IndTraslado;
import DocumentoDTE.SiiDte.IdDoc_TipoDespacho;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.ResultadoRecuperarPDF;
import dteboxcliente.Servicio;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrg;
import org.compiere.model.X_C_Province;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class GDEExportDTEInOutArtilec
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_Inout_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_M_Inout_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInOut ship = new MInOut(this.m_ctx, this.p_M_Inout_ID, this.get_TrxName());
        String msg = "";
        msg = this.CreateXML(ship);
        return msg;
    }

    public String CreateXML(MInOut inOut) {
        String pdf417;
        String ted;
        String error;
        block70: {
            error = "";
            ted = "";
            pdf417 = "";
            try {
                DTEDefType dte = new DTEDefType();
                dte.setDTE_Choice(new DTE_Choice());
                MOrg org = MOrg.get(inOut.getCtx(), inOut.getAD_Org_ID());
                MDocType docType = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
                dte.getDTE_Choice().setDocumento(new Documento());
                Documento doc = dte.getDTE_Choice().getDocumento();
                doc.setEncabezado(new Encabezado());
                IdDoc idDoc = new IdDoc();
                if (docType.get_ValueAsString("DocumentNo").compareTo("33") == 0) {
                    idDoc.setTipoDTE(DTEType.n33);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0) {
                    idDoc.setTipoDTE(DTEType.n34);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0) {
                    idDoc.setTipoDTE(DTEType.n56);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0) {
                    idDoc.setTipoDTE(DTEType.n61);
                } else if (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0) {
                    idDoc.setTipoDTE(DTEType.n52);
                } else {
                    idDoc.setTipoDTE(DTEType.n52);
                }
                idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(inOut.getDocumentNo())));
                idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(inOut.getMovementDate())));
                idDoc.setTipoDespacho(IdDoc_TipoDespacho.n2);
                String IndTrl = null;
                try {
                    IndTrl = inOut.get_ValueAsString("IndTraslado");
                }
                catch (Exception e) {
                    IndTrl = "1";
                }
                if (IndTrl == null || IndTrl == "" || IndTrl == " ") {
                    IndTrl = "1";
                }
                if (IndTrl.compareTo("1") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n1);
                } else if (IndTrl.compareTo("2") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n2);
                } else if (IndTrl.compareTo("3") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n3);
                } else if (IndTrl.compareTo("4") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n4);
                } else if (IndTrl.compareTo("5") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n5);
                } else if (IndTrl.compareTo("6") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n6);
                } else if (IndTrl.compareTo("7") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n7);
                } else if (IndTrl.compareTo("8") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n8);
                } else if (IndTrl.compareTo("9") == 0) {
                    idDoc.setIndTraslado(IdDoc_IndTraslado.n9);
                }
                doc.getEncabezado().setIdDoc(idDoc);
                Emisor emisor = new Emisor();
                emisor.setRUTEmisor((String)org.get_Value("Rut"));
                String nameRzn = org.getDescription();
                if (nameRzn == null) {
                    nameRzn = " ";
                }
                if ((nameRzn = nameRzn.trim()).length() < 2) {
                    nameRzn = org.getName();
                }
                emisor.setRznSoc(nameRzn);
                String giroEmisStr = (String)org.get_Value("Giro");
                giroEmisStr = giroEmisStr.replace("'", "");
                giroEmisStr = giroEmisStr.replace("\"", "");
                emisor.setGiroEmis(giroEmisStr);
                emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("Acteco"))));
                emisor.setDirOrigen((String)org.get_Value("Address1"));
                emisor.setCmnaOrigen((String)org.get_Value("Comuna"));
                emisor.setCiudadOrigen((String)org.get_Value("City"));
                if (inOut.getSalesRep_ID() > 0) {
                    emisor.setCdgVendedor(inOut.getSalesRep().getName());
                }
                doc.getEncabezado().setEmisor(emisor);
                MBPartner BP = new MBPartner(inOut.getCtx(), inOut.getC_BPartner_ID(), inOut.get_TrxName());
                MBPartnerLocation bloc = new MBPartnerLocation(inOut.getCtx(), inOut.getC_BPartner_Location_ID(), inOut.get_TrxName());
                Receptor receptor = new Receptor();
                receptor.setRUTRecep(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
                String RznSocRecepStr = BP.getName();
                RznSocRecepStr = RznSocRecepStr.replace("'", "");
                RznSocRecepStr = RznSocRecepStr.replace("\"", "");
                receptor.setRznSocRecep(RznSocRecepStr);
                String dirRecepStr = bloc.get_ValueAsString("Address1");
                dirRecepStr = dirRecepStr.replace("'", "");
                dirRecepStr = dirRecepStr.replace("\"", "");
                receptor.setDirRecep(dirRecepStr);
                String CmnaRecepStr = null;
                if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                    MCity dCity = new MCity(inOut.getCtx(), bloc.get_ValueAsInt("C_City_ID"), inOut.get_TrxName());
                    CmnaRecepStr = dCity.getName();
                }
                receptor.setCmnaRecep(CmnaRecepStr);
                String ciudadTxt = "";
                if (bloc.get_ValueAsInt("C_Province_ID") > 0) {
                    X_C_Province prov = new X_C_Province(inOut.getCtx(), bloc.get_ValueAsInt("C_Province_ID"), inOut.get_TrxName());
                    ciudadTxt = prov.getName();
                }
                receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
                receptor.setGiroRecep((String)BP.get_Value("Giro"));
                String strContacto = bloc.get_ValueAsString("Phone");
                dirRecepStr = dirRecepStr.replace("'", "");
                dirRecepStr = dirRecepStr.replace("\"", "");
                receptor.setContacto(strContacto);
                doc.getEncabezado().setReceptor(receptor);
                BigDecimal amountGrandT = Env.ZERO;
                BigDecimal priceT = Env.ZERO;
                BigDecimal taxAmt = Env.ZERO;
                BigDecimal taxIVAAmt = Env.ZERO;
                BigDecimal taxIVAAmtAcu = Env.ZERO;
                BigDecimal taxExeAmtAcu = Env.ZERO;
                BigDecimal taxNetoAmtAcu = Env.ZERO;
                if (inOut.getC_Order_ID() > 0) {
                    MInOutLine[] iLines2 = inOut.getLines();
                    int a = 0;
                    while (a < iLines2.length) {
                        priceT = Env.ZERO;
                        taxAmt = Env.ZERO;
                        taxIVAAmt = Env.ZERO;
                        MInOutLine iLine = iLines2[a];
                        priceT = iLine.getC_OrderLine().getPriceEntered();
                        BigDecimal qtyO = iLine.getQtyEntered();
                        priceT = priceT.multiply(qtyO);
                        if (iLine.getC_OrderLine().getC_Tax_ID() > 0) {
                            if (iLine.getC_OrderLine().getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                                taxAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                                taxAmt = taxAmt.divide(Env.ONEHUNDRED);
                            }
                            if (iLine.getC_OrderLine().getC_Tax().isTaxExempt()) {
                                taxExeAmtAcu = taxExeAmtAcu.add(priceT);
                            }
                            if (iLine.getC_OrderLine().getC_Tax().getName().toUpperCase().contains("IVA") && iLine.getC_OrderLine().getC_Tax().getRate().compareTo(new BigDecimal("19.0")) == 0) {
                                taxIVAAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                                taxIVAAmt = taxIVAAmt.divide(Env.ONEHUNDRED);
                            }
                            taxNetoAmtAcu = taxNetoAmtAcu.add(priceT);
                        }
                        amountGrandT = amountGrandT.add(priceT.add(taxAmt));
                        taxIVAAmtAcu = taxIVAAmtAcu.add(taxIVAAmt);
                        ++a;
                    }
                }
                Totales totales = new Totales();
                totales.setMntTotal(amountGrandT.toBigInteger());
                totales.setMntNeto(taxNetoAmtAcu.toBigInteger());
                totales.setMntExe(taxExeAmtAcu.toBigInteger());
                if (taxNetoAmtAcu.signum() > 0) {
                    totales.setTasaIVA(BigDecimal.valueOf(19L));
                }
                BigDecimal ivaamt = Env.ZERO;
                totales.setIVA(taxIVAAmtAcu.toBigInteger());
                doc.getEncabezado().setTotales(totales);
                MInOutLine[] iLines = inOut.getLines(false);
                int lineInvoice = 0;
                boolean lineDiscount = false;
                int i = 0;
                while (i < iLines.length) {
                    MInOutLine iLine = iLines[i];
                    if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                        ++lineInvoice;
                        Detalle det = new Detalle();
                        CdgItem cdgItem = new CdgItem();
                        cdgItem.setTpoCodigo("INT1");
                        cdgItem.setVlrCodigo(iLine.getProduct().getValue());
                        det.getCdgItem().add(cdgItem);
                        det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                        String pname = "";
                        if (iLine.getProduct() != null) {
                            pname = iLine.getProduct().getName();
                            pname = iLine.getM_Product().getUPC() != null && iLine.getM_Product().getUPC().trim().length() > 0 ? String.valueOf(pname) + iLine.getM_Product().getUPC() : iLine.getC_Charge().getName();
                            pname = pname.replace("'", "");
                            pname = pname.replace("\"", "");
                            det.setNmbItem(pname);
                            det.setQtyItem(iLine.getMovementQty());
                            BigDecimal mtoItem = Env.ZERO;
                            BigDecimal prcRefMnt = Env.ZERO;
                            if (iLine.getC_OrderLine_ID() > 0) {
                                prcRefMnt = iLine.getC_OrderLine().getPriceEntered();
                                mtoItem = prcRefMnt.multiply(iLine.getQtyEntered());
                            }
                            det.setPrcItem(prcRefMnt.setScale(0, 4));
                            det.setMontoItem(mtoItem.setScale(0, 4).toBigInteger());
                            if (iLine.getDescription() != null && iLine.getDescription() != "" && inOut.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                                det.setDscItem(iLine.getDescription() == null ? " " : iLine.getDescription());
                            }
                            String unmdItemStr = "";
                            unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                            if (unmdItemStr == null) {
                                unmdItemStr = "UN";
                            }
                            det.setUnmdItem(unmdItemStr);
                            doc.getDetalle().add(det);
                        }
                    }
                    ++i;
                }
                String tiporeferencia = new String();
                String folioreferencia = new String();
                String fechareferencia = new String();
                int tipo_Ref = 0;
                if (inOut.getPOReference() != null && inOut.getPOReference().length() > 0 && inOut.getC_DocType().getDocBaseType().compareTo("ARC") != 0 && inOut.getPOReference().compareTo("0") != 0) {
                    tiporeferencia = "801";
                    folioreferencia = inOut.getPOReference();
                    fechareferencia = inOut.getDateOrdered() != null ? this.ConverDateToString(inOut.getDateOrdered()) : this.ConverDateToString(inOut.getMovementDate());
                    tipo_Ref = 2;
                }
                int indice = 0;
                if (tipo_Ref > 0) {
                    ++indice;
                    Referencia reference = new Referencia();
                    try {
                        reference.setNroLinRef(BigInteger.valueOf(indice));
                        reference.setTpoDocRef(tiporeferencia);
                        reference.setFolioRef(folioreferencia);
                        reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                        reference.setCodRef(Referencia_CodRef.n1);
                        String razonRefTxt = inOut.get_ValueAsString("RazonRef");
                        if (razonRefTxt != null && razonRefTxt.trim().length() > 1) {
                            reference.setRazonRef(razonRefTxt);
                        }
                        doc.getReferencia().add(reference);
                    }
                    catch (LtException e) {
                        e.printStackTrace();
                    }
                }
                PersonalizadosA personalizados = new PersonalizadosA();
                dte.setPersonalizados(personalizados);
                if (inOut.getDescription() != null) {
                    personalizados.setDocPersonalizado(new DocPersonalizadoA());
                    CampoStringA campoString = new CampoStringA();
                    campoString.setName("Notas");
                    campoString.setPrimitiveValue(inOut.getDescription());
                    personalizados.getDocPersonalizado().getCampoString().add(campoString);
                }
                String ambiente = "T";
                if (OFBForward.AmbienteGDE().compareToIgnoreCase("H") == 0) {
                    ambiente = "T";
                } else if (OFBForward.AmbienteGDE().compareToIgnoreCase("P") == 0) {
                    ambiente = "P";
                }
                String fechaResolucion = org.get_ValueAsString("FchResol");
                int numeroResolucion = Integer.parseInt(org.get_ValueAsString("NroResol"));
                int tipoPdf417 = 1;
                String apiURL = "http://192.168.0.200/api/Core.svc/Core";
                String apiAuth = OFBForward.GDEapiAuth();
                Servicio servicio = new Servicio(apiURL, apiAuth);
                ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
                dte.toXml();
                this.log.config("dte " + dte.toXml());
                this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
                if (resultado.getResultadoServicio().getEstado() == 0) {
                    ted = resultado.getTED();
                    pdf417 = resultado.getPDF417();
                    error = resultado.getResultadoServicio().getDescripcion();
                } else {
                    error = resultado.getResultadoServicio().getDescripcion();
                }
                inOut.set_CustomColumn("DescriptionGDE", error);
                inOut.saveEx(inOut.get_TrxName());
                Thread.sleep(4000L);
                GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
                int tipoDTE = 33;
                tipoDTE = docType.get_ValueAsString("DocumentNo").compareTo("33") == 0 ? 33 : (docType.get_ValueAsString("DocumentNo").compareTo("34") == 0 ? 34 : (docType.get_ValueAsString("DocumentNo").compareTo("56") == 0 ? 56 : (docType.get_ValueAsString("DocumentNo").compareTo("52") == 0 ? 52 : (docType.get_ValueAsString("DocumentNo").compareTo("61") == 0 ? 61 : 52))));
                long folio = Long.parseLong(inOut.getDocumentNo());
                ResultadoRecuperarPDF resultadoPDF = servicio.RecuperarPdf(ambiente, grupo, (String)org.get_Value("Rut"), tipoDTE, folio);
                if (resultadoPDF.getResultadoServicio().getEstado() == 0 || resultadoPDF.getResultadoServicio().getEstado() == 1) {
                    this.log.config("datos Usados: apiURL=" + apiURL + " - apiAuth=" + apiAuth + " - ambiente=" + ambiente + " - grupo=" + grupo + " - rut=" + (String)org.get_Value("Rut") + " - tipoDTE=" + tipoDTE + " - folio=" + folio);
                    this.log.config("log resultado: " + resultadoPDF.getResultadoServicio().getDescripcion() + " - " + resultadoPDF.getResultadoServicio().getExcepcionOriginal() + " - " + resultadoPDF.getResultadoServicio().getEstado());
                    byte[] pdf = resultadoPDF.getDatos();
                    if (pdf == null) break block70;
                    String ExportDir = "";
                    try {
                        String pathServer = OFBForward.PathGDEServer();
                        String pathCliente = OFBForward.PathGDEClient();
                        if (pathServer == null || pathCliente == null || pathServer.trim().length() <= 0 || pathCliente.trim().length() <= 0) break block70;
                        File theDir = new File(pathServer);
                        if (!theDir.exists()) {
                            ExportDir = pathCliente;
                        }
                        this.log.config("Archivo a guardar: " + ExportDir + folio + ".pdf");
                        FileOutputStream out = new FileOutputStream(String.valueOf(ExportDir) + folio + ".pdf");
                        ((OutputStream)out).write(pdf);
                        ((OutputStream)out).close();
                        String remote_working_dir_path = OFBForward.GDEDirPath();
                        String local_filepath = String.valueOf(ExportDir) + folio + ".pdf";
                        String remote_filename = String.valueOf(folio) + ".pdf";
                        String finalURL = String.valueOf(OFBForward.GDERemoteURL()) + folio + ".pdf";
                        FileInputStream fis = new FileInputStream(local_filepath);
                        FTPClient client = new FTPClient();
                        try {
                            try {
                                client.setBufferSize(512);
                                client.connect(OFBForward.GDEFTPServer(), OFBForward.GDEFTPServerPort());
                                client.login(OFBForward.GDEFTPUser(), OFBForward.GDEFTPPass());
                                client.enterLocalPassiveMode();
                                client.setFileType(2);
                                client.changeWorkingDirectory(remote_working_dir_path);
                                boolean uploadFile = client.storeFile(remote_filename, (InputStream)fis);
                                client.logout();
                                client.disconnect();
                                if (!uploadFile) {
                                    throw new Exception("Error al subir el fichero");
                                }
                                inOut.set_CustomColumn("UrlGde", finalURL);
                                inOut.saveEx(this.get_TrxName());
                            }
                            catch (Exception eFTPClient) {
                                this.log.config("ERROR: " + eFTPClient.toString());
                                fis.close();
                                break block70;
                            }
                        }
                        catch (Throwable throwable) {
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block70;
                }
                error = String.valueOf(error) + resultado.getResultadoServicio().getDescripcion();
            }
            catch (Exception e) {
                this.log.config(e.toString());
                error = e.toString();
            }
        }
        return "Procesado" + error + " - " + ted + " - " + pdf417;
    }

    public String ConverDateToString(Timestamp fecha) {
        String dateReturn = "";
        this.log.config("month" + fecha.getMonth() + 1);
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }
}

