/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelArtValidTenderType
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtValidTenderType.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 & po.get_Table_ID() == MInvoice.Table_ID && (po.is_ValueChanged("PaymentRule") || po.is_ValueChanged("C_PaymentTerm_ID")) && (inv = (MInvoice)po).isSOTrx() && inv.getDocStatus().compareTo(DOCSTATUS_Completed) != 0 && inv.getDocStatus().compareTo("CL") != 0) {
            String OldValueStr = DB.getSQLValueString(po.get_TrxName(), "SELECT Description FROM AD_Ref_List  WHERE  AD_Reference_ID=195 AND Value = '" + inv.getC_BPartner().getPaymentRule() + "'", new Object[0]);
            String NewValueStr = DB.getSQLValueString(po.get_TrxName(), "SELECT Description FROM AD_Ref_List  WHERE  AD_Reference_ID=195 AND Value = '" + po.get_Value("PaymentRule") + "'", new Object[0]);
            int oldValue = 0;
            int newValue = 0;
            if (OldValueStr != null && OldValueStr.trim().length() > 0 && NewValueStr != null && NewValueStr.trim().length() > 0) {
                oldValue = Integer.parseInt(OldValueStr);
                newValue = Integer.parseInt(NewValueStr);
                if (newValue > oldValue) {
                    return "ERROR: Regla de pago no valida";
                }
            }
            int tPagoNew = po.get_ValueAsInt("C_PaymentTerm_ID");
            int tPagoOld = inv.getC_BPartner().getC_PaymentTerm_ID();
            if (tPagoNew > 0 && tPagoOld > 0) {
                MPaymentTerm ptnew = new MPaymentTerm(po.getCtx(), tPagoNew, po.get_TrxName());
                MPaymentTerm ptold = new MPaymentTerm(po.getCtx(), tPagoOld, po.get_TrxName());
                int ptOldValue = Integer.parseInt(ptold.getDescription());
                int ptNewValue = Integer.parseInt(ptnew.getDescription());
                if (ptNewValue > ptOldValue) {
                    return "ERROR: T\u00e9rmino de pago no permitido";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

