/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelArtValidMovementQty
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtValidMovementQty.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Movement", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MMovement.Table_ID) {
            MMovement mov = (MMovement)po;
            log.config("estado " + mov.getDocStatus());
            String sqllines = "SELECT movl.m_product_id as m_product_id,  ml.m_warehouse_id as m_warehouse_id, mlto.m_warehouse_id as m_warehouseto_id,  coalesce(sum(movl.movementqty),0) as movementqty FROM m_movementline movl INNER JOIN m_locator ml on ml.m_locator_id = movl.m_locator_id  INNER JOIN m_locator mlto on mlto.m_locator_id = movl.m_locatorto_id  INNER JOIN m_warehouse mw on mw.m_warehouse_id = ml.m_warehouse_id  INNER JOIN m_warehouse mwto on mwto.m_warehouse_id = mlto.m_warehouse_id  WHERE movl.m_movement_id = " + mov.get_ID() + " " + " GROUP BY movl.m_product_id, ml.m_warehouse_id, mlto.m_warehouse_id ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                log.config("sqllines " + sqllines);
                pstmt = DB.prepareStatement(sqllines, po.get_TrxName());
                rs = pstmt.executeQuery();
                BigDecimal stock = Env.ZERO;
                BigDecimal reserved = Env.ZERO;
                BigDecimal available = Env.ZERO;
                while (rs.next()) {
                    stock = Env.ZERO;
                    reserved = Env.ZERO;
                    log.config(" id w " + rs.getInt("m_warehouse_id"));
                    log.config(" id wto " + rs.getInt("m_warehouseto_id"));
                    if (rs.getInt("m_warehouse_id") == rs.getInt("m_warehouseto_id")) continue;
                    String sql = "SELECT coalesce(sum(qtyonhand),0) from m_storage where m_locator_id in ( select m_locator_id from m_locator where m_warehouse_id = ? )  AND m_product_id = ? AND isactive='Y' ";
                    stock = DB.getSQLValueBD(po.get_TrxName(), sql, rs.getInt("m_warehouse_id"), rs.getInt("m_product_id"));
                    sql = "SELECT coalesce(sum(movementqty),0) from artilec_stock_reserva_v where m_warehouse_id = ?  AND m_product_id = ? ";
                    reserved = DB.getSQLValueBD(po.get_TrxName(), sql, rs.getInt("m_warehouse_id"), rs.getInt("m_product_id"));
                    available = stock.subtract(reserved);
                    if (rs.getBigDecimal("movementqty").compareTo(available) <= 0) continue;
                    MProduct prod = new MProduct(po.getCtx(), rs.getInt("m_product_id"), po.get_TrxName());
                    return "La cantidad solicitada para " + prod.getName() + " no es suficiente: Solicitado " + rs.getBigDecimal("movementqty") + " Disponible " + available;
                }
                pstmt.close();
                rs.close();
            }
            catch (Exception e) {
                log.config("Exception " + e.toString());
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

