/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelArtShipment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtShipment.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_InOutLine", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MProject pro;
        MOrder order;
        MInOutLine sLine;
        MInOut ship;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == MInOutLine.Table_ID && (ship = (sLine = (MInOutLine)po).getParent()).getC_Order_ID() > 0 && (order = new MOrder(po.getCtx(), ship.getC_Order_ID(), po.get_TrxName())).getC_Project_ID() > 0 && (pro = new MProject(po.getCtx(), order.getC_Project_ID(), po.get_TrxName())).get_ValueAsInt("M_Locator_ID") > 0) {
            DB.executeUpdate("UPDATE M_InOutLine SET M_Locator_ID = " + pro.get_ValueAsInt("M_Locator_ID") + " WHERE M_InOutLine_ID = " + sLine.get_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        BigDecimal qtyStock;
        MInOutLine sline;
        int i;
        MInOutLine[] sLines;
        MInOut ship;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if ((timing == 1 || timing == 7) && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)po).isSOTrx() && ship.getC_DocType().getDocBaseType().compareTo("MMS") == 0) {
            sLines = ship.getLines(false);
            i = 0;
            while (i < sLines.length) {
                sline = sLines[i];
                if (sline.getM_Product_ID() > 0 && sline.getM_Product().getProductType().compareTo("I") == 0) {
                    qtyStock = DB.getSQLValueBD(po.get_TrxName(), "SELECT bomqtyonhand(" + sline.getM_Product_ID() + ",ml.M_Warehouse_ID,ml.M_Locator_ID) " + " FROM M_Locator ml WHERE M_Warehouse_ID = " + ship.getM_Warehouse_ID() + " AND M_Locator_ID = " + sline.getM_Locator_ID(), new Object[0]);
                    if (qtyStock == null) {
                        qtyStock = Env.ZERO;
                    }
                    if (sline.getQtyEntered().compareTo(qtyStock) > 0) {
                        throw new AdempiereException("ERROR: No se puede procesar despacho por error de  stock en la ubicaci\u00f3n. Producto:" + sline.getM_Product().getName() + ". Ubicaci\u00f3n:" + sline.getM_Locator().getValue());
                    }
                }
                ++i;
            }
        }
        if ((timing == 1 || timing == 7) && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)po).isSOTrx() && ship.getC_DocType().getDocBaseType().compareTo("MMS") == 0) {
            sLines = ship.getLines(false);
            i = 0;
            while (i < sLines.length) {
                sline = sLines[i];
                if (sline.getM_Product_ID() > 0 && sline.getC_OrderLine_ID() > 0) {
                    qtyStock = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(qtyEntered) FROM M_InOutLine iol WHERE C_OrderLine_ID = " + sline.getC_OrderLine_ID(), new Object[0]);
                    if (qtyStock == null) {
                        qtyStock = Env.ZERO;
                    }
                    if (qtyStock.compareTo(sline.getC_OrderLine().getQtyEntered()) > 0) {
                        throw new AdempiereException("ERROR: No se puede procesar despacho. Sin saldo pendiente  en la cotizaci\u00f3n. Linea:" + sline.getC_OrderLine().getLine() + ". Producto:" + sline.getM_Product().getName());
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

