/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRole;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelArtPriceLimitOnComplete
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtPriceLimitOnComplete.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 1 && po.get_Table_ID() == MOrder.Table_ID) {
            boolean flag = false;
            String message = "";
            MOrder ord = (MOrder)po;
            MRole role = new MRole(po.getCtx(), Env.getAD_Role_ID(po.getCtx()), po.get_TrxName());
            String descrole = null;
            descrole = role.getDescription() == null ? "-" : role.getDescription().toLowerCase();
            boolean issotrx = ord.isSOTrx();
            if (issotrx && !descrole.contains("aprueba ov")) {
                String sql = "SELECT c_orderline_id from c_orderline where c_order_id = ?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, ord.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MOrderLine ordl = new MOrderLine(po.getCtx(), rs.getInt("C_Orderline_ID"), po.get_TrxName());
                        if (ordl.getPriceLimit().compareTo(ordl.getPriceActual()) <= 0) continue;
                        flag = true;
                        message = message.concat(ordl.getProduct().getName()).concat(" ");
                    }
                    if (flag) {
                        throw new AdempiereException("Existe lineas con diferencia en el precio limite. Productos " + message + ". Debe " + " solicitar aprobacion");
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                }
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

