/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MMovementLine;
import org.compiere.model.MStorage;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelArtLineMovement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtLineMovement.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_MovementLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MMovementLine.Table_ID) {
            BigDecimal amt;
            MMovementLine mLine = (MMovementLine)po;
            BigDecimal available = MStorage.getQtyAvailable(0, mLine.getM_Locator_ID(), mLine.getM_Product_ID(), mLine.getM_AttributeSetInstance_ID(), mLine.get_TrxName());
            if (available == null) {
                available = Env.ZERO;
            }
            if ((amt = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(MovementQty) FROM M_MovementLine WHERE M_Movement_ID =" + mLine.getM_Movement_ID() + " AND IsActive = 'Y' AND M_MovementLine_ID <> " + mLine.get_ID() + " AND M_Product_ID = " + mLine.getM_Product_ID() + " AND M_Locator_ID = " + mLine.getM_Locator_ID(), new Object[0])) == null) {
                amt = Env.ZERO;
            }
            if ((amt = amt.add(mLine.getMovementQty())).compareTo(available) > 0) {
                return "ERROR: Stock insuficiente";
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

