/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ModelArtCOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtCOrder.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 1 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            int cantP;
            int flag = DB.getSQLValue(po.get_TrxName(), "SELECT artilec_funcion_comprobacion_credito(" + order.get_ID() + ")");
            if (flag > 0 && (order.getPaymentRule().equals("P") || order.getPaymentRule().equals("S"))) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "ARTILEC_NoCreditBPNV", true));
            }
            int cant = DB.getSQLValue(po.get_TrxName(), "select count(1) from rvofb_stocklineartilec WHERE qtyordered > 0 AND  c_order_id=" + order.get_ID() + " and dif < 0");
            if (cant > 0) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "ARTILEC_NoStockNV", true));
            }
            if (order.getC_Project_ID() > 0 && (cantP = DB.getSQLValue(po.get_TrxName(), "select count(1) from rvofb_stocklineartilecProy where c_order_id=" + order.get_ID() + " and dif < 0")) > 0) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "ARTILEC_NoStockNV", true));
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

