/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.io.FileUtils;
import org.compiere.Adempiere;
import org.compiere.model.MMigration;
import org.compiere.model.MTable;
import org.compiere.process.CleanUpGW;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdate;
import org.compiere.process.SequenceCheck;
import org.compiere.process.SynchronizeTerminology;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrationLoader {
    DocumentBuilder builder;
    private static CLogger log = CLogger.getCLogger(MigrationLoader.class);
    private MMigration m_Migration;
    public Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    };

    static String readFile(File file, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        return new String(encoded, encoding);
    }

    public void loadXML(File file, Boolean apply) {
        Boolean success = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            this.builder = dbf.newDocumentBuilder();
            List<File> migrationFiles = new ArrayList<File>();
            if (!file.exists()) {
                log.log(Level.WARNING, "No file or directory found");
                return;
            }
            if (file.isDirectory()) {
                log.log(Level.CONFIG, "Processing migration files in directory: " + file.getAbsolutePath());
                migrationFiles = (List)FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true);
                Collections.sort(migrationFiles, this.fileComparator);
            } else {
                log.log(Level.CONFIG, "Processing migration file: " + file.getAbsolutePath());
                migrationFiles.add(file);
            }
            for (File migFile : migrationFiles) {
                this.loadFile(migFile, apply);
            }
            success = true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (apply.booleanValue() && success.booleanValue()) {
            ProcessInfo pi = new ProcessInfo("Sequence Check", 258);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            SequenceCheck scheck = new SequenceCheck();
            scheck.startProcess(Env.getCtx(), pi, null);
            log.log(Level.CONFIG, "Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
            pi = new ProcessInfo("Synchronize Terminology", 172);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            SynchronizeTerminology sc = new SynchronizeTerminology();
            sc.startProcess(Env.getCtx(), pi, null);
            log.log(Level.CONFIG, "Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
            pi = new ProcessInfo("Role Access Update", 295);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            RoleAccessUpdate rau = new RoleAccessUpdate();
            rau.startProcess(Env.getCtx(), pi, null);
            log.log(Level.CONFIG, "Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
            pi = new ProcessInfo("Updating Garden World", 53733);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            CleanUpGW updateGW = new CleanUpGW();
            updateGW.startProcess(Env.getCtx(), pi, null);
            log.log(Level.CONFIG, "Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
        }
    }

    public void loadFile(File file, Boolean apply) throws SAXException, IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.getName().endsWith(".xml")) {
            return;
        }
        if (file.getName().equals("build.xml")) {
            return;
        }
        log.log(Level.CONFIG, "Loading file: " + file);
        Document doc = this.builder.parse(file);
        NodeList migrations = doc.getDocumentElement().getElementsByTagName("Migration");
        for (int i = 0; i < migrations.getLength(); ++i) {
            Trx.run(new TrxRunnable(){
                private Properties ctx;
                private Element element;
                private MigrationLoader loader;

                TrxRunnable setParameters(Properties ctx, Element element, MigrationLoader loader) {
                    this.ctx = ctx;
                    this.element = element;
                    this.loader = loader;
                    return this;
                }

                @Override
                public void run(String trxName) {
                    try {
                        MMigration mig = MMigration.fromXmlNode(this.ctx, this.element, trxName);
                        if (this.loader != null) {
                            this.loader.setMigration(mig);
                        }
                        if (mig == null) {
                            log.log(Level.CONFIG, "XML file not a Migration. Skipping.");
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }.setParameters(Env.getCtx(), (Element)migrations.item(i), this));
        }
        if (apply.booleanValue()) {
            this.applyMigration(this.m_Migration);
        }
    }

    private void applyMigration(MMigration migration) {
        if (migration == null) {
            return;
        }
        if ("A".equals(migration.getStatusCode())) {
            log.log(Level.CONFIG, migration.toString() + " ---> Migration already applied - skipping.");
            return;
        }
        log.log(Level.CONFIG, migration.toString());
        migration.setFailOnError(false);
        try {
            migration.apply();
        }
        catch (AdempiereException e) {
            throw new AdempiereException(e);
        }
        finally {
            migration.updateStatus(null);
        }
    }

    protected void setMigration(MMigration mig) {
        this.m_Migration = mig;
    }

    public void applyMigrations() {
        String where = "IsActive='Y'";
        List migrations = MTable.get(Env.getCtx(), "AD_Migration").createQuery(where, null).setOrderBy("SeqNo").list();
        for (MMigration migration : migrations) {
            this.applyMigration(migration);
        }
    }

    public static void main(String[] args) {
        Boolean clean_migrations = false;
        if (args.length > 0) {
            clean_migrations = args[0].equals("clean");
        }
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.CONFIG);
        if (!DB.isConnected()) {
            log.info("No DB Connection");
            System.exit(1);
        }
        File home = new File(Adempiere.getAdempiereHome() + File.separator + "migration");
        Boolean apply = true;
        MigrationLoader loader = new MigrationLoader();
        loader.loadXML(home, apply);
        loader.clean(Env.getCtx(), clean_migrations, null);
    }

    private void clean(Properties ctx, Boolean clean_migrations, String trxName) {
        if (!clean_migrations.booleanValue()) {
            return;
        }
        MMigration migration = new MMigration(ctx, 0, trxName);
        if (migration.get_ColumnIndex("Processed") < 0) {
            return;
        }
        migration = null;
        Boolean notProcessed = false;
        for (MMigration mig : MMigration.getMigrations(ctx, notProcessed, trxName)) {
            if (mig == null) continue;
            mig.clean();
        }
    }
}

