/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.X_C_Invoice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class InvoiceGenerateFromShipment
extends SvrProcess {
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_InOut_ID = 0;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "CO";
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("M_InOut_ID")) {
                this.p_M_InOut_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", M_InOut_ID=" + this.p_M_InOut_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT M_InOut.* FROM M_InOut, T_Selection WHERE M_InOut.DocStatus='CO' AND M_InOut.IsSOTrx='Y'  AND M_InOut.M_InOut_ID = T_Selection.T_Selection_ID  AND T_Selection.AD_PInstance_ID=? ORDER BY M_InOut.M_InOut_ID";
        } else {
            sql = "SELECT * FROM M_InOut o WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y'";
            if (this.p_AD_Org_ID != 0) {
                sql = sql + " AND AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND C_BPartner_ID=?";
            }
            if (this.p_M_InOut_ID != 0) {
                sql = sql + " AND M_InOut_ID=?";
            }
            sql = sql + " AND EXISTS (SELECT * FROM M_InOutLine ol WHERE o.M_InOut_ID=ol.M_InOut_ID AND ol.IsInvoiced='N') ORDER BY M_InOut_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else {
                if (this.p_AD_Org_ID != 0) {
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_M_InOut_ID != 0) {
                    pstmt.setInt(index++, this.p_M_InOut_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return this.generate(pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generate(PreparedStatement pstmt) {
        ResultSet rs = null;
        X_C_Invoice invoice = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MInOut inOut = new MInOut(this.getCtx(), rs, this.get_TrxName());
                if (!inOut.isComplete() || inOut.getDocStatus().equals("RE")) continue;
                MOrder order = new MOrder(this.getCtx(), inOut.getC_Order_ID(), this.get_TrxName());
                if (!this.p_ConsolidateDocument || invoice != null && invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                    invoice = this.completeInvoice((MInvoice)invoice);
                }
                boolean doInvoice = false;
                if ("S".equals(order.getInvoiceRule())) {
                    this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                    if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                        this.log.warning("BPartner has no Schedule - set to After Delivery");
                        order.setInvoiceRule("D");
                        order.save();
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    MInOutLine[] shipLines = inOut.getLines(false);
                    for (int j = 0; j < shipLines.length; ++j) {
                        MInOutLine inOutLine = shipLines[j];
                        if (inOutLine.isInvoiced()) continue;
                        invoice = this.createInvoiceLineFromShipmentLine((MInvoice)invoice, order, inOut, inOutLine);
                    }
                    this.m_line += 1000;
                    continue;
                }
                throw new AdempiereException("Not supported Invoice Rules[Immediate, AfterOrderDelivered]");
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        finally {
            DB.close(rs, pstmt);
            pstmt = null;
        }
        this.completeInvoice((MInvoice)invoice);
        return "@Created@ = " + this.m_created;
    }

    private MInvoice createInvoiceLineFromShipmentLine(MInvoice invoice, MOrder order, MInOut inOut, MInOutLine inOutLine) {
        if (invoice == null && !(invoice = new MInvoice(inOut, this.p_DateInvoiced)).save()) {
            throw new IllegalStateException("Could not create Invoice (s)");
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != inOut.getM_InOut_ID()) {
            MDocType dt = MDocType.get(this.getCtx(), inOut.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != inOut.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), inOut.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            String referenceDescr = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + inOut.getDocumentNo() + " - " + format.format(inOut.getMovementDate());
            this.m_ship = inOut;
            MInvoiceLine descInvLine = new MInvoiceLine(invoice);
            descInvLine.setIsDescription(true);
            descInvLine.setDescription(referenceDescr);
            descInvLine.setLine(this.m_line + inOutLine.getLine() - 2);
            if (!descInvLine.save()) {
                throw new IllegalStateException("Could not create Invoice Comment Line (sh)");
            }
            if (order.getBill_Location_ID() != inOut.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation(this.getCtx(), inOut.getC_BPartner_Location_ID(), null);
                descInvLine = new MInvoiceLine(invoice);
                descInvLine.setIsDescription(true);
                descInvLine.setDescription(addr.toString());
                descInvLine.setLine(this.m_line + inOutLine.getLine() - 1);
                if (!descInvLine.save()) {
                    throw new IllegalStateException("Could not create Invoice Comment Line 2 (sh)");
                }
            }
        }
        MInvoiceLine invLine = new MInvoiceLine(invoice);
        invLine.setShipLine(inOutLine);
        if (inOutLine.sameOrderLineUOM()) {
            invLine.setQtyEntered(inOutLine.getQtyEntered());
        } else {
            invLine.setQtyEntered(inOutLine.getMovementQty());
        }
        invLine.setQtyInvoiced(inOutLine.getMovementQty());
        invLine.setLine(this.m_line + inOutLine.getLine());
        String toBeInvoiced = inOutLine.get_ValueAsString("ToBeInvoiced");
        if ("N".equals(toBeInvoiced) || "false".equals(toBeInvoiced)) {
            invLine.setPriceEntered(Env.ZERO);
            invLine.setPriceActual(Env.ZERO);
            invLine.setPriceList(Env.ZERO);
            invLine.setPriceLimit(Env.ZERO);
            invLine.setLineNetAmt(Env.ZERO);
            invLine.setIsDescription(true);
        }
        if (!invLine.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        inOutLine.setIsInvoiced(true);
        if (!inOutLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(invLine.toString());
        return invoice;
    }

    private MInvoice completeInvoice(MInvoice invoice) {
        if (invoice != null) {
            if (!invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + invoice);
                this.addLog("completeInvoice - failed: " + invoice);
            }
            invoice.save();
            this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), null, invoice.getDocumentNo());
            ++this.m_created;
        }
        invoice = null;
        this.m_ship = null;
        this.m_line = 0;
        return invoice;
    }
}

