/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MCity;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MLanguage;
import org.compiere.model.MSetup;
import org.compiere.model.Query;
import org.compiere.print.PrintUtil;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

public class InitialClientSetup
extends SvrProcess {
    protected String p_ClientName = null;
    protected String p_OrgValue = null;
    protected String p_OrgName = null;
    protected String p_AdminUserName = null;
    protected String p_NormalUserName = null;
    protected int p_C_Currency_ID = 0;
    protected int p_C_Country_ID = 0;
    protected int p_C_Region_ID = 0;
    protected String p_CityName = null;
    protected String p_Postal = null;
    protected String p_Address1 = null;
    protected String p_Phone = null;
    protected String p_Phone2 = null;
    protected String p_Fax = null;
    protected String p_EMail = null;
    protected String p_TaxID = null;
    protected int p_C_City_ID = 0;
    protected boolean p_IsUseBPDimension = true;
    protected boolean p_IsUseProductDimension = true;
    protected boolean p_IsUseProjectDimension = false;
    protected boolean p_IsUseCampaignDimension = false;
    protected boolean p_IsUseSalesRegionDimension = false;
    protected String p_CoAFile = null;
    protected String p_logoFile = null;
    protected Timestamp p_startDate = null;
    protected int p_historyYears = 0;
    protected String p_DUNS = null;
    protected String p_bankName = null;
    protected String p_routingNo = null;
    protected String p_accountNo = null;
    public static final int WINDOW_THIS_PROCESS = 9999;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("ClientName")) {
                this.p_ClientName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("OrgValue")) {
                this.p_OrgValue = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("OrgName")) {
                this.p_OrgName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("AdminUserName")) {
                this.p_AdminUserName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("NormalUserName")) {
                this.p_NormalUserName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Country_ID")) {
                this.p_C_Country_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Region_ID")) {
                this.p_C_Region_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("CityName")) {
                this.p_CityName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("C_City_ID")) {
                this.p_C_City_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("Postal")) {
                this.p_Postal = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Address1")) {
                this.p_Address1 = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("IsUseBPDimension")) {
                this.p_IsUseBPDimension = para[i].getParameter().equals("Y");
                continue;
            }
            if (name.equals("IsUseProductDimension")) {
                this.p_IsUseProductDimension = para[i].getParameter().equals("Y");
                continue;
            }
            if (name.equals("IsUseProjectDimension")) {
                this.p_IsUseProjectDimension = para[i].getParameter().equals("Y");
                continue;
            }
            if (name.equals("IsUseCampaignDimension")) {
                this.p_IsUseCampaignDimension = para[i].getParameter().equals("Y");
                continue;
            }
            if (name.equals("IsUseSalesRegionDimension")) {
                this.p_IsUseSalesRegionDimension = para[i].getParameter().equals("Y");
                continue;
            }
            if (name.equals("CoAFile")) {
                this.p_CoAFile = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Phone")) {
                this.p_Phone = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Phone2")) {
                this.p_Phone2 = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Fax")) {
                this.p_Fax = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("EMail")) {
                this.p_EMail = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("TaxID")) {
                this.p_TaxID = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("Logo")) {
                this.p_logoFile = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("StartDate")) {
                this.p_startDate = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("HistoryYears")) {
                this.p_historyYears = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DUNS")) {
                this.p_DUNS = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("BankName")) {
                this.p_bankName = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("RoutingNo")) {
                this.p_routingNo = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("AccountNo")) {
                this.p_accountNo = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        File coaFile;
        MCity city;
        this.log.info("InitialClientSetup: ClientName=" + this.p_ClientName + ", OrgValue=" + this.p_OrgValue + ", OrgName=" + this.p_OrgName + ", AdminUserName=" + this.p_AdminUserName + ", NormalUserName=" + this.p_NormalUserName + ", C_Currency_ID=" + this.p_C_Currency_ID + ", C_Country_ID=" + this.p_C_Country_ID + ", C_Region_ID=" + this.p_C_Region_ID + ", CityName=" + this.p_CityName + ", C_City_ID=" + this.p_C_City_ID + ", IsUseBPDimension=" + this.p_IsUseBPDimension + ", IsUseProductDimension=" + this.p_IsUseProductDimension + ", IsUseProjectDimension=" + this.p_IsUseProjectDimension + ", IsUseCampaignDimension=" + this.p_IsUseCampaignDimension + ", IsUseSalesRegionDimension=" + this.p_IsUseSalesRegionDimension + ", CoAFile=" + this.p_CoAFile);
        if (this.p_ClientName == null || this.p_ClientName.length() == 0 || this.p_OrgName == null || this.p_OrgName.length() == 0 || this.p_C_Currency_ID <= 0 || this.p_C_Country_ID <= 0 || this.p_CoAFile == null || this.p_CoAFile.length() == 0) {
            throw new IllegalArgumentException("Missing required parameters");
        }
        if (DB.executeUpdate("UPDATE AD_Client SET CreatedBy=0 WHERE Name=?", new Object[]{this.p_ClientName}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.p_ClientName);
        }
        if (DB.executeUpdate("UPDATE AD_User SET CreatedBy=0 WHERE Name=?", new Object[]{this.p_AdminUserName}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.p_AdminUserName);
        }
        if (DB.executeUpdate("UPDATE AD_User SET CreatedBy=0 WHERE Name=?", new Object[]{this.p_NormalUserName}, false, null) != 0) {
            throw new AdempiereException("@NotUnique@ " + this.p_NormalUserName);
        }
        if (this.p_C_City_ID > 0 && !(city = MCity.get(this.getCtx(), this.p_C_City_ID)).getName().equals(this.p_CityName)) {
            this.log.info("City name changed from " + this.p_CityName + " to " + city.getName());
            this.p_CityName = city.getName();
        }
        if (!(coaFile = new File(this.p_CoAFile)).exists()) {
            throw new AdempiereException("CoaFile " + this.p_CoAFile + " does not exist");
        }
        if (!coaFile.canRead()) {
            throw new AdempiereException("Cannot read CoaFile " + this.p_CoAFile);
        }
        if (!coaFile.isFile()) {
            throw new AdempiereException("CoaFile " + this.p_CoAFile + " is not a file");
        }
        if (coaFile.length() <= 0L) {
            throw new AdempiereException("CoaFile " + this.p_CoAFile + " is empty");
        }
        MSetup ms = null;
        MCountry country = MCountry.get(this.getCtx(), this.p_C_Country_ID);
        try {
            Class<?> ppClass = Class.forName("org.compiere.model.MSetup_" + country.getCountryCode());
            if (ppClass != null) {
                ms = (MSetup)ppClass.newInstance();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ms == null) {
            ms = new MSetup();
        }
        ms.initialize(Env.getCtx(), 9999);
        if (!ms.createClient(this.p_ClientName, this.p_OrgValue, this.p_OrgName, this.p_AdminUserName, this.p_NormalUserName, this.p_Phone, this.p_Phone2, this.p_Fax, this.p_EMail, this.p_TaxID, this.p_DUNS, this.p_logoFile, this.p_C_Country_ID)) {
            ms.rollback();
            throw new AdempiereException("Create client failed");
        }
        this.addLog(ms.getInfo());
        MCurrency currency = MCurrency.get(this.getCtx(), this.p_C_Currency_ID);
        KeyNamePair currency_kp = new KeyNamePair(this.p_C_Currency_ID, currency.getDescription());
        if (!ms.createAccounting(currency_kp, this.p_IsUseProductDimension, this.p_IsUseBPDimension, this.p_IsUseProjectDimension, this.p_IsUseCampaignDimension, this.p_IsUseSalesRegionDimension, this.p_startDate, this.p_historyYears, coaFile)) {
            ms.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        if (!ms.createEntities(this.p_C_Country_ID, this.p_CityName, this.p_C_Region_ID, this.p_C_Currency_ID, this.p_Postal, this.p_Address1)) {
            ms.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        if (!(Util.isEmpty(this.p_bankName) || Util.isEmpty(this.p_routingNo) || Util.isEmpty(this.p_accountNo))) {
            ms.createBank(this.p_bankName, this.p_routingNo, this.p_accountNo, this.p_C_Currency_ID);
        }
        if (!ms.importChart(coaFile)) {
            ms.rollback();
            throw new AdempiereException("@AccountSetupError@");
        }
        this.addLog(ms.getInfo());
        PrintUtil.setupPrintForm(ms.getAD_Client_ID());
        String whereClause = "IsSystemLanguage='Y' AND IsActive='Y'";
        List list = new Query(Env.getCtx(), "AD_Language", whereClause, this.get_TrxName()).list();
        for (MLanguage lang : list) {
            this.log.fine("Updating Translation - " + lang);
            lang.maintain(true);
        }
        return "@OK@";
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.CONFIG);
        String propFileName = Adempiere.getAdempiereHome() + File.separatorChar + "clientsetup.properties";
        if (args.length > 0) {
            propFileName = args[0];
        }
        ProcessInfo pi = new ProcessInfo("Initial Client Setup", 53161);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        Properties prop = new Properties();
        try {
            MCountry country;
            MCurrency currency;
            prop.load(new FileInputStream(propFileName));
            pi.addParameter("ClientName", prop.getProperty("ClientName"), prop.getProperty("ClientName"));
            pi.addParameter("OrgValue", prop.getProperty("OrgValue"), prop.getProperty("OrgValue"));
            pi.addParameter("OrgName", prop.getProperty("OrgName"), prop.getProperty("OrgName"));
            pi.addParameter("AdminUserName", prop.getProperty("AdminUserName"), prop.getProperty("AdminUserName"));
            pi.addParameter("NormalUserName", prop.getProperty("NormalUserName"), prop.getProperty("NormalUserName"));
            if (prop.getProperty("CurrencyCode") != null && (currency = MCurrency.get(Env.getCtx(), prop.getProperty("CurrencyCode"))) != null) {
                pi.addParameter("C_Currency_ID", currency.getC_Currency_ID(), currency.getISO_Code());
            }
            if (prop.getProperty("CountryCode") != null && (country = MCountry.get(Env.getCtx(), prop.getProperty("CountryCode"))) != null) {
                pi.addParameter("C_Country_ID", country.getC_Country_ID(), country.getCountryCode());
            }
            pi.addParameter("C_Region_ID", prop.getProperty("C_Region_ID"), prop.getProperty("C_Region_ID"));
            pi.addParameter("CityName", prop.getProperty("CityName"), prop.getProperty("CityName"));
            pi.addParameter("C_City_ID", prop.getProperty("C_City_ID"), prop.getProperty("C_City_ID"));
            pi.addParameter("Postal", prop.getProperty("Postal"), prop.getProperty("Postal"));
            pi.addParameter("Address1", prop.getProperty("Address1"), prop.getProperty("Address1"));
            pi.addParameter("IsUseBPDimension", prop.getProperty("IsUseBPDimension"), prop.getProperty("IsUseBPDimension"));
            pi.addParameter("IsUseProductDimension", prop.getProperty("IsUseProductDimension"), prop.getProperty("IsUseProductDimension"));
            pi.addParameter("IsUseProjectDimension", prop.getProperty("IsUseProjectDimension"), prop.getProperty("IsUseProjectDimension"));
            pi.addParameter("IsUseCampaignDimension", prop.getProperty("IsUseCampaignDimension"), prop.getProperty("IsUseCampaignDimension"));
            pi.addParameter("IsUseSalesRegionDimension", prop.getProperty("IsUseSalesRegionDimension"), prop.getProperty("IsUseSalesRegionDimension"));
            pi.addParameter("CoAFile", prop.getProperty("CoAFile"), prop.getProperty("CoAFile"));
            pi.addParameter("Phone", prop.getProperty("Phone"), prop.getProperty("Phone"));
            pi.addParameter("Phone2", prop.getProperty("Phone2"), prop.getProperty("Phone2"));
            pi.addParameter("Fax", prop.getProperty("Fax"), prop.getProperty("Fax"));
            pi.addParameter("EMail", prop.getProperty("EMail"), prop.getProperty("EMail"));
            pi.addParameter("TaxID", prop.getProperty("TaxID"), prop.getProperty("TaxID"));
            pi.addParameter("Logo", prop.getProperty("Logo"), prop.getProperty("Logo"));
            pi.addParameter("StartDate", prop.getProperty("StartDate"), prop.getProperty("StartDate"));
            pi.addParameter("HistoryYears", prop.getProperty("HistoryYears"), prop.getProperty("HistoryYears"));
            pi.addParameter("DUNS", prop.getProperty("DUNS"), prop.getProperty("DUNS"));
            pi.addParameter("BankName", prop.getProperty("BankName"), prop.getProperty("BankName"));
            pi.addParameter("RoutingNo", prop.getProperty("RoutingNo"), prop.getProperty("RoutingNo"));
            pi.addParameter("AccountNo", prop.getProperty("AccountNo"), prop.getProperty("AccountNo"));
        }
        catch (Exception e) {
            // empty catch block
        }
        InitialClientSetup setup = new InitialClientSetup();
        setup.startProcess(Env.getCtx(), pi, null);
    }
}

