/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import org.adempiere.model.MBrowse;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MTask;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.model.X_ASP_Field;
import org.compiere.model.X_ASP_Form;
import org.compiere.model.X_ASP_Process;
import org.compiere.model.X_ASP_Process_Para;
import org.compiere.model.X_ASP_Tab;
import org.compiere.model.X_ASP_Task;
import org.compiere.model.X_ASP_Window;
import org.compiere.model.X_ASP_Workflow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.X_ASP_Browse;

public class ASPGenerateLevel
extends SvrProcess {
    private String p_ASP_Status;
    private int p_AD_Menu_ID;
    private boolean p_IsGenerateFields;
    private int p_ASP_Level_ID;
    private int noWindows = 0;
    private int noTabs = 0;
    private int noFields = 0;
    private int noProcesses = 0;
    private int noParameters = 0;
    private int noForms = 0;
    private int noBrowses = 0;
    private int noTasks = 0;
    private int noWorkflows = 0;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("ASP_Status")) {
                this.p_ASP_Status = (String)para.getParameter();
                continue;
            }
            if (name.equals("AD_Menu_ID")) {
                this.p_AD_Menu_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("IsGenerateFields")) {
                this.p_IsGenerateFields = para.getParameter().equals("Y");
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_ASP_Level_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("ASP_Status=" + this.p_ASP_Status + ", AD_Menu_ID=" + this.p_AD_Menu_ID + ", IsGenerateFields=" + this.p_IsGenerateFields);
        MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        int AD_Tree_ID = clientInfo.getAD_Tree_Menu_ID();
        MTree thisTree = new MTree(this.getCtx(), AD_Tree_ID, true, true, true, this.get_TrxName());
        MTreeNode node = this.p_AD_Menu_ID > 0 ? thisTree.getRoot().findNode(this.p_AD_Menu_ID) : thisTree.getRoot();
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nn = (MTreeNode)en.nextElement();
                if (nn.isSummary()) continue;
                this.addNodeToLevel(nn);
            }
        }
        if (this.noWindows > 0) {
            this.addLog("Window " + this.noWindows);
        }
        if (this.noTabs > 0) {
            this.addLog("Tab " + this.noTabs);
        }
        if (this.noFields > 0) {
            this.addLog("Field " + this.noFields);
        }
        if (this.noProcesses > 0) {
            this.addLog("Process " + this.noProcesses);
        }
        if (this.noParameters > 0) {
            this.addLog("Process Parameter " + this.noParameters);
        }
        if (this.noForms > 0) {
            this.addLog("Form " + this.noForms);
        }
        if (this.noBrowses > 0) {
            this.addLog("noBrowses " + this.noBrowses);
        }
        if (this.noTasks > 0) {
            this.addLog("Task " + this.noTasks);
        }
        if (this.noWorkflows > 0) {
            this.addLog("Workflow " + this.noWorkflows);
        }
        return "@OK@";
    }

    private void addNodeToLevel(MTreeNode nn) {
        MMenu menu = new MMenu(this.getCtx(), nn.getNode_ID(), this.get_TrxName());
        if (menu.getAction().equals("W")) {
            MWindow window = new MWindow(this.getCtx(), menu.getAD_Window_ID(), this.get_TrxName());
            int asp_window_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Window_ID FROM ASP_Window WHERE ASP_Level_ID = ? AND AD_Window_ID = ?", this.p_ASP_Level_ID, window.getAD_Window_ID());
            X_ASP_Window aspWindow = null;
            if (asp_window_id < 1) {
                aspWindow = new X_ASP_Window(this.getCtx(), 0, this.get_TrxName());
                aspWindow.setASP_Level_ID(this.p_ASP_Level_ID);
                aspWindow.setAD_Window_ID(window.getAD_Window_ID());
                aspWindow.setASP_Status(this.p_ASP_Status);
                if (aspWindow.save()) {
                    ++this.noWindows;
                    asp_window_id = aspWindow.getASP_Window_ID();
                }
            } else {
                aspWindow = new X_ASP_Window(this.getCtx(), asp_window_id, this.get_TrxName());
            }
            for (MTab tab : window.getTabs(true, this.get_TrxName())) {
                int asp_tab_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Tab_ID FROM ASP_Tab WHERE ASP_Window_ID = ? AND AD_Tab_ID = ?", asp_window_id, tab.getAD_Tab_ID());
                X_ASP_Tab aspTab = null;
                if (asp_tab_id < 1) {
                    aspTab = new X_ASP_Tab(this.getCtx(), 0, this.get_TrxName());
                    aspTab.setASP_Window_ID(asp_window_id);
                    aspTab.setAD_Tab_ID(tab.getAD_Tab_ID());
                    aspTab.setASP_Status(this.p_ASP_Status);
                    aspTab.setAllFields(!this.p_IsGenerateFields);
                    if (aspTab.save()) {
                        ++this.noTabs;
                        asp_tab_id = aspTab.getASP_Tab_ID();
                    }
                } else {
                    aspTab = new X_ASP_Tab(this.getCtx(), asp_tab_id, this.get_TrxName());
                }
                for (MField field : tab.getFields(true, this.get_TrxName())) {
                    MColumn column;
                    if (this.p_IsGenerateFields && DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Field WHERE ASP_Tab_ID = ? AND AD_Field_ID = ?", aspTab.getASP_Tab_ID(), field.getAD_Field_ID()) < 1) {
                        X_ASP_Field aspField = new X_ASP_Field(this.getCtx(), 0, this.get_TrxName());
                        aspField.setASP_Tab_ID(aspTab.getASP_Tab_ID());
                        aspField.setAD_Field_ID(field.getAD_Field_ID());
                        aspField.setASP_Status(this.p_ASP_Status);
                        if (aspField.save()) {
                            ++this.noFields;
                        }
                    }
                    if ((column = MColumn.get(this.getCtx(), field.getAD_Column_ID())).getAD_Reference_ID() != 28 || column.getAD_Process_ID() <= 0) continue;
                    this.generateProcess(column.getAD_Process_ID());
                }
            }
        } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
            this.generateProcess(menu.getAD_Process_ID());
        } else if (menu.getAction().equals("X")) {
            MForm form = new MForm(this.getCtx(), menu.getAD_Form_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Form WHERE ASP_Level_ID = ? AND AD_Form_ID = ?", this.p_ASP_Level_ID, form.getAD_Form_ID()) < 1) {
                X_ASP_Form aspForm = new X_ASP_Form(this.getCtx(), 0, this.get_TrxName());
                aspForm.setASP_Level_ID(this.p_ASP_Level_ID);
                aspForm.setAD_Form_ID(form.getAD_Form_ID());
                aspForm.setASP_Status(this.p_ASP_Status);
                if (aspForm.save()) {
                    ++this.noForms;
                }
            }
        } else if (menu.getAction().equals("S")) {
            MBrowse browse = new MBrowse(this.getCtx(), menu.getAD_Browse_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Browse WHERE ASP_Level_ID = ? AND AD_Browse_ID = ?", this.p_ASP_Level_ID, browse.getAD_Browse_ID()) < 1) {
                X_ASP_Browse aspBrowse = new X_ASP_Browse(this.getCtx(), 0, this.get_TrxName());
                aspBrowse.setASP_Level_ID(this.p_ASP_Level_ID);
                aspBrowse.setAD_Browse_ID(browse.getAD_Browse_ID());
                aspBrowse.setASP_Status(this.p_ASP_Status);
                if (aspBrowse.save()) {
                    ++this.noBrowses;
                }
            }
        } else if (menu.getAction().equals("T")) {
            MTask task = new MTask(this.getCtx(), menu.getAD_Task_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Task WHERE ASP_Level_ID = ? AND AD_Task_ID = ?", this.p_ASP_Level_ID, task.getAD_Task_ID()) < 1) {
                X_ASP_Task aspTask = new X_ASP_Task(this.getCtx(), 0, this.get_TrxName());
                aspTask.setASP_Level_ID(this.p_ASP_Level_ID);
                aspTask.setAD_Task_ID(task.getAD_Task_ID());
                aspTask.setASP_Status(this.p_ASP_Status);
                if (aspTask.save()) {
                    ++this.noTasks;
                }
            }
        } else if (menu.getAction().equals("F")) {
            this.generateWorkflow(menu.getAD_Workflow_ID());
        }
    }

    private void generateProcess(int p_AD_Process_ID) {
        MProcess process = new MProcess(this.getCtx(), p_AD_Process_ID, this.get_TrxName());
        int asp_process_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Process_ID FROM ASP_Process WHERE ASP_Level_ID = ? AND AD_Process_ID = ?", this.p_ASP_Level_ID, process.getAD_Process_ID());
        X_ASP_Process aspProcess = null;
        if (asp_process_id < 1) {
            aspProcess = new X_ASP_Process(this.getCtx(), 0, this.get_TrxName());
            aspProcess.setASP_Level_ID(this.p_ASP_Level_ID);
            aspProcess.setAD_Process_ID(process.getAD_Process_ID());
            aspProcess.setASP_Status(this.p_ASP_Status);
            if (aspProcess.save()) {
                ++this.noProcesses;
                asp_process_id = aspProcess.getASP_Process_ID();
            }
        } else {
            aspProcess = new X_ASP_Process(this.getCtx(), asp_process_id, this.get_TrxName());
        }
        for (MProcessPara processpara : process.getParameters()) {
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Process_Para WHERE ASP_Process_ID = ? AND AD_Process_Para_ID = ?", asp_process_id, processpara.getAD_Process_Para_ID()) >= 1) continue;
            X_ASP_Process_Para aspProcess_Para = new X_ASP_Process_Para(this.getCtx(), 0, this.get_TrxName());
            aspProcess_Para.setASP_Process_ID(asp_process_id);
            aspProcess_Para.setAD_Process_Para_ID(processpara.getAD_Process_Para_ID());
            aspProcess_Para.setASP_Status(this.p_ASP_Status);
            if (!aspProcess_Para.save()) continue;
            ++this.noParameters;
        }
        if (process.getAD_Workflow_ID() > 0) {
            this.generateWorkflow(process.getAD_Workflow_ID());
        }
    }

    private void generateWorkflow(int p_AD_Workflow_ID) {
        MWorkflow workflow = new MWorkflow(this.getCtx(), p_AD_Workflow_ID, this.get_TrxName());
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Workflow WHERE ASP_Level_ID = ? AND AD_Workflow_ID = ?", this.p_ASP_Level_ID, workflow.getAD_Workflow_ID()) < 1) {
            X_ASP_Workflow aspWorkflow = new X_ASP_Workflow(this.getCtx(), 0, this.get_TrxName());
            aspWorkflow.setASP_Level_ID(this.p_ASP_Level_ID);
            aspWorkflow.setAD_Workflow_ID(workflow.getAD_Workflow_ID());
            aspWorkflow.setASP_Status(this.p_ASP_Status);
            if (aspWorkflow.save()) {
                ++this.noWorkflows;
            }
        }
    }
}

