/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.math.BigDecimal;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String elementValue = element.getElementValue();
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        this.log.info("entitytype " + atts.getValue("EntityType"));
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.getElementValue().equals("workflow") && element.parent.defer) {
            element.unresolved = "Parent element mark as defer: " + atts.getValue("ADWorkflowNameID");
            element.defer = true;
            return;
        }
        int workflowId = 0;
        String workflowName = atts.getValue("ADWorkflowNameID");
        if (element.parent != null && element.parent.getElementValue().equals("workflow") && element.parent.recordId > 0) {
            workflowId = element.parent.recordId;
        } else {
            workflowId = this.get_IDWithColumn(ctx, "AD_Workflow", "name", workflowName);
            if (workflowId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Workflow: " + workflowName;
                return;
            }
            if (element.parent != null && element.parent.getElementValue().equals("workflow")) {
                element.parent.recordId = workflowId;
            }
        }
        String workflowNodeName = atts.getValue("Name").trim();
        StringBuffer sqlB = new StringBuffer("SELECT ad_wf_node_id FROM AD_WF_Node WHERE AD_Workflow_ID=? and Name =?");
        int id = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), workflowId, workflowNodeName);
        X_AD_WF_Node m_WFNode = new X_AD_WF_Node(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_WF_Node_ID") != null && Integer.parseInt(atts.getValue("AD_WF_Node_ID")) <= 999999) {
            m_WFNode.setAD_WF_Node_ID(Integer.parseInt(atts.getValue("AD_WF_Node_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_WF_Node", m_WFNode);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_WFNode.setValue(atts.getValue("Value"));
        m_WFNode.setName(workflowNodeName);
        m_WFNode.setAD_Workflow_ID(workflowId);
        String name = atts.getValue("ADProcessNameID");
        if (name != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_Process", "Name", name);
            if (id <= 0) {
                element.defer = true;
                element.unresolved = "AD_Process: " + name;
                return;
            }
            m_WFNode.setAD_Process_ID(id);
        }
        if ((name = atts.getValue("ADFormNameID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_Form", "Name", name);
            if (id <= 0) {
                element.defer = true;
                element.unresolved = "AD_Form: " + name;
                return;
            }
            m_WFNode.setAD_Form_ID(id);
        }
        if ((name = atts.getValue("ADWorkflowResponsibleNameID")) != null && name.trim().length() > 0 && (id = this.get_IDWithColumn(ctx, "AD_WF_Responsible", "Name", name)) > 0) {
            m_WFNode.setAD_WF_Responsible_ID(id);
        }
        if ((name = atts.getValue("ADWindowNameID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_Window", "Name", name);
            if (id <= 0) {
                element.defer = true;
                element.unresolved = "AD_Window: " + name;
                return;
            }
            m_WFNode.setAD_Window_ID(id);
        }
        if ((name = atts.getValue("ADImageNameID")) != null && name.trim().length() > 0 && (id = this.get_IDWithColumn(ctx, "AD_Image", "Name", name)) > 0) {
            m_WFNode.setAD_Image_ID(id);
        }
        if ((name = atts.getValue("ADWorkflowBlockNameID")) != null && name.trim().length() > 0 && (id = this.get_IDWithColumn(ctx, "AD_WF_Block", "Name", name)) > 0) {
            m_WFNode.setAD_WF_Block_ID(id);
        }
        String columnName = atts.getValue("ADColumnNameID");
        int tableId = DB.getSQLValue(this.getTrxName(ctx), "SELECT AD_Table_ID FROM AD_Workflow WHERE AD_Workflow_ID=?", workflowId);
        this.get_IDWithColumn(ctx, "AD_Workflow", "AD_Table_ID", workflowId);
        int columnId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", columnName, "AD_Table", tableId);
        if (columnId <= 0 && tableId > 0 && columnName != null && columnName.length() > 0) {
            element.unresolved = "AD_Column=" + columnName;
            element.defer = true;
            return;
        }
        if (columnId > 0) {
            m_WFNode.setAD_Column_ID(columnId);
        }
        m_WFNode.setValue(atts.getValue("Value"));
        m_WFNode.setEntityType(atts.getValue("EntityType"));
        m_WFNode.setAction(this.getStringValue(atts, "Action"));
        m_WFNode.setDocAction(this.getStringValue(atts, "DocAction"));
        m_WFNode.setDescription(this.getStringValue(atts, "Description"));
        m_WFNode.setJoinElement(atts.getValue("JoinElement"));
        m_WFNode.setSplitElement(atts.getValue("SplitElement"));
        if (this.getStringValue(atts, "XPosition") != null) {
            m_WFNode.setXPosition(Integer.valueOf(atts.getValue("XPosition")));
        }
        if (this.getStringValue(atts, "YPosition") != null) {
            m_WFNode.setYPosition(Integer.valueOf(atts.getValue("YPosition")));
        }
        m_WFNode.setWaitingTime(Integer.valueOf(atts.getValue("WaitingTime")));
        if (this.getStringValue(atts, "WaitTime") != null) {
            m_WFNode.setWaitTime(Integer.valueOf(atts.getValue("WaitTime")));
        }
        m_WFNode.setWorkingTime(Integer.valueOf(atts.getValue("WorkingTime")));
        if (this.getStringValue(atts, "Cost") != null) {
            m_WFNode.setCost(new BigDecimal(atts.getValue("Cost")));
        }
        if (this.getStringValue(atts, "Duration") != null) {
            m_WFNode.setDuration(Integer.valueOf(atts.getValue("Duration")));
        }
        if (this.getStringValue(atts, "Priority") != null) {
            m_WFNode.setPriority(Integer.valueOf(atts.getValue("Priority")));
        }
        m_WFNode.setStartMode(this.getStringValue(atts, "StartMode"));
        m_WFNode.setSubflowExecution(this.getStringValue(atts, "SubflowExecution"));
        m_WFNode.setIsCentrallyMaintained(Boolean.valueOf(atts.getValue("IsCentrallyMaintained")));
        if (this.getStringValue(atts, "DynPriorityChange") != null) {
            m_WFNode.setDynPriorityChange(new BigDecimal(atts.getValue("DynPriorityChange")));
        }
        m_WFNode.setDynPriorityUnit(this.getStringValue(atts, "DynPriorityUnit"));
        m_WFNode.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_WFNode.setValue(atts.getValue("Value"));
        this.log.info("about to execute m_WFNode.save");
        if (m_WFNode.save(this.getTrxName(ctx))) {
            this.log.info("m_WFNode save success");
            this.record_log(ctx, 1, m_WFNode.getName(), "WFNode", m_WFNode.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_Node", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_Node"));
            return;
        }
        this.log.info("m_WFNode save failure");
        this.record_log(ctx, 0, m_WFNode.getName(), "WFNode", m_WFNode.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_Node", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_Node"));
        throw new POSaveFailedException("WorkflowNode");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_WF_Node_ID = Env.getContextAsInt(ctx, "AD_WF_Node_ID");
        AttributesImpl atts = new AttributesImpl();
        X_AD_WF_Node m_WF_Node = new X_AD_WF_Node(ctx, AD_WF_Node_ID, this.getTrxName(ctx));
        this.createWorkflowNodeBinding(atts, m_WF_Node);
        document.startElement("", "", "workflowNode", atts);
        document.endElement("", "", "workflowNode");
    }

    private AttributesImpl createWorkflowNodeBinding(AttributesImpl atts, X_AD_WF_Node m_WF_Node) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_WF_Node.getAD_WF_Node_ID() <= 999999) {
            atts.addAttribute("", "", "AD_WF_Node_ID", "CDATA", Integer.toString(m_WF_Node.getAD_WF_Node_ID()));
        }
        atts.addAttribute("", "", "Value", "CDATA", m_WF_Node.getValue() != null ? m_WF_Node.getValue() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_WF_Node.getName() != null ? m_WF_Node.getName() : "");
        if (m_WF_Node.getAD_Workflow_ID() > 0) {
            sql = "SELECT Name FROM AD_Workflow WHERE AD_Workflow_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Workflow_ID());
            atts.addAttribute("", "", "ADWorkflowNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADWorkflowNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Window_ID() > 0) {
            sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Window_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADWindowNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADWindowNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADWindowNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Task_ID() > 0) {
            sql = "SELECT Name FROM AD_Task WHERE AD_Task_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Task_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADTaskNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADTaskNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADTaskNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Process_ID() > 0) {
            sql = "SELECT Name FROM AD_Process WHERE AD_Process_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Process_ID());
            atts.addAttribute("", "", "ADProcessNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADProcessNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Form_ID() > 0) {
            sql = "SELECT Name FROM AD_Form WHERE AD_Form_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Form_ID());
            atts.addAttribute("", "", "ADFormNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADFormNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Browse_ID() > 0) {
            sql = "SELECT Name FROM AD_Browse WHERE AD_Browse_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Browse_ID());
            atts.addAttribute("", "", "ADBrowseNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADBrowseNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_WF_Block_ID() > 0) {
            sql = "SELECT Name FROM AD_WF_Block WHERE AD_WF_Block_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_WF_Block_ID());
            atts.addAttribute("", "", "ADWorkflowBlockNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADWorkflowBlockNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_WF_Responsible_ID() > 0) {
            sql = "SELECT Name FROM AD_WF_Responsible WHERE AD_WF_Responsible_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_WF_Responsible_ID());
            atts.addAttribute("", "", "ADWorkflowResponsibleNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADWorkflowResponsibleNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Image_ID() > 0) {
            sql = "SELECT Name FROM AD_Image WHERE AD_Image_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Image_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADImageNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADImageNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADImageNameID", "CDATA", "");
        }
        if (m_WF_Node.getWorkflow_ID() > 0) {
            sql = "SELECT Name FROM AD_Workflow WHERE AD_Workflow_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getWorkflow_ID());
            if (name != null) {
                atts.addAttribute("", "", "WorkflowNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "WorkflowNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "WorkflowNameID", "CDATA", "");
        }
        if (m_WF_Node.getAD_Column_ID() > 0) {
            sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_Node.getAD_Column_ID());
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", name != null ? name : "");
        } else {
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "Value", "CDATA", m_WF_Node.getValue() != null ? m_WF_Node.getValue() : "");
        atts.addAttribute("", "", "Value", "CDATA", m_WF_Node.getValue() != null ? m_WF_Node.getValue() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_WF_Node.isActive() ? "true" : "false");
        atts.addAttribute("", "", "Description", "CDATA", m_WF_Node.getDescription() != null ? m_WF_Node.getDescription() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_WF_Node.getHelp() != null ? m_WF_Node.getHelp() : "");
        atts.addAttribute("", "", "isCentrallyMaintained", "CDATA", m_WF_Node.isCentrallyMaintained() ? "true" : "false");
        atts.addAttribute("", "", "Action", "CDATA", m_WF_Node.getAction() != null ? m_WF_Node.getAction() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_WF_Node.getEntityType() != null ? m_WF_Node.getEntityType() : "");
        atts.addAttribute("", "", "XPosition", "CDATA", "" + m_WF_Node.getXPosition());
        atts.addAttribute("", "", "YPosition", "CDATA", "" + m_WF_Node.getYPosition());
        atts.addAttribute("", "", "SubflowExecution", "CDATA", m_WF_Node.getSubflowExecution() != null ? m_WF_Node.getSubflowExecution() : "");
        atts.addAttribute("", "", "StartMode", "CDATA", m_WF_Node.getStartMode() != null ? m_WF_Node.getStartMode() : "");
        atts.addAttribute("", "", "Priority", "CDATA", "" + m_WF_Node.getPriority());
        atts.addAttribute("", "", "Duration", "CDATA", "" + m_WF_Node.getDuration());
        atts.addAttribute("", "", "Cost", "CDATA", "" + m_WF_Node.getCost());
        atts.addAttribute("", "", "WorkingTime", "CDATA", "" + m_WF_Node.getWorkingTime());
        atts.addAttribute("", "", "WaitingTime", "CDATA", "" + m_WF_Node.getWaitingTime());
        atts.addAttribute("", "", "JoinElement", "CDATA", m_WF_Node.getJoinElement() != null ? m_WF_Node.getJoinElement() : "");
        atts.addAttribute("", "", "SplitElement", "CDATA", m_WF_Node.getSplitElement() != null ? m_WF_Node.getSplitElement() : "");
        atts.addAttribute("", "", "WaitTime", "CDATA", "" + m_WF_Node.getWaitTime());
        atts.addAttribute("", "", "AttributeName", "CDATA", m_WF_Node.getAttributeName() != null ? m_WF_Node.getAttributeName() : "");
        atts.addAttribute("", "", "AttributeValue", "CDATA", m_WF_Node.getAttributeValue() != null ? m_WF_Node.getAttributeValue() : "");
        atts.addAttribute("", "", "DocAction", "CDATA", m_WF_Node.getDocAction() != null ? m_WF_Node.getDocAction() : "");
        atts.addAttribute("", "", "DynPriorityUnit", "CDATA", m_WF_Node.getDynPriorityUnit() != null ? m_WF_Node.getDynPriorityUnit() : "");
        atts.addAttribute("", "", "DynPriorityChange", "CDATA", "" + m_WF_Node.getDynPriorityChange());
        return atts;
    }
}

