/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.model.MView;
import org.adempiere.model.MViewDefinition;
import org.adempiere.model.X_AD_View;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.ViewDefinitionElementHandler;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ViewElementHandler
extends AbstractElementHandler {
    private ViewDefinitionElementHandler viewDefinitionHandler = new ViewDefinitionElementHandler();
    private List<Integer> views = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        int id = this.get_ID(ctx, "AD_View", name);
        if (id > 0 && this.views.contains(id)) {
            return;
        }
        MView m_View = new MView(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_View_ID") != null && Integer.parseInt(atts.getValue("AD_View_ID")) <= 999999) {
            m_View.setAD_View_ID(Integer.parseInt(atts.getValue("AD_View_ID")));
        }
        String Object_Status = null;
        int AD_Backup_ID = -1;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_View", m_View);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_View.setValue(atts.getValue("Value"));
        m_View.setName(atts.getValue("Name"));
        m_View.setDescription(this.getStringValue(atts, "Description"));
        m_View.setHelp(this.getStringValue(atts, "Help"));
        m_View.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_View.setEntityType(atts.getValue("EntityType"));
        if (m_View.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_View.getName(), "View", m_View.get_ID(), AD_Backup_ID, Object_Status, "AD_View", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_View"));
            element.recordId = m_View.getAD_View_ID();
            this.views.add(m_View.getAD_View_ID());
            return;
        }
        this.record_log(ctx, 0, m_View.getName(), "View", m_View.get_ID(), AD_Backup_ID, Object_Status, "AD_View", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_View"));
        throw new POSaveFailedException("View");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_View_ID = Env.getContextAsInt(ctx, "AD_View_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        X_AD_View m_View = new X_AD_View(ctx, AD_View_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createViewBinding(atts, m_View);
        document.startElement("", "", "view", atts);
        StringBuilder whereClause = new StringBuilder("AD_View_ID").append("=?");
        List viewDefinitions = new Query(ctx, "AD_View_Definition", whereClause.toString(), this.getTrxName(ctx)).setParameters(m_View.getAD_View_ID()).setOrderBy("SeqNo,AD_View_Definition_ID").list();
        for (MViewDefinition vd : viewDefinitions) {
            this.createViewDefinition(ctx, document, vd.getAD_View_Definition_ID());
        }
        document.endElement("", "", "view");
    }

    private void createViewDefinition(Properties ctx, TransformerHandler document, int AD_View_Definition_ID) throws SAXException {
        Env.setContext(ctx, "AD_View_Definition_ID", AD_View_Definition_ID);
        this.viewDefinitionHandler.create(ctx, document);
        ctx.remove("AD_View_Definition_ID");
    }

    private AttributesImpl createViewBinding(AttributesImpl atts, X_AD_View m_View) {
        atts.clear();
        if (m_View.getAD_View_ID() <= 999999) {
            atts.addAttribute("", "", "AD_View_ID", "CDATA", Integer.toString(m_View.getAD_View_ID()));
        }
        String sql = "SELECT Name FROM AD_View WHERE AD_View_ID=?";
        String name = DB.getSQLValueString(null, sql, m_View.getAD_View_ID());
        atts.addAttribute("", "", "ADViewNameID", "CDATA", name);
        atts.addAttribute("", "", "Value", "CDATA", m_View.getValue() != null ? m_View.getValue() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_View.getName() != null ? m_View.getName() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_View.getDescription() != null ? m_View.getDescription() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_View.getHelp() != null ? m_View.getHelp() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_View.getEntityType() != null ? m_View.getEntityType() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_View.isActive() ? "true" : "false");
        return atts;
    }
}

