/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MColumn;
import org.compiere.model.MRefTable;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceTableElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        int keyId;
        int tableId;
        String elementValue = element.getElementValue();
        this.log.info(elementValue);
        Attributes atts = element.attributes;
        String entitytype = atts.getValue("EntityType");
        String name = atts.getValue("ADRefenceNameID");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        int AD_Reference_ID = 0;
        if (element.parent != null && element.parent.getElementValue().equals("reference") && element.parent.recordId > 0) {
            AD_Reference_ID = element.parent.recordId;
        } else {
            StringBuffer sqlB = new StringBuffer("SELECT AD_Reference_ID FROM AD_Reference WHERE Name= ?");
            AD_Reference_ID = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), name);
        }
        if (AD_Reference_ID <= 0 && atts.getValue("AD_Reference_ID") != null && Integer.parseInt(atts.getValue("AD_Reference_ID")) <= 999999) {
            AD_Reference_ID = Integer.parseInt(atts.getValue("AD_Reference_ID"));
        }
        if ((tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", atts.getValue("ADTableNameID"))) == 0) {
            MTable m_Table = new MTable(ctx, 0, this.getTrxName(ctx));
            m_Table.setAccessLevel("3");
            m_Table.setName(atts.getValue("ADTableNameID"));
            m_Table.setTableName(atts.getValue("ADTableNameID"));
            if (m_Table.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            } else {
                this.record_log(ctx, 0, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            }
            tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", atts.getValue("ADTableNameID"));
        }
        if ((keyId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name = atts.getValue("Key"), "AD_Table", tableId)) == 0) {
            throw new AdempiereException("@AD_Column_ID@:" + name + "@NotFound@");
        }
        int displayId = 0;
        name = atts.getValue("ADDisplay");
        displayId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name, "AD_Table", tableId);
        String isDisplayIdentifier = atts.getValue("IsDisplayIdentifier");
        String isAlert = atts.getValue("IsAlert");
        String entityType = atts.getValue("EntityType");
        String isValueDisplayed = atts.getValue("IsValueDisplayed");
        String OrderByClause = "";
        String WhereClause = "";
        String displaySQL = "";
        if (DB.isOracle()) {
            OrderByClause = atts.getValue("OrderByClause");
            WhereClause = atts.getValue("WhereClause");
            displaySQL = atts.getValue("DisplaySQL");
        } else if (DB.isPostgreSQL()) {
            OrderByClause = atts.getValue("OrderByClause").replaceAll("''", "'");
            WhereClause = atts.getValue("WhereClause").replaceAll("''", "'");
            displaySQL = atts.getValue("DisplaySQL").replaceAll("''", "'");
        }
        MRefTable refTable = (MRefTable)new Query(ctx, "AD_Ref_Table", "AD_Reference_ID=?", this.getTrxName(ctx)).setParameters(AD_Reference_ID).firstOnly();
        if (refTable != null) {
            refTable.setAD_Table_ID(tableId);
            refTable.setAD_Display(displayId);
            refTable.setAD_Key(keyId);
            refTable.setIsValueDisplayed(isValueDisplayed.equals("Y"));
            refTable.setIsDisplayIdentifier(isDisplayIdentifier.equals("Y"));
            refTable.setIsAlert(isAlert.equals("Y"));
            refTable.setDisplaySQL(displaySQL);
            refTable.setOrderByClause(OrderByClause);
            refTable.setEntityType(entityType);
            refTable.setWhereClause(WhereClause);
            refTable.saveEx();
            if (refTable != null) {
                this.record_log(ctx, 1, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "Update", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
                return;
            }
            this.record_log(ctx, 0, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "Update", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
            throw new POSaveFailedException("ReferenceTable");
        }
        refTable = new MRefTable(ctx, 0, this.getTrxName(ctx));
        refTable.setAD_Reference_ID(AD_Reference_ID);
        refTable.setAD_Table_ID(tableId);
        refTable.setAD_Display(displayId);
        refTable.setAD_Key(keyId);
        refTable.setIsValueDisplayed(isValueDisplayed.equals("Y"));
        refTable.setIsDisplayIdentifier(isDisplayIdentifier.equals("Y"));
        refTable.setIsAlert(isAlert.equals("Y"));
        refTable.setDisplaySQL(displaySQL);
        refTable.setOrderByClause(OrderByClause);
        refTable.setEntityType(entityType);
        refTable.setWhereClause(WhereClause);
        if (refTable.save()) {
            this.record_log(ctx, 1, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "New", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
            return;
        }
        this.record_log(ctx, 0, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "New", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
        throw new POSaveFailedException("ReferenceTable");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int Reference_id = Env.getContextAsInt(ctx, "AD_Reference_ID");
        AttributesImpl atts = new AttributesImpl();
        this.createReferenceTableBinding(ctx, atts, Reference_id);
        document.startElement("", "", "referencetable", atts);
        document.endElement("", "", "referencetable");
    }

    private AttributesImpl createReferenceTableBinding(Properties ctx, AttributesImpl atts, int reference_ID) {
        MRefTable refTable;
        X_AD_Reference reference;
        atts.clear();
        if (reference_ID <= 999999) {
            atts.addAttribute("", "", "AD_Reference_ID", "CDATA", Integer.toString(reference_ID));
        }
        if ("T".equals((reference = new X_AD_Reference(ctx, reference_ID, this.getTrxName(ctx))).getValidationType()) && (refTable = new MRefTable(ctx, reference_ID, this.getTrxName(ctx))) != null) {
            atts.addAttribute("", "", "ADRefenceNameID", "CDATA", reference.getName());
            if (refTable.getAD_Table_ID() > 0) {
                atts.addAttribute("", "", "ADTableNameID", "CDATA", refTable.getAD_Table().getTableName());
            } else {
                atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
            }
            if (refTable.getAD_Display() > 0) {
                atts.addAttribute("", "", "ADDisplay", "CDATA", MColumn.get(ctx, refTable.getAD_Display()).getColumnName());
            } else {
                atts.addAttribute("", "", "ADDisplay", "CDATA", "");
            }
            if (refTable.getAD_Key() > 0) {
                atts.addAttribute("", "", "Key", "CDATA", MColumn.get(ctx, refTable.getAD_Key()).getColumnName());
            } else {
                atts.addAttribute("", "", "Key", "CDATA", "");
            }
            if (refTable.getAD_Window_ID() > 0) {
                atts.addAttribute("", "", "ADWindowNameID", "CDATA", refTable.getAD_Window().getName());
            } else {
                atts.addAttribute("", "", "ADWindowNameID", "CDATA", "");
            }
            atts.addAttribute("", "", "EntityType", "CDATA", refTable.getEntityType() != null ? refTable.getEntityType() : "");
            atts.addAttribute("", "", "IsValueDisplayed", "CDATA", refTable.isValueDisplayed() ? "Y" : "N");
            atts.addAttribute("", "", "IsDisplayIdentifier", "CDATA", refTable.isDisplayIdentifier() ? "Y" : "N");
            atts.addAttribute("", "", "IsAlert", "CDATA", refTable.isAlert() ? "Y" : "N");
            atts.addAttribute("", "", "DisplaySQL", "CDATA", refTable.getDisplaySQL() != null ? refTable.getDisplaySQL() : "");
            atts.addAttribute("", "", "OrderByClause", "CDATA", refTable.getOrderByClause() != null ? refTable.getOrderByClause() : "");
            atts.addAttribute("", "", "isActive", "CDATA", refTable.isActive() ? "Y" : "N");
            atts.addAttribute("", "", "WhereClause", "CDATA", refTable.getWhereClause() != null ? refTable.getWhereClause() : "");
        }
        return atts;
    }
}

