/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MForm;
import org.compiere.model.X_AD_Form;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormElementHandler
extends AbstractElementHandler {
    private List<Integer> forms = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("ADFormNameID"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("ADFormNameID");
        int id = this.get_ID(ctx, "AD_Form", name);
        MForm m_Form = new MForm(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_Form_ID") != null && Integer.parseInt(atts.getValue("AD_Form_ID")) <= 999999) {
            m_Form.setAD_Form_ID(Integer.parseInt(atts.getValue("AD_Form_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Form", m_Form);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Form.setClassname(atts.getValue("Classname"));
        m_Form.setIsBetaFunctionality(Boolean.valueOf(atts.getValue("isBetaFunctionality")));
        m_Form.setAccessLevel(atts.getValue("AccessLevel"));
        m_Form.setDescription(this.getStringValue(atts, "Description"));
        m_Form.setEntityType(atts.getValue("EntityType"));
        m_Form.setHelp(this.getStringValue(atts, "Help"));
        m_Form.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Form.setName(atts.getValue("Name"));
        if (m_Form.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Form.getName(), "Form", m_Form.get_ID(), AD_Backup_ID, Object_Status, "AD_Form", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Form"));
            return;
        }
        this.record_log(ctx, 0, m_Form.getName(), "Form", m_Form.get_ID(), AD_Backup_ID, Object_Status, "AD_Form", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Form"));
        throw new POSaveFailedException("Failed to save form definition");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Form_ID = Env.getContextAsInt(ctx, "AD_Form_ID");
        if (this.forms.contains(AD_Form_ID)) {
            return;
        }
        this.forms.add(AD_Form_ID);
        X_AD_Form m_Form = new X_AD_Form(ctx, AD_Form_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createFormBinding(atts, m_Form);
        document.startElement("", "", "form", atts);
        document.endElement("", "", "form");
    }

    private AttributesImpl createFormBinding(AttributesImpl atts, X_AD_Form m_Form) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Form.getAD_Form_ID() > 0) {
            sql = "SELECT Name FROM AD_Form WHERE AD_Form_ID=?";
            name = DB.getSQLValueString(null, sql, m_Form.getAD_Form_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADFormNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADFormNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADFormNameID", "CDATA", "");
        }
        if (m_Form.getAD_Form_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Form_ID", "CDATA", Integer.toString(m_Form.getAD_Form_ID()));
        }
        atts.addAttribute("", "", "Classname", "CDATA", m_Form.getClassname() != null ? m_Form.getClassname() : "");
        atts.addAttribute("", "", "isBetaFunctionality", "CDATA", m_Form.isBetaFunctionality() ? "true" : "false");
        atts.addAttribute("", "", "AccessLevel", "CDATA", m_Form.getAccessLevel() != null ? m_Form.getAccessLevel() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_Form.getDescription() != null ? m_Form.getDescription() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Form.isActive() ? "true" : "false");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Form.getEntityType() != null ? m_Form.getEntityType() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Form.getHelp() != null ? m_Form.getHelp() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Form.getName() != null ? m_Form.getName() : "");
        return atts;
    }
}

