/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.X_AD_Browse;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.BrowseFieldElementHandler;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BrowseElementHandler
extends AbstractElementHandler {
    private List<Integer> browses = new ArrayList<Integer>();
    private BrowseFieldElementHandler browseFieldHandler = new BrowseFieldElementHandler();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        int id = this.get_ID(ctx, "AD_Browse", name);
        if (id > 0 && this.browses.contains(id)) {
            return;
        }
        MBrowse m_Browse = new MBrowse(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Browse_ID") != null && Integer.parseInt(atts.getValue("AD_Browse_ID")) <= 999999) {
            m_Browse.setAD_Browse_ID(Integer.parseInt(atts.getValue("AD_Browse_ID")));
        }
        String Object_Status = null;
        int AD_Backup_ID = -1;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Browse", m_Browse);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        if (this.getStringValue(atts, "ADViewNameID") != null) {
            name = atts.getValue("ADViewNameID");
            id = this.get_IDWithColumn(ctx, "AD_View", "Name", name);
            if (id <= 0) {
                element.defer = true;
                element.unresolved = "AD_View: " + name;
                return;
            }
            m_Browse.setAD_View_ID(id);
        }
        if (this.getStringValue(atts, "ADProcessNameID") != null && (name = atts.getValue("ADProcessNameID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_Process", "Name", name);
            if (id <= 0) {
                element.defer = true;
                element.unresolved = "AD_Process: " + name;
                return;
            }
            m_Browse.setAD_Process_ID(id);
        }
        m_Browse.setValue(atts.getValue("Value"));
        m_Browse.setName(atts.getValue("Name"));
        m_Browse.setDescription(this.getStringValue(atts, "Description"));
        m_Browse.setHelp(this.getStringValue(atts, "Help"));
        m_Browse.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Browse.setEntityType(atts.getValue("EntityType"));
        m_Browse.setWhereClause(atts.getValue("WhereClause"));
        m_Browse.setAccessLevel(atts.getValue("AccessLevel"));
        if (m_Browse.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Browse.getName(), "Browse", m_Browse.get_ID(), AD_Backup_ID, Object_Status, "AD_Browse", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Browse"));
            element.recordId = m_Browse.getAD_Browse_ID();
            this.browses.add(m_Browse.getAD_Browse_ID());
            return;
        }
        this.record_log(ctx, 0, m_Browse.getName(), "Browse", m_Browse.get_ID(), AD_Backup_ID, Object_Status, "AD_Browse", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Browse"));
        throw new POSaveFailedException("Browse");
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Browse_ID = Env.getContextAsInt(ctx, "AD_Browse_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        MBrowse m_Browse = new MBrowse(ctx, AD_Browse_ID, null);
        AttributesImpl atts = new AttributesImpl();
        packOut.createView(m_Browse.getAD_View_ID(), document);
        packOut.createProcess(m_Browse.getAD_Process_ID(), document);
        this.createBrowseBinding(atts, m_Browse);
        document.startElement("", "", "browse", atts);
        StringBuilder whereClause = new StringBuilder("AD_Browse_ID").append("=?");
        List browseFields = new Query(ctx, "AD_Browse_Field", whereClause.toString(), this.getTrxName(ctx)).setParameters(m_Browse.getAD_Browse_ID()).list();
        for (MBrowseField bf : browseFields) {
            this.createBrowseField(ctx, document, bf.getAD_Browse_Field_ID());
        }
        document.endElement("", "", "browse");
    }

    private void createBrowseField(Properties ctx, TransformerHandler document, int AD_Browse_Field_ID) throws SAXException {
        Env.setContext(ctx, "AD_Browse_Field_ID", AD_Browse_Field_ID);
        this.browseFieldHandler.create(ctx, document);
        ctx.remove("AD_Browse_Field_ID");
    }

    private AttributesImpl createBrowseBinding(AttributesImpl atts, X_AD_Browse m_Browse) {
        atts.clear();
        if (m_Browse.getAD_Browse_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Browse_ID", "CDATA", Integer.toString(m_Browse.getAD_Browse_ID()));
        }
        String sql = "SELECT Name FROM AD_Browse WHERE AD_Browse_ID=?";
        String name = DB.getSQLValueString(null, sql, m_Browse.getAD_Browse_ID());
        atts.addAttribute("", "", "ADBrowseNameID", "CDATA", name);
        atts.addAttribute("", "", "Value", "CDATA", m_Browse.getValue() != null ? m_Browse.getValue() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Browse.getName() != null ? m_Browse.getName() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_Browse.getDescription() != null ? m_Browse.getDescription() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Browse.getHelp() != null ? m_Browse.getHelp() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Browse.getEntityType() != null ? m_Browse.getEntityType() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Browse.isActive() ? "true" : "false");
        atts.addAttribute("", "", "WhereClause", "CDATA", m_Browse.getWhereClause() != null ? m_Browse.getWhereClause() : "");
        atts.addAttribute("", "", "isBetaFunctionality", "CDATA", m_Browse.isBetaFunctionality() ? "true" : "false");
        atts.addAttribute("", "", "AccessLevel", "CDATA", m_Browse.getAccessLevel() != null ? m_Browse.getAccessLevel() : "");
        if (m_Browse.getAD_Process_ID() > 0) {
            sql = "SELECT Name FROM AD_Process WHERE AD_Process_ID=?";
            name = DB.getSQLValueString(null, sql, m_Browse.getAD_Process_ID());
            atts.addAttribute("", "", "ADProcessNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADProcessNameID", "CDATA", "");
        }
        if (m_Browse.getAD_View_ID() > 0) {
            sql = "SELECT Name FROM AD_View WHERE AD_View_ID=?";
            name = DB.getSQLValueString(null, sql, m_Browse.getAD_View_ID());
            atts.addAttribute("", "", "ADViewNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADViewNameID", "CDATA", "");
        }
        return atts;
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }
}

