/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.MViewDefinition;
import org.adempiere.model.X_AD_View;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MView
extends X_AD_View {
    private static final long serialVersionUID = -4624429043533053271L;
    private static CLogger s_log = CLogger.getCLogger(MView.class);
    private List<MViewColumn> m_ViewColumn = null;

    public MView(Properties ctx, int AD_SmartView_ID, String trxName) {
        super(ctx, AD_SmartView_ID, trxName);
        if (AD_SmartView_ID == 0) {
            // empty if block
        }
    }

    public MView(Properties ctx, int AD_SmartView_ID) {
        this(ctx, AD_SmartView_ID, null);
    }

    public MView(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutBound[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public List<MViewDefinition> getViewDefinitions() {
        String whereClause = "AD_View_ID= ?";
        return new Query(this.getCtx(), "AD_View_Definition", "AD_View_ID= ?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("SeqNo").setOnlyActiveRecords(true).list();
    }

    public String getJoinsTables() {
        String whereClause = "AD_View_ID= ?";
        Iterator joins = new Query(this.getCtx(), "AD_View_Definition", "AD_View_ID= ?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("SeqNo").setOnlyActiveRecords(true).iterate();
        StringBuffer tables = new StringBuffer("");
        while (joins.hasNext()) {
            MViewDefinition join = (MViewDefinition)joins.next();
            tables.append(join.getAD_Table().getTableName());
            if (!joins.hasNext()) continue;
            tables.append(",");
        }
        return tables.toString();
    }

    public String getFromClause() {
        String fromClause = " ";
        String joinClause = " ";
        for (MViewDefinition join : this.getViewDefinitions()) {
            if (join.getJoinClause() == null) {
                fromClause = fromClause + join.getAD_Table().getTableName() + " " + join.getTableAlias();
                continue;
            }
            if (join.getJoinClause().length() <= 0) continue;
            joinClause = joinClause + join.getJoinClause() + " ";
        }
        return fromClause + joinClause;
    }

    public List<MViewColumn> getViewColumns() {
        if (this.m_ViewColumn != null) {
            return this.m_ViewColumn;
        }
        this.m_ViewColumn = new ArrayList<MViewColumn>();
        MView view = new MView(Env.getCtx(), this.getAD_View_ID(), this.get_TrxName());
        for (MViewDefinition def : view.getViewDefinitions()) {
            String whereClause = "AD_View_Definition_ID=?";
            List columns = new Query(Env.getCtx(), "AD_View_Column", "AD_View_Definition_ID=?", this.get_TrxName()).setParameters(def.get_ID()).setOnlyActiveRecords(true).list();
            for (MViewColumn col : columns) {
                this.m_ViewColumn.add(col);
            }
        }
        return this.m_ViewColumn;
    }

    public MViewDefinition getParentViewDefinition() {
        String whereClause = "AD_View_ID=? AND JoinClause IS NULL";
        MViewDefinition definition = (MViewDefinition)new Query(this.getCtx(), "AD_View_Definition", whereClause, this.get_TrxName()).setParameters(this.getAD_View_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").firstOnly();
        return definition;
    }

    public String getParentEntityName() {
        return MTable.getTableName(this.getCtx(), this.getParentViewDefinition().getAD_Table_ID());
    }

    public String getParentEntityAliasName() {
        return this.getParentViewDefinition().getTableAlias();
    }

    @Override
    protected boolean beforeDelete() {
        DB.executeUpdate("DELETE FROM AD_View_Trl WHERE AD_View_ID=? ", this.getAD_View_ID(), this.get_TrxName());
        return true;
    }

    public static String getSQLFromView(int AD_View_ID, String trxName) {
        StringBuffer sql = new StringBuffer();
        StringBuffer joins = new StringBuffer();
        StringBuffer cols = new StringBuffer();
        String from = "";
        MView view = new MView(Env.getCtx(), AD_View_ID, null);
        sql.append("SELECT ");
        boolean co = false;
        for (MViewDefinition def : view.getViewDefinitions()) {
            List columns = new Query(Env.getCtx(), "AD_View_Column", "AD_View_Definition_ID=?", trxName).setParameters(def.get_ID()).setOnlyActiveRecords(true).list();
            for (MViewColumn col : columns) {
                if (co) {
                    cols.append(",");
                }
                if (col.getColumnSQL() != null && col.getColumnSQL().length() > 0) {
                    cols.append(col.getColumnSQL() + " as " + col.getName());
                    co = true;
                    continue;
                }
                if (col.getColumnName() == null || col.getColumnName().length() <= 0) continue;
                cols.append(def.getTableAlias() + "." + col.getColumnName() + " as " + col.getName());
                co = true;
            }
            MTable table2 = new MTable(Env.getCtx(), def.getAD_Table_ID(), null);
            if (def.getJoinClause() != null && def.getJoinClause().length() > 0) {
                String jc = def.getJoinClause();
                joins.append(" ").append(jc).append(" ");
                continue;
            }
            from = table2.getTableName() + " " + def.getTableAlias();
        }
        sql.append(cols).append(" from ").append(from).append(" ").append(joins);
        return sql.toString();
    }

    public static boolean isValidValue(int AD_View_ID, String ColumnName, Object Value) {
        boolean valid = false;
        String whereClause = "Name = ? and AD_View_Definition_ID IN (SELECT AD_View_Definition_ID FROM AD_View_Definition WHERE AD_View_ID = ?)";
        MViewColumn column = (MViewColumn)new Query(Env.getCtx(), "AD_View_Column", whereClause, null).setParameters(ColumnName, AD_View_ID).first();
        if (column != null) {
            if (column.get_ValueAsBoolean("IsMandatory")) {
                if (Value != null) {
                    valid = true;
                }
            } else {
                valid = true;
            }
        }
        return valid;
    }
}

