/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MView;
import org.adempiere.model.X_AD_Browse;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MBrowse
extends X_AD_Browse {
    private static final long serialVersionUID = -7723306980903810620L;
    private static CLogger s_log = CLogger.getCLogger(MBrowse.class);
    private MView m_view = null;
    private String m_title = null;
    private List<MBrowseField> m_Fields = null;
    private List<MBrowseField> m_DisplayFields = null;
    private List<MBrowseField> m_CriterialFields = null;
    private List<MBrowseField> m_IdentifierFields = null;
    private List<MBrowseField> m_OrderByFields = null;
    private MBrowseField m_fieldKey = null;

    public MBrowse(Properties ctx, int AD_SmartBrowse_ID, String trxName) {
        super(ctx, AD_SmartBrowse_ID, trxName);
        if (AD_SmartBrowse_ID == 0) {
            // empty if block
        }
    }

    public MBrowse(Properties ctx, int AD_SmartBrowse_ID) {
        this(ctx, AD_SmartBrowse_ID, null);
    }

    public MBrowse(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(" MSmartBrowse[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public List<MBrowseField> getCriteriaFields() {
        if (this.m_CriterialFields == null) {
            StringBuilder whereClause = new StringBuilder("AD_Browse_ID");
            whereClause.append("=? AND ").append("IsQueryCriteria").append("=?");
            return new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), "Y").setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        }
        return this.m_CriterialFields;
    }

    public List<MBrowseField> getFields() {
        if (this.m_Fields == null) {
            StringBuilder whereClause = new StringBuilder("AD_Browse_ID").append("=?");
            this.m_Fields = new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        }
        return this.m_Fields;
    }

    public List<MBrowseField> getIdentifierFields() {
        if (this.m_IdentifierFields == null) {
            StringBuilder whereClause = new StringBuilder("AD_Browse_ID");
            whereClause.append("=? AND ").append("IsIdentifier").append("=?");
            this.m_IdentifierFields = new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setParameters(this.getAD_Browse_ID(), true).setOrderBy("SeqNo").list();
        }
        return this.m_IdentifierFields;
    }

    public List<MBrowseField> getDisplayFields() {
        if (this.m_DisplayFields == null) {
            StringBuilder whereClause = new StringBuilder("AD_Browse_ID");
            whereClause.append("=? AND ").append("IsDisplayed").append("=? ");
            this.m_DisplayFields = new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), "Y").setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        }
        return this.m_DisplayFields;
    }

    public List<MBrowseField> getOrderByFields() {
        if (this.m_OrderByFields == null) {
            StringBuilder whereClause = new StringBuilder("AD_Browse_ID");
            whereClause.append("=? AND ").append("IsOrderBy").append("=? AND ").append("IsDisplayed").append("=? ");
            this.m_OrderByFields = new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), true, true).setOnlyActiveRecords(true).setOrderBy("SortNo").list();
        }
        return this.m_OrderByFields;
    }

    public List<MBrowseField> getNotReadOnlyFields() {
        StringBuilder whereClause = new StringBuilder("AD_Browse_ID");
        whereClause.append("=? AND ").append("IsDisplayed").append("=? AND ").append("IsReadOnly").append("=? ");
        return new Query(this.getCtx(), "AD_Browse_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), "Y", "N").setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
    }

    public MBrowseField getField(String name) {
        for (MBrowseField field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public MBrowseField getFieldKey() {
        if (this.m_fieldKey != null) {
            return this.m_fieldKey;
        }
        String whereClause = "AD_Browse_ID=? AND IsKey=? AND Name!=? ";
        this.m_fieldKey = (MBrowseField)new Query(this.getCtx(), "AD_Browse_Field", "AD_Browse_ID=? AND IsKey=? AND Name!=? ", this.get_TrxName()).setParameters(this.getAD_Browse_ID(), "Y", this.getName()).firstOnly();
        return this.m_fieldKey;
    }

    @Override
    public MView getAD_View() {
        if (this.m_view == null) {
            this.m_view = new MView(this.getCtx(), this.getAD_View_ID(), this.get_TrxName());
        }
        return this.m_view;
    }

    @Override
    protected boolean beforeDelete() {
        DB.executeUpdate("DELETE FROM AD_Browse_Access WHERE AD_Browse_ID=? ", this.getAD_Browse_ID(), this.get_TrxName());
        DB.executeUpdate("DELETE FROM AD_Browse_Trl WHERE AD_Browse_ID=? ", this.getAD_Browse_ID(), this.get_TrxName());
        return true;
    }

    public String getTitle() {
        if (this.m_title != null) {
            return this.m_title;
        }
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Browse");
        String sql = "SELECT Name FROM AD_Browse_Trl WHERE AD_Browse_ID=? AND AD_LANGUAGE=?";
        this.m_title = baseLanguage ? this.getName() : DB.getSQLValueString(null, "SELECT Name FROM AD_Browse_Trl WHERE AD_Browse_ID=? AND AD_LANGUAGE=?", this.getAD_Browse_ID(), Env.getAD_Language(Env.getCtx()));
        return this.m_title;
    }
}

