/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class PORelationException
extends AdempiereException {
    private static final CLogger logger = CLogger.getCLogger(PORelationException.class);
    public static final String MSG_ERR_KEY_COLUMNS_2P = "MRelationType_Err_KeyColumns_2P";
    public static final String MSG_ERR_WINDOW_3P = "MRelationType_Err_Window_3P";
    public final String adMsg;
    public final Object[] msgParams;
    private static final long serialVersionUID = -906400765022362887L;

    private PORelationException(String msg, String adMsg, Object ... msgParams) {
        super(msg);
        this.adMsg = adMsg;
        this.msgParams = msgParams;
    }

    public static void throwWrongKeyColumnCount(PO po) {
        logger.fine("Invoked with po " + po);
        Object[] msgParams = new Object[]{po.toString(), po.get_KeyColumns().length};
        String msg = Msg.getMsg(po.getCtx(), MSG_ERR_KEY_COLUMNS_2P, msgParams);
        StringBuffer sb = new StringBuffer(msg);
        for (String keyCol : po.get_KeyColumns()) {
            sb.append("\n");
            sb.append(keyCol);
        }
        throw new PORelationException(sb.toString(), MSG_ERR_KEY_COLUMNS_2P, msgParams);
    }

    public static void throwMissingWindowId(PO po, String referenceName, String tableName, boolean isSOTrx) {
        Object[] msgParams = new Object[]{referenceName, tableName, isSOTrx ? "Y" : "N"};
        String msg = Msg.getMsg(po.getCtx(), MSG_ERR_WINDOW_3P, msgParams);
        throw new PORelationException(msg, MSG_ERR_WINDOW_3P, msgParams);
    }
}

