/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.excel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.adempiere.util.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.Region;
import org.compiere.model.MImage;
import org.compiere.model.ReportTO;
import org.compiere.report.MReportColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SmjXlsReport {
    public CLogger log = CLogger.getCLogger(SmjXlsReport.class);
    private int cols = 0;
    private short endRegion = (short)2;

    public HSSFWorkbook generate(LinkedList<ReportTO> data, String[] generalTitle, String clientName, String clientNIT, String periodName, String currencyName, MReportColumn[] m_columns, String city, Integer logoId) {
        int fila = 0;
        this.cols = m_columns.length + 2;
        this.endRegion = (short)(this.cols - 1);
        try {
            HSSFRow row;
            HSSFWorkbook book = new HSSFWorkbook();
            HSSFSheet sheet = book.createSheet(StringUtils.makePrefix(generalTitle[0]));
            HSSFFont font = book.createFont();
            font.setFontHeightInPoints((short)13);
            font.setFontName("Arial");
            font.setBoldweight((short)700);
            HSSFCellStyle cellStyle = book.createCellStyle();
            cellStyle.setWrapText(true);
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)0);
            cellStyle.setFont(font);
            if (logoId > 0) {
                MImage mimage = MImage.get(Env.getCtx(), logoId);
                byte[] imageData = mimage.getData();
                HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
                HSSFClientAnchor anchor = new HSSFClientAnchor(100, 50, 200, 255, 0, 0, 1, 1);
                anchor.setAnchorType(2);
                int pictureIndex = book.addPicture(imageData, 6);
                patriarch.createPicture(anchor, pictureIndex);
                for (int i = 0; i < 5; ++i) {
                    row = sheet.createRow(fila++);
                }
            }
            row = sheet.createRow(fila++);
            HSSFRichTextString text = new HSSFRichTextString(generalTitle[0]);
            HSSFCell cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            org.apache.poi.hssf.util.Region region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(clientName);
            cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(city);
            cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(clientNIT);
            cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            String pn = "";
            pn = generalTitle[1] != null && generalTitle[1].length() > 0 ? generalTitle[1] + " " + periodName : periodName;
            if (generalTitle[2] != null && generalTitle[2].length() > 0) {
                pn = pn + " " + generalTitle[2];
            }
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(pn);
            cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(currencyName);
            cell = row.createCell((short)0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
            sheet.addMergedRegion((Region)region);
            row = sheet.createRow(fila++);
            this.titleTable(book, sheet, fila++, m_columns);
            this.reportTable(book, data, sheet, fila);
            return book;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void titleTable(HSSFWorkbook book, HSSFSheet sheet, int fila, MReportColumn[] m_columns) {
        short col = 0;
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)13);
        font.setFontName("Arial");
        font.setBoldweight((short)700);
        HSSFCellStyle cellStyle = book.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setAlignment((short)5);
        cellStyle.setVerticalAlignment((short)0);
        cellStyle.setFont(font);
        HSSFRow row = sheet.createRow(fila);
        HSSFRichTextString text = new HSSFRichTextString(Msg.translate(Env.getCtx(), "name").toUpperCase());
        short s = col;
        col = (short)(col + 1);
        HSSFCell cell = row.createCell(s);
        cell.setCellStyle(cellStyle);
        cell.setCellType(1);
        cell.setCellValue((RichTextString)text);
        text = new HSSFRichTextString(Msg.translate(Env.getCtx(), "description").toUpperCase());
        short s2 = col;
        col = (short)(col + 1);
        cell = row.createCell(s2);
        cell.setCellStyle(cellStyle);
        cell.setCellType(1);
        cell.setCellValue((RichTextString)text);
        for (MReportColumn mcol : m_columns) {
            String colName = mcol.getName();
            text = new HSSFRichTextString(colName.toUpperCase());
            short s3 = col;
            col = (short)(col + 1);
            cell = row.createCell(s3);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
        }
    }

    public void reportTable(HSSFWorkbook book, LinkedList<ReportTO> data, HSSFSheet sheet, int fila) {
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Arial");
        Iterator itRep = data.iterator();
        Boolean newRow = false;
        sheet.setColumnWidth((short)0, (short)3328);
        sheet.setColumnWidth((short)1, (short)15360);
        for (int i = 2; i < this.cols; ++i) {
            sheet.setColumnWidth((short)i, (short)3840);
        }
        HSSFCellStyle cellStyle = book.createCellStyle();
        HSSFCellStyle cellStyleD = book.createCellStyle();
        HSSFCellStyle cellStyleN = book.createCellStyle();
        while (itRep.hasNext()) {
            HSSFRichTextString text;
            HSSFRow row;
            short col = 0;
            ReportTO rpt = (ReportTO)itRep.next();
            if (!newRow.booleanValue()) {
                cellStyle = book.createCellStyle();
                cellStyleD = book.createCellStyle();
                cellStyleN = book.createCellStyle();
            }
            newRow = false;
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("T")) {
                row = sheet.createRow(fila++);
                HSSFFont fontT = book.createFont();
                fontT.setFontHeightInPoints((short)12);
                fontT.setFontName("Arial");
                fontT.setBoldweight((short)700);
                HSSFCellStyle cellStyleT = book.createCellStyle();
                cellStyleT.setWrapText(true);
                cellStyleT.setAlignment((short)2);
                cellStyleT.setVerticalAlignment((short)0);
                cellStyleT.setFont(fontT);
                org.apache.poi.hssf.util.Region region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
                sheet.addMergedRegion((Region)region);
                text = new HSSFRichTextString(rpt.getDescription());
                HSSFCell cellT = row.createCell(col);
                cellT.setCellStyle(cellStyleT);
                cellT.setCellValue((RichTextString)text);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("L")) {
                cellStyle.setWrapText(true);
                cellStyle.setBorderTop((short)2);
                cellStyle.setBottomBorderColor((short)8);
                cellStyleD.setWrapText(true);
                cellStyleD.setBorderTop((short)2);
                cellStyleD.setBottomBorderColor((short)8);
                cellStyleN.setWrapText(true);
                cellStyleN.setBorderTop((short)2);
                cellStyleN.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("X")) {
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment((short)0);
                cellStyle.setBorderTop((short)2);
                cellStyle.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("Z")) {
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment((short)0);
                cellStyle.setBorderTop((short)6);
                cellStyle.setBottomBorderColor((short)8);
                row = sheet.createRow(fila++);
                ReportTO rptD = new ReportTO();
                this.putRow(cellStyle, cellStyleD, cellStyleN, sheet, row, fila, rptD);
                cellStyle = book.createCellStyle();
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("D")) {
                cellStyleD.setWrapText(true);
                cellStyleD.setVerticalAlignment((short)0);
                cellStyleD.setBorderTop((short)2);
                cellStyleD.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("S")) {
                row = sheet.createRow(fila++);
                newRow = true;
                continue;
            }
            if (rpt.getTablevel() != null && rpt.getTablevel() > 0) {
                row = sheet.createRow(fila++);
                String jerarchy = "";
                for (int i = 1; i <= rpt.getTablevel(); ++i) {
                    jerarchy = jerarchy + "   ";
                }
                org.apache.poi.hssf.util.Region region = new org.apache.poi.hssf.util.Region(fila - 1, 0, fila - 1, this.endRegion);
                sheet.addMergedRegion((Region)region);
                text = new HSSFRichTextString(jerarchy + rpt.getDescription());
                HSSFCell cellJ = row.createCell(col);
                cellJ.setCellValue((RichTextString)text);
                newRow = true;
                continue;
            }
            row = sheet.createRow(fila++);
            this.putRow(cellStyle, cellStyleD, cellStyleN, sheet, row, fila, rpt);
        }
    }

    private void putRow(HSSFCellStyle cellStyle, HSSFCellStyle cellStyleD, HSSFCellStyle cellStyleN, HSSFSheet sheet, HSSFRow row, int fila, ReportTO rpt) {
        short col = 0;
        cellStyle.setAlignment((short)3);
        HSSFRichTextString text = new HSSFRichTextString(rpt.getName());
        short s = col;
        col = (short)(col + 1);
        HSSFCell cell = row.createCell(s);
        cell.setCellStyle(cellStyleN);
        cell.setCellValue((RichTextString)text);
        text = new HSSFRichTextString(rpt.getDescription());
        cell.setCellStyle(cellStyleD);
        short s2 = col;
        col = (short)(col + 1);
        cell = row.createCell(s2);
        cell.setCellValue((RichTextString)text);
        if (this.cols >= 3) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_0()));
            short s3 = col;
            col = (short)(col + 1);
            cell = row.createCell(s3);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 4) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_1()));
            short s4 = col;
            col = (short)(col + 1);
            cell = row.createCell(s4);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 5) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_2()));
            short s5 = col;
            col = (short)(col + 1);
            cell = row.createCell(s5);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 6) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_3()));
            short s6 = col;
            col = (short)(col + 1);
            cell = row.createCell(s6);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 7) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_4()));
            short s7 = col;
            col = (short)(col + 1);
            cell = row.createCell(s7);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 8) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_5()));
            short s8 = col;
            col = (short)(col + 1);
            cell = row.createCell(s8);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 9) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_6()));
            short s9 = col;
            col = (short)(col + 1);
            cell = row.createCell(s9);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 10) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_7()));
            short s10 = col;
            col = (short)(col + 1);
            cell = row.createCell(s10);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 11) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_8()));
            short s11 = col;
            col = (short)(col + 1);
            cell = row.createCell(s11);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 12) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_9()));
            short s12 = col;
            col = (short)(col + 1);
            cell = row.createCell(s12);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 13) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_10()));
            short s13 = col;
            col = (short)(col + 1);
            cell = row.createCell(s13);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 14) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_11()));
            short s14 = col;
            col = (short)(col + 1);
            cell = row.createCell(s14);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 15) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_12()));
            short s15 = col;
            col = (short)(col + 1);
            cell = row.createCell(s15);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 16) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_13()));
            short s16 = col;
            col = (short)(col + 1);
            cell = row.createCell(s16);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 17) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_14()));
            short s17 = col;
            col = (short)(col + 1);
            cell = row.createCell(s17);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 18) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_15()));
            short s18 = col;
            col = (short)(col + 1);
            cell = row.createCell(s18);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 19) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_16()));
            short s19 = col;
            col = (short)(col + 1);
            cell = row.createCell(s19);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 20) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_17()));
            short s20 = col;
            col = (short)(col + 1);
            cell = row.createCell(s20);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 21) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_18()));
            short s21 = col;
            col = (short)(col + 1);
            cell = row.createCell(s21);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 22) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_19()));
            short s22 = col;
            col = (short)(col + 1);
            cell = row.createCell(s22);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 23) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_20()));
            short s23 = col;
            col = (short)(col + 1);
            cell = row.createCell(s23);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
    }

    public File tofile(HSSFWorkbook wb, String[] generalTitle) {
        String path = System.getProperty("java.io.tmpdir");
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + System.getProperty("file.separator");
        }
        String prefix = StringUtils.makePrefix(generalTitle[0]);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
        }
        File file = new File(path + prefix + ".xls");
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "file", e);
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            wb.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private String formatValue(BigDecimal data) {
        if (data == null) {
            return "";
        }
        DecimalFormat frm = new DecimalFormat("###,###,###,##0.00");
        return frm.format(data.setScale(2, 4));
    }
}

