/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.engine.IInventoryAllocation;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class StorageEngine {
    protected static transient CLogger log = CLogger.getCLogger(StorageEngine.class);

    public static void createTrasaction(IDocumentLine docLine, String MovementType, Timestamp MovementDate, BigDecimal Qty, boolean isReversal, int M_Warehouse_ID, int o_M_AttributeSetInstance_ID, int o_M_Warehouse_ID, boolean isSOTrx) {
        boolean incomingTrx;
        MProduct product = MProduct.get(docLine.getCtx(), docLine.getM_Product_ID());
        boolean bl = incomingTrx = MovementType.charAt(1) == '+';
        if (product != null && product.isStocked()) {
            if (!isReversal) {
                StorageEngine.checkMaterialPolicy(docLine, MovementType, MovementDate, M_Warehouse_ID);
            }
            int reservationAttributeSetInstance_ID = o_M_AttributeSetInstance_ID;
            if (docLine.getM_AttributeSetInstance_ID() == 0) {
                IInventoryAllocation[] mas = StorageEngine.getMA(docLine);
                for (int j = 0; j < mas.length; ++j) {
                    IInventoryAllocation ma = mas[j];
                    BigDecimal QtyMA = ma.getMovementQty();
                    if (!incomingTrx) {
                        QtyMA = QtyMA.negate();
                    }
                    if (!MStorage.add(docLine.getCtx(), M_Warehouse_ID, docLine.getM_Locator_ID(), docLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, QtyMA, Env.ZERO, Env.ZERO, docLine.get_TrxName())) {
                        throw new AdempiereException();
                    }
                    StorageEngine.create(docLine, MovementType, MovementDate, ma.getM_AttributeSetInstance_ID(), QtyMA);
                }
            } else {
                if (!incomingTrx) {
                    Qty = Qty.negate();
                }
                if (!MStorage.add(docLine.getCtx(), M_Warehouse_ID, docLine.getM_Locator_ID(), docLine.getM_Product_ID(), docLine.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Qty, Env.ZERO, Env.ZERO, docLine.get_TrxName())) {
                    throw new AdempiereException();
                }
                StorageEngine.create(docLine, MovementType, MovementDate, docLine.getM_AttributeSetInstance_ID(), Qty);
            }
        }
    }

    private static void checkMaterialPolicy(IDocumentLine line, String MovementType, Timestamp MovementDate, int M_Warehouse_ID) {
        StorageEngine.deleteMA(line);
        boolean incomingTrx = MovementType.charAt(1) == '+';
        MProduct product = MProduct.get(line.getCtx(), line.getM_Product_ID());
        if (line.getM_Locator_ID() == 0) {
            // empty if block
        }
        if (line.getM_AttributeSetInstance_ID() == 0) {
            if (incomingTrx) {
                MStorage[] storages;
                X_M_AttributeSetInstance asi = null;
                for (MStorage storage : storages = MStorage.getWarehouse(line.getCtx(), M_Warehouse_ID, line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), line.get_TrxName())) {
                    if (storage.getQtyOnHand().signum() >= 0) continue;
                    asi = new MAttributeSetInstance(line.getCtx(), storage.getM_AttributeSetInstance_ID(), line.get_TrxName());
                    break;
                }
                if (asi == null) {
                    asi = MAttributeSetInstance.create(line.getCtx(), product, line.get_TrxName());
                }
                line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                log.config("New ASI=" + line);
                StorageEngine.createMA(line, line.getM_AttributeSetInstance_ID(), line.getMovementQty());
            } else {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = MovementDate;
                MStorage[] storages = MStorage.getWarehouse(line.getCtx(), M_Warehouse_ID, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, line.getM_Locator_ID(), line.get_TrxName());
                BigDecimal qtyToDeliver = line.getMovementQty();
                for (MStorage storage : storages) {
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        StorageEngine.createMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        qtyToDeliver = Env.ZERO;
                    } else {
                        StorageEngine.createMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        log.fine("QtyToDeliver=" + qtyToDeliver);
                    }
                    if (qtyToDeliver.signum() == 0) break;
                }
                if (qtyToDeliver.signum() != 0) {
                    MAttributeSetInstance asi = MAttributeSetInstance.create(line.getCtx(), product, line.get_TrxName());
                    StorageEngine.createMA(line, asi.getM_AttributeSetInstance_ID(), qtyToDeliver);
                }
            }
        } else if (!incomingTrx) {
            StorageEngine.createMA(line, line.getM_AttributeSetInstance_ID(), line.getMovementQty());
        }
        StorageEngine.save(line);
    }

    private static String getTableNameMA(IDocumentLine model) {
        return model.get_TableName() + "MA";
    }

    private static int deleteMA(IDocumentLine model) {
        String sql = "DELETE FROM " + StorageEngine.getTableNameMA(model) + " WHERE " + model.get_TableName() + "_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{model.get_ID()}, model.get_TrxName());
        if (no > 0) {
            log.config("Delete old #" + no);
        }
        return no;
    }

    private static void saveMA(IInventoryAllocation ma) {
        ((PO)((Object)ma)).saveEx();
    }

    private static void save(IDocumentLine line) {
        ((PO)((Object)line)).saveEx();
    }

    private static void create(IDocumentLine model, String MovementType, Timestamp MovementDate, int M_AttributeSetInstance_ID, BigDecimal Qty) {
        MTransaction mtrx = new MTransaction(model.getCtx(), model.getAD_Org_ID(), MovementType, model.getM_Locator_ID(), model.getM_Product_ID(), M_AttributeSetInstance_ID, Qty, MovementDate, model.get_TrxName());
        StorageEngine.setReferenceLine_ID(mtrx, model);
        mtrx.saveEx();
    }

    private static IInventoryAllocation createMA(IDocumentLine model, int M_AttributeSetInstance_ID, BigDecimal MovementQty) {
        Properties ctx = model.getCtx();
        String tableName = StorageEngine.getTableNameMA(model);
        String trxName = model.get_TrxName();
        IInventoryAllocation ma = (IInventoryAllocation)((Object)MTable.get(ctx, tableName).getPO(0, trxName));
        ma.setAD_Org_ID(model.getAD_Org_ID());
        StorageEngine.setReferenceLine_ID((PO)((Object)ma), model);
        ma.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        ma.setMovementQty(MovementQty);
        StorageEngine.saveMA(ma);
        log.fine("##: " + ma);
        return ma;
    }

    private static IInventoryAllocation[] getMA(IDocumentLine model) {
        Properties ctx = model.getCtx();
        String IDColumnName = model.get_TableName() + "_ID";
        String tableName = StorageEngine.getTableNameMA(model);
        String trxName = model.get_TrxName();
        String whereClause = IDColumnName + "=?";
        List<IInventoryAllocation> list = new Query(ctx, tableName, whereClause, trxName).setClient_ID().setParameters(model.get_ID()).setOrderBy(IDColumnName).list();
        IInventoryAllocation[] arr = new IInventoryAllocation[list.size()];
        return list.toArray(arr);
    }

    private static void setReferenceLine_ID(PO model, IDocumentLine ref) {
        String refColumnName = ref.get_TableName() + "_ID";
        if (model.get_ColumnIndex(refColumnName) < 0) {
            throw new AdempiereException("Invalid inventory document line " + ref);
        }
        model.set_ValueOfColumn(refColumnName, (Object)ref.get_ID());
    }

    public static int getM_Locator_ID(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal Qty, String trxName) {
        int M_Locator_ID = MStorage.getM_Locator_ID(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty, trxName);
        if (M_Locator_ID == 0) {
            MWarehouse wh = MWarehouse.get(ctx, M_Warehouse_ID);
            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        }
        return M_Locator_ID;
    }
}

