/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class LastInvoiceCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = model;
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
    }

    @Override
    public MCostDetail process() {
        MCost cost = this.costDetail.getM_Cost();
        CLogger s_log = CLogger.getCLogger(LastInvoiceCostingMethod.class);
        boolean isReturnTrx = this.costDetail.getQty().signum() < 0;
        MAcctSchema as = MAcctSchema.get(this.model.getCtx(), this.costDetail.getC_AcctSchema_ID(), this.model.get_TrxName());
        int precision = as.getCostingPrecision();
        BigDecimal price = this.costDetail.getAmt();
        if (this.costDetail.getQty().signum() != 0) {
            price = this.costDetail.getAmt().divide(this.costDetail.getQty(), precision, 4);
        }
        if (this.costDetail.getC_OrderLine_ID() != 0) {
            if (!isReturnTrx) {
                if (this.costDetail.getQty().signum() != 0) {
                    cost.setCurrentCostPrice(price);
                } else {
                    BigDecimal cCosts = cost.getCurrentCostPrice().add(this.costDetail.getAmt());
                    cost.setCurrentCostPrice(cCosts);
                }
            }
            cost.add(this.costDetail.getAmt(), this.costDetail.getQty());
            s_log.finer("Inv - LastInv - " + cost);
        } else if (this.costDetail.getM_InOutLine_ID() != 0 || this.costDetail.getM_MovementLine_ID() != 0 || this.costDetail.getM_InventoryLine_ID() != 0 || this.costDetail.getM_ProductionLine_ID() != 0 || this.costDetail.getC_ProjectIssue_ID() != 0 || this.costDetail.getPP_Cost_Collector_ID() != 0) {
            cost.setCurrentQty(cost.getCurrentQty().add(this.costDetail.getQty()));
            s_log.finer("QtyAdjust - LastInv - " + cost);
            cost.saveEx();
        }
        return this.costDetail;
    }

    @Override
    public void processCostDetail(MCostDetail mCostdetail) {
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public void updateAmountCost() {
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cd, int scale, int roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cd) {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cd, int scale, int roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cd) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cd) {
        return null;
    }
}

