/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostDimension;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostQueue;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class FifoLifoCostingMethod
extends AbstractCostingMethod {
    private List<CostComponent> m_calculatedCosts = null;

    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = transaction.getDocumentLine();
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, this.transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
    }

    public void calculate() {
        ProductCost pc = new ProductCost(this.model.getCtx(), this.model.getM_Product_ID(), this.model.getM_AttributeSetInstance_ID(), this.model.get_TrxName());
        pc.setQty(this.transaction.getMovementQty());
        List ccs = pc.getProductCostsLayers(this.dimension, 0, false);
        if (ccs == null || ccs.size() == 0) {
            MProduct product = MProduct.get(Env.getCtx(), this.model.getM_Product_ID());
            throw new AdempiereException("No Costs for " + product.getName());
        }
        this.m_calculatedCosts = ccs;
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        if (this.m_calculatedCosts == null) {
            this.calculate();
        }
        return this.m_calculatedCosts;
    }

    @Override
    protected void updateInventoryValue() {
        this.dimension.setCumulatedAmt(this.accumulatedAmount);
        this.dimension.setCumulatedAmtLL(this.accumulatedAmountLowerLevel);
        this.dimension.setCumulatedQty(this.accumulatedQuantity);
        this.dimension.setCurrentQty(this.accumulatedQuantity);
        this.dimension.saveEx();
    }

    public void updateCurrentCost(MCostDetail m_costdetail) {
        MCostQueue[] cQueue = MCostQueue.getQueue((MCost)this.dimension, (Timestamp)m_costdetail.getDateAcct(), (String)m_costdetail.get_TrxName());
        if (cQueue != null) {
            MCostType ct = (MCostType)this.dimension.getM_CostType();
            if (cQueue.length > 0 && ct.isFifo()) {
                this.dimension.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
            } else if (cQueue.length > 0 && "L".equals(this.dimension.getM_CostElement().getCostElementType())) {
                this.dimension.setCurrentCostPrice(cQueue[0].getCurrentCostPrice());
            }
        }
        this.dimension.setCurrentQty(this.dimension.getCurrentQty().add(m_costdetail.getQty()));
        if (cQueue != null && cQueue.length > 0) {
            BigDecimal cAmt = cQueue[0].getCurrentCostPrice().multiply(m_costdetail.getQty());
            this.dimension.setCumulatedAmt(this.dimension.getCumulatedAmt().add(cAmt));
            this.dimension.setCumulatedQty(this.dimension.getCumulatedQty().add(m_costdetail.getQty()));
        }
        this.log.finer("QtyAdjust - FiFo/Lifo - " + this.dimension);
        this.dimension.saveEx();
    }

    @Override
    public MCostDetail process() {
        this.processCostDetail();
        return this.costDetail;
    }

    public void processCostDetail() {
        this.lastCostDetail = MCostDetail.getLastTransaction(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.costingLevel);
        if (this.lastCostDetail == null) {
            this.lastCostDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.transaction.get_TrxName());
            this.lastCostDetail.setDateAcct(new Timestamp(System.currentTimeMillis()));
        }
        if (this.model.getReversalLine_ID() > 0) {
            this.createReversalCostDetail();
            MCostQueue cq = MCostQueue.getQueueForAdjustment((MCostDetail)this.costDetail, (MCost)this.dimension, (String)this.model.get_TrxName());
            if (cq.getCurrentQty().compareTo(this.costDetail.getQty()) == 1 || cq.getCurrentQty().compareTo(this.costDetail.getCurrentQty()) == 0) {
                cq.setCurrentQty(cq.getCurrentQty().add(this.costDetail.getQty()));
                this.dimension.setCurrentQty(this.dimension.getCurrentQty().add(this.costDetail.getQty()));
                cq.saveEx();
                this.dimension.saveEx();
            } else {
                this.processCostDetail(this.costDetail);
            }
            return;
        }
        if (this.costDetail == null) {
            for (MCostDetail cd : this.createCostDetails(this.dimension, this.transaction)) {
                if (CostDimension.isSameCostDimension(this.accountSchema, this.model) && (this.transaction.getMovementType().equals("M+") || this.transaction.getMovementType().equals("M-"))) {
                    this.costDetail = cd;
                    continue;
                }
                this.processCostDetail(cd);
                if (this.costDetail.getDateAcct().compareTo(this.lastCostDetail.getDateAcct()) >= 0) continue;
                this.adjustementQueue(cd);
            }
        } else {
            this.amount = this.transaction.getMovementQty().multiply(this.costThisLevel.add(this.costLowLevel));
            this.amountLowerLevel = this.transaction.getMovementQty().multiply(this.costLowLevel);
            this.accumulatedQuantity = this.dimension.getCumulatedQty();
            this.adjustCost = this.amount.subtract(this.costDetail.getAmt());
            this.accumulatedAmount = this.costDetail.getCumulatedAmt().add(this.amount).add(this.adjustCost);
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail).add(this.amountLowerLevel);
            this.currentCostPrice = this.accumulatedAmount.signum() != 0 ? this.accumulatedAmount.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4) : Env.ZERO;
            this.currentCostPriceLowerLevel = this.accumulatedAmountLowerLevel.signum() != 0 ? this.accumulatedAmountLowerLevel.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4) : Env.ZERO;
            if (this.adjustCost.compareTo(Env.ZERO) != 0) {
                this.costDetail.setCostAdjustment(this.adjustCost);
                this.costDetail.setProcessed(false);
                this.costDetail.setDescription("Adjust Cost:" + this.adjustCost);
                this.costDetail.setCostAdjustmentDate(this.model.getDateAcct());
                this.costDetail.saveEx();
            }
            this.costDetail.saveEx();
            if (this.costDetail.getCostAdjustmentDate() != null && this.accountSchema.isAdjustCOGS()) {
                this.adjustementQueue(this.costDetail);
            }
        }
    }

    @Override
    public void processCostDetail(MCostDetail costDetail) {
        boolean addition = costDetail.getQty().signum() > 0;
        MAcctSchema as = MAcctSchema.get(costDetail.getCtx(), costDetail.getC_AcctSchema_ID());
        int precision = as.getCostingPrecision();
        MProduct product = MProduct.get(costDetail.getCtx(), costDetail.getM_Product_ID());
        BigDecimal price = costDetail.getAmt();
        if (costDetail.getQty().signum() != 0) {
            price = costDetail.getAmt().divide(costDetail.getQty(), precision, 4);
        }
        int AD_Org_ID = costDetail.getAD_Org_ID();
        int M_ASI_ID = costDetail.getM_AttributeSetInstance_ID();
        if (costDetail.getC_OrderLine_ID() != 0 && this.model.getReversalLine_ID() <= 0) {
            this.log.finer("Inv - FiFo/LiFo - amt=" + costDetail.getAmt() + ", qty=" + costDetail.getQty() + " [NOTHING TO DO]");
        } else if (costDetail.getM_InOutLine_ID() != 0 || costDetail.getM_MovementLine_ID() != 0 || costDetail.getM_InventoryLine_ID() != 0 || costDetail.getM_ProductionLine_ID() != 0 || costDetail.getC_ProjectIssue_ID() != 0 || costDetail.getPP_Cost_Collector_ID() != 0 || costDetail.getC_LandedCostAllocation_ID() != 0) {
            if (addition) {
                MCostQueue.add((MProduct)product, (int)M_ASI_ID, (MAcctSchema)as, (int)AD_Org_ID, (int)costDetail.getM_CostElement_ID(), (BigDecimal)costDetail.getAmt(), (BigDecimal)costDetail.getQty(), (int)precision, (MCostDetail)costDetail, (String)costDetail.get_TrxName());
            } else {
                BigDecimal amtQueue = MCostQueue.adjustQty((MCost)this.dimension, (BigDecimal)costDetail.getQty().negate(), (Timestamp)costDetail.getDateAcct(), (String)costDetail.get_TrxName());
                amtQueue = amtQueue.negate();
                if (costDetail.getAmt().compareTo(amtQueue) != 0) {
                    BigDecimal priceQueue = Env.ZERO;
                    if (costDetail.getQty().signum() != 0) {
                        priceQueue = amtQueue.divide(costDetail.getQty(), precision, 4);
                    }
                    this.log.warning("Amt not match " + this + ": price=" + price + ", priceQueue=" + priceQueue + " [ADJUSTED]");
                    if ("Y".equals(Env.getContext(costDetail.getCtx(), "#M_CostDetail_CorrectAmt"))) {
                        costDetail.setAmt(amtQueue);
                        costDetail.setAmt(amtQueue);
                        costDetail.setPrice(priceQueue);
                    } else {
                        throw new AdempiereException("Amt not match " + this + ": price=" + price + ", priceQueue=" + priceQueue);
                    }
                }
            }
            costDetail.setCumulatedQty(this.dimension.getCumulatedQty());
            costDetail.setCumulatedAmt(this.dimension.getCumulatedQty());
            costDetail.setCurrentCostPrice(this.dimension.getCurrentCostPrice());
            this.updateCurrentCost(costDetail);
            costDetail.saveEx();
            this.costDetail = costDetail;
        }
    }

    public void adjustementQueue(MCostDetail costDetail) {
        List<MCostDetail> cds = costDetail.getCostAdjustmentDate() != null ? MCostDetail.getAfterDate(costDetail, this.costingLevel) : MCostDetail.getAfterDate(costDetail, this.costingLevel);
        ArrayList<MCostDetail> list = new ArrayList<MCostDetail>();
        for (MCostDetail cd : cds) {
            if (cd == null) {
                throw new AdempiereException("Error do not exist adjustment");
            }
            MCostQueue cq = MCostQueue.getQueueForAdjustment((MCostDetail)cd, (MCost)this.dimension, (String)this.model.get_TrxName());
            MTransaction trx = FifoLifoCostingMethod.get(cd);
            if (cq.getCurrentQty().compareTo(Env.ZERO) != 0 && (trx.getMovementType().equals("C-") || trx.getMovementType().equals("I+") || trx.getMovementType().equals("I-")) && cd.getCostAdjustmentDate() != null || (trx.getMovementType().equals("C-") || trx.getMovementType().equals("I+") || trx.getMovementType().equals("I-")) && this.transaction.getMovementType().endsWith("+")) {
                cq.addCurrentQty(cd.getQty().negate());
                cq.saveEx();
                cd.setProcessed(false);
                cd.setAmt(cd.getQty().multiply(this.costThisLevel.add(this.costLowLevel)));
                cd.saveEx();
                list.add(cd);
                continue;
            }
            if (trx.getMovementType().equals("V+") && costDetail.getCostAdjustmentDate() != null) {
                cd.setProcessed(false);
                cd.setAmt(this.amount);
                cd.saveEx();
                cq.setCurrentCostPrice(cd.getAmt().divide(cd.getQty()));
                cq.saveEx();
                break;
            }
            if (!trx.getMovementType().equals("M+") && !trx.getMovementType().equals("M-")) continue;
            MTransaction trxTo = trx.getMovementType().equals("M+") ? FifoLifoCostingMethod.getPrevious(trx) : FifoLifoCostingMethod.getNext(trx);
            cd.setProcessed(false);
            if (CostDimension.isSameCostDimension(this.accountSchema, trx, trxTo)) {
                cd.setAmt(cd.getQty().multiply(this.costThisLevel.add(this.costLowLevel)));
                cd.saveEx();
                continue;
            }
            cq.addCurrentQty(cd.getQty().negate());
            cd.setAmt(cd.getQty().multiply(this.costThisLevel.add(this.costLowLevel)));
            cd.saveEx();
            if (trx.getMovementType().equals("M+")) {
                cq.setCurrentCostPrice(cd.getAmt().divide(cd.getQty()));
            }
            if (cq.getCurrentCostPrice().compareTo(Env.ZERO) == 0) {
                cq.setCurrentCostPrice(cd.getCurrentCostPrice());
            }
            cq.saveEx();
            list.add(cd);
        }
        for (MCostDetail cd : list.toArray(new MCostDetail[list.size()])) {
            this.processCostDetail(cd);
        }
    }

    public static MTransaction get(MCostDetail cd) {
        String whereClause = "M_Product_ID=? AND M_Transaction_ID=? AND MovementQty=?";
        MTransaction trx = (MTransaction)new Query(cd.getCtx(), "M_Transaction", "M_Product_ID=? AND M_Transaction_ID=? AND MovementQty=?", cd.get_TrxName()).setClient_ID().setParameters(cd.getM_Product_ID(), cd.getM_Transaction_ID(), cd.getQty()).firstOnly();
        return trx;
    }

    public static MTransaction getPrevious(MTransaction trx) {
        String whereClause = "M_Transaction_ID<? AND M_Product_ID=? AND MovementQty=?";
        return (MTransaction)new Query(trx.getCtx(), "M_Transaction", "M_Transaction_ID<? AND M_Product_ID=? AND MovementQty=?", trx.get_TrxName()).setClient_ID().setParameters(trx.getM_Transaction_ID(), trx.getM_Product_ID(), trx.getMovementQty().negate()).first();
    }

    public static MTransaction getNext(MTransaction trx) {
        String whereClause = "M_Transaction_ID>? AND M_Product_ID=? AND MovementQty=?";
        return (MTransaction)new Query(trx.getCtx(), "M_Transaction", "M_Transaction_ID>? AND M_Product_ID=? AND MovementQty=?", trx.get_TrxName()).setClient_ID().setParameters(trx.getM_Transaction_ID(), trx.getM_Product_ID(), trx.getMovementQty().negate()).first();
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cd, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cd).signum() != 0 && this.getNewAccumulatedAmount(cd).signum() != 0) {
            return this.getNewAccumulatedAmount(cd).divide(this.getNewAccumulatedQuantity(cd), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cd) {
        BigDecimal cumulatedAmt = Env.ZERO;
        cumulatedAmt = cd.getQty().signum() > 0 ? cd.getCumulatedAmt().add(cd.getCostAmt()).add(cd.getCostAdjustment()) : cd.getCumulatedAmt().add(cd.getCostAmt().negate()).add(cd.getCostAdjustment().negate());
        return cumulatedAmt;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cd, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cd).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(cd).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(cd).divide(this.getNewAccumulatedQuantity(cd), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cd) {
        BigDecimal cumulatedAmtLL = Env.ZERO;
        cumulatedAmtLL = cd.getQty().signum() > 0 ? cd.getCumulatedAmtLL().add(cd.getCostAmtLL()).add(cd.getCostAdjustmentLL()) : cd.getCumulatedAmtLL().add(cd.getCostAmtLL().negate()).add(cd.getCostAdjustmentLL().negate());
        return cumulatedAmtLL;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cd) {
        return cd.getCumulatedQty().add(cd.getQty());
    }

    @Override
    public void updateAmountCost() {
        if (this.transaction.getMovementType().contains("+")) {
            this.costDetail.setCostAmt(this.costThisLevel.multiply(this.transaction.getMovementQty()).abs());
            this.costDetail.setCostAmtLL(this.costLowLevel.multiply(this.transaction.getMovementQty()).abs());
        }
        if (this.transaction.getMovementType().contains("-")) {
            this.costDetail.setCostAmt(this.costDetail.getAmt());
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL());
        }
    }
}

