/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.I_C_ProjectIssue;
import org.compiere.model.I_M_CostElement;
import org.compiere.model.I_M_CostType;
import org.compiere.model.I_M_InOut;
import org.compiere.model.I_M_Inventory;
import org.compiere.model.I_M_MatchInv;
import org.compiere.model.I_M_MatchPO;
import org.compiere.model.I_M_Movement;
import org.compiere.model.I_M_Product;
import org.compiere.model.I_M_Production;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovementLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrder;

public class CostEngine {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    public static final int[] documentsTableID = new int[]{I_M_InOut.Table_ID, I_M_Inventory.Table_ID, I_M_Movement.Table_ID, I_M_Product.Table_ID, I_C_ProjectIssue.Table_ID, I_PP_Cost_Collector.Table_ID, I_M_MatchPO.Table_ID, I_M_MatchInv.Table_ID};
    public static final String[] documentsTableName = new String[]{"M_InOut", "M_Inventory", "M_Movement", "M_Production", "C_ProjectIssue", "PP_Cost_Collector", "M_MatchPO", "M_MatchInv"};

    public static BigDecimal getSeedCost(Properties context, int productId, String trxName) {
        BigDecimal costThisLevel = Env.ZERO;
        MProductPO[] mProductPOArray = MProductPO.getOfProduct(context, productId, trxName);
        int n = mProductPOArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProductPO productPO = mProductPOArray[n2];
            if (productPO.isCurrentVendor()) {
                costThisLevel = productPO.getPriceLastInv().signum() != 0 ? productPO.getPriceLastInv() : (productPO.getPriceLastPO().signum() != 0 ? productPO.getPriceLastPO() : (productPO.getPricePO().signum() != 0 ? productPO.getPricePO() : productPO.getPriceList()));
                return costThisLevel;
            }
            ++n2;
        }
        return costThisLevel;
    }

    public static BigDecimal getParentActualCostByCostType(MAcctSchema accountSchema, int costTypeId, int costElementId, MPPOrder order) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("M_CostType_ID=? AND ");
        whereClause.append("M_CostElement_ID=? AND ");
        whereClause.append("PP_Cost_Collector_ID");
        whereClause.append(" IN (SELECT PP_Cost_Collector_ID FROM PP_Cost_Collector cc WHERE cc.PP_Order_ID=? AND ");
        whereClause.append(" cc.CostCollectorType <> '").append("100").append("')");
        BigDecimal actualCost = new Query(order.getCtx(), "M_CostDetail", whereClause.toString(), order.get_TrxName()).setClient_ID().setParameters(costTypeId, costElementId, order.getPP_Order_ID()).sum("(Amt+CostAmtLL)");
        whereClause = new StringBuffer();
        whereClause.append(" EXISTS (SELECT 1 FROM PP_Cost_Collector cc WHERE PP_Cost_Collector_ID=M_Transaction.PP_Cost_Collector_ID AND cc.PP_Order_ID=? AND cc.M_Product_ID=? )");
        BigDecimal qtyDelivered = new Query(order.getCtx(), "M_Transaction", whereClause.toString(), order.get_TrxName()).setClient_ID().setParameters(order.getPP_Order_ID(), order.getM_Product_ID()).sum("MovementQty");
        if (actualCost == null) {
            actualCost = Env.ZERO;
        }
        if (qtyDelivered.signum() != 0) {
            actualCost = actualCost.divide(qtyDelivered, accountSchema.getCostingPrecision(), 5);
        }
        return actualCost;
    }

    public static BigDecimal getParentActualCostByCostType(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, I_M_Production production) {
        BigDecimal totalCost = Env.ZERO;
        MProductionLine[] mProductionLineArray = ((MProduction)production).getLines();
        int n = mProductionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProductionLine productionLine = mProductionLineArray[n2];
            if (!productionLine.isParent()) {
                MCost costDimension;
                String productType = productionLine.getM_Product().getProductType();
                BigDecimal cost = BigDecimal.ZERO;
                if ("I".equals(productType)) {
                    cost = MCostDetail.getCostByModel(accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), productionLine);
                } else if ("R".equals(productType) && (costDimension = MCost.validateCostForCostType(accountSchema, costType, costElement, productionLine.getM_Product_ID(), productionLine.getAD_Org_ID(), productionLine.getM_Locator().getM_Warehouse_ID(), productionLine.getM_AttributeSetInstance_ID(), productionLine.get_TrxName())) != null && costDimension.getCurrentCostPrice().signum() != 0) {
                    cost = costDimension.getCurrentCostPrice().multiply(productionLine.getMovementQty().negate());
                }
                if (cost != null && cost.signum() != 0) {
                    totalCost = totalCost.add(cost);
                }
            }
            ++n2;
        }
        BigDecimal unitCost = Env.ZERO;
        if (production.getProductionQty().signum() != 0 && totalCost.signum() != 0) {
            unitCost = totalCost.divide(production.getProductionQty(), accountSchema.getCostingPrecision(), 4);
        }
        return unitCost;
    }

    protected static BigDecimal roundCost(BigDecimal price, int accountSchemaId) {
        int precision = MAcctSchema.get(Env.getCtx(), accountSchemaId).getCostingPrecision();
        BigDecimal priceRounded = price;
        if (priceRounded.scale() > precision) {
            priceRounded = priceRounded.setScale(precision, RoundingMode.HALF_UP);
        }
        return priceRounded;
    }

    public void createCostDetail(MTransaction transaction, IDocumentLine model) {
        MClient client = new MClient(transaction.getCtx(), transaction.getAD_Client_ID(), transaction.get_TrxName());
        StringBuilder description = new StringBuilder();
        if (!Util.isEmpty(model.getDescription(), true)) {
            description.append(model.getDescription());
        }
        if (model != null) {
            description.append(model.isSOTrx() ? "(|->)" : "(|<-)");
        }
        ArrayList<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>(Arrays.asList(MAcctSchema.getClientAcctSchema(transaction.getCtx(), transaction.getAD_Client_ID(), transaction.get_TrxName())));
        List<MCostElement> costElements = MCostElement.getCostElement(transaction.getCtx(), transaction.get_TrxName());
        List<MCostType> costTypes = MCostType.get(transaction.getCtx(), transaction.get_TrxName());
        for (MAcctSchema accountSchema : acctSchemas) {
            for (MCostType costType : costTypes) {
                if (!costType.isActive()) continue;
                for (MCostElement costElement : costElements) {
                    this.createCostDetail(accountSchema, costType, costElement, transaction, model, client.isCostImmediate());
                }
            }
        }
    }

    public void createCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MTransaction transaction, IDocumentLine model, boolean force) {
        if (!force) {
            return;
        }
        BigDecimal costThisLevel = Env.ZERO;
        BigDecimal costLowLevel = Env.ZERO;
        String costingLevel = MProduct.get(transaction.getCtx(), transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        if (model instanceof MMatchInv && "A".equals(costType.getCostingMethod())) {
            return;
        }
        if (model instanceof MMatchPO && "I".equals(costType.getCostingMethod())) {
            return;
        }
        if (model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)model;
            costThisLevel = allocation.getPriceActual();
        }
        MCost cost = MCost.validateCostForCostType(accountSchema, costType, costElement, transaction.getM_Product_ID(), transaction.getAD_Org_ID(), transaction.getM_Warehouse_ID(), transaction.getM_AttributeSetInstance_ID(), transaction.get_TrxName());
        if (("M".equals(costElement.getCostElementType()) || "L".equals(costElement.getCostElementType())) && transaction.getMovementType().contains("+") && !"S".equals(costType.getCostingMethod())) {
            if (model instanceof MMovementLine || model instanceof MInventoryLine || model instanceof MInOutLine && "C+".equals(transaction.getMovementType())) {
                MTransaction transactionFrom;
                BigDecimal costMovementFrom;
                costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                if (model instanceof MInventoryLine && costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                    MInventoryLine inventoryLine = (MInventoryLine)model;
                    if (inventoryLine.getQtyInternalUse().signum() == 0) {
                        costThisLevel = inventoryLine.getCurrentCostPrice();
                    }
                    if (costThisLevel.signum() == 0) {
                        costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                    }
                }
                if (model instanceof MMovementLine && (costMovementFrom = CostEngine.getCostThisLevel(accountSchema, costType, costElement, (transactionFrom = MTransaction.getByDocumentLine(model, "M-")) == null ? transaction : transactionFrom, model, costingLevel)).signum() > 0) {
                    costThisLevel = costMovementFrom;
                }
            } else if ("M".equals(costElement.getCostElementType()) && model.getPriceActual().signum() != 0) {
                costThisLevel = model.getPriceActual();
            }
        }
        if (!"S".equals(costType.getCostingMethod())) {
            MPPCostCollector costCollector;
            if (model instanceof MPPCostCollector && "100".equals((costCollector = (MPPCostCollector)model).getCostCollectorType())) {
                costLowLevel = CostEngine.getParentActualCostByCostType(accountSchema, costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), costCollector.getPP_Order());
            }
            if (model instanceof MProductionLine) {
                MProductionLine productionLine = (MProductionLine)model;
                if (productionLine.isParent()) {
                    costThisLevel = CostEngine.getParentActualCostByCostType(accountSchema, costType, costElement, productionLine.getM_Production());
                }
                if (costThisLevel.signum() == 0) {
                    costThisLevel = cost.getCurrentCostPrice();
                }
                if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                    costThisLevel = CostEngine.getSeedCost(transaction.getCtx(), transaction.getM_Product_ID(), transaction.get_TrxName());
                }
                if (productionLine.isParent()) {
                    if (!productionLine.getM_Product().isPurchased()) {
                        costLowLevel = costThisLevel;
                        costThisLevel = Env.ZERO;
                    }
                } else if (productionLine.getMovementQty().signum() < 0) {
                    costLowLevel = Env.ZERO;
                }
            }
        } else if ("S".equals(costType.getCostingMethod())) {
            costThisLevel = cost.getCurrentCostPrice();
            costLowLevel = cost.getCurrentCostPriceLL();
            if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                costThisLevel = CostEngine.getSeedCost(transaction.getCtx(), transaction.getM_Product_ID(), transaction.get_TrxName());
                if (costThisLevel.signum() == 0 && model instanceof MInOutLine && !model.isSOTrx()) {
                    MInOutLine inOutLine = (MInOutLine)model;
                    costThisLevel = inOutLine.getC_OrderLine().getPriceActual();
                }
                if (costThisLevel.signum() != 0) {
                    cost.setCurrentCostPrice(costThisLevel);
                    cost.saveEx();
                }
            }
        }
        ICostingMethod method = CostingMethodFactory.get().getCostingMethod(costType.getCostingMethod());
        method.setCostingMethod(accountSchema, transaction, model, cost, costThisLevel, costLowLevel, model.isSOTrx());
        method.process();
    }

    public void createCostDetailForLandedCostAllocation(MLandedCostAllocation allocation) {
        MInOutLine ioLine = (MInOutLine)allocation.getM_InOutLine();
        for (MTransaction transaction : MTransaction.getByInOutLine(ioLine)) {
            MAcctSchema[] mAcctSchemaArray = MAcctSchema.getClientAcctSchema(allocation.getCtx(), allocation.getAD_Client_ID());
            int n = mAcctSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema accountSchema = mAcctSchemaArray[n2];
                List<MCostType> costTypes = MCostType.get(allocation.getCtx(), allocation.get_TrxName());
                for (MCostType costType : costTypes) {
                    MCostElement costElement = (MCostElement)allocation.getM_CostElement();
                    CostEngineFactory.getCostEngine(allocation.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, allocation, true);
                }
                ++n2;
            }
        }
    }

    public static boolean isActivityControlElement(I_M_CostElement element) {
        String costElementType = element.getCostElementType();
        return "R".equals(costElementType) || "O".equals(costElementType) || "B".equals(costElementType);
    }

    public static List<MAcctSchema> getAcctSchema(PO po) {
        int AD_Org_ID = po.getAD_Org_ID();
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(po.getCtx(), po.getAD_Client_ID());
        ArrayList<MAcctSchema> list = new ArrayList<MAcctSchema>(ass.length);
        MAcctSchema[] mAcctSchemaArray = ass;
        int n = ass.length;
        int n2 = 0;
        while (n2 < n) {
            MAcctSchema as = mAcctSchemaArray[n2];
            if (!as.isSkipOrg(AD_Org_ID)) {
                list.add(as);
            }
            ++n2;
        }
        return list;
    }

    public static String getIDColumnName(IDocumentLine model) {
        String idColumnName = String.valueOf(model.get_TableName()) + "_ID";
        if (model instanceof MMatchPO) {
            idColumnName = "C_OrderLine_ID";
        }
        if (model instanceof MMatchInv) {
            idColumnName = "C_InvoiceLine_ID";
        }
        return idColumnName;
    }

    public static int getIDColumn(IDocumentLine model) {
        int id = model.get_ID();
        if (model instanceof MMatchPO) {
            id = ((MMatchPO)model).getC_OrderLine_ID();
        }
        if (model instanceof MMatchInv) {
            id = ((MMatchInv)model).getC_InvoiceLine_ID();
        }
        return id;
    }

    public static BigDecimal getCostThisLevel(MAcctSchema accountSchema, I_M_CostType costType, I_M_CostElement costElement, MTransaction transaction, IDocumentLine model, String costingLevel) {
        BigDecimal costThisLevel = Env.ZERO;
        MCostDetail lastCostDetail = MCostDetail.getLastTransaction(model, transaction, accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), model.getDateAcct(), costingLevel);
        if (lastCostDetail != null) {
            if (lastCostDetail.getQty().signum() != 0) {
                costThisLevel = lastCostDetail.getCostAmt().add(lastCostDetail.getCostAdjustment()).divide(lastCostDetail.getQty(), accountSchema.getCostingPrecision(), 4).abs();
            } else {
                if (lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()).signum() != 0) {
                    costThisLevel = lastCostDetail.getCostAmt().add(lastCostDetail.getCostAdjustment()).add(lastCostDetail.getCumulatedAmt()).divide(lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()), accountSchema.getCostingPrecision(), 4).abs();
                    return costThisLevel;
                }
                if (lastCostDetail.getCumulatedQty().signum() != 0) {
                    costThisLevel = lastCostDetail.getCumulatedAmt().divide(lastCostDetail.getCumulatedQty(), accountSchema.getCostingPrecision(), 4).abs();
                    return costThisLevel;
                }
            }
        }
        return costThisLevel;
    }

    public void clearAccounting(MAcctSchema accountSchema, MTransaction transaction) {
        if (transaction.getM_InOutLine_ID() > 0) {
            MInOutLine line = (MInOutLine)transaction.getM_InOutLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), line.getDateAcct())) {
                return;
            }
            List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
            for (MMatchPO match : orderMatches) {
                if (this.clearAccounting(accountSchema, accountSchema.getM_CostType(), match, line.getDateAcct())) continue;
                return;
            }
            List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
            for (MMatchInv match : invoiceMatches) {
                if (this.clearAccounting(accountSchema, accountSchema.getM_CostType(), match, line.getDateAcct())) continue;
                return;
            }
        } else if (transaction.getC_ProjectIssue_ID() > 0) {
            MProjectIssue line = (MProjectIssue)transaction.getC_ProjectIssue();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), line.getMovementDate())) {
                return;
            }
        } else if (transaction.getM_InventoryLine_ID() > 0) {
            MInventoryLine line = (MInventoryLine)transaction.getM_InventoryLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), line.getDateAcct())) {
                return;
            }
        } else if (transaction.getM_MovementLine_ID() > 0) {
            MMovementLine line = (MMovementLine)transaction.getM_MovementLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), line.getDateAcct())) {
                return;
            }
        } else if (transaction.getM_ProductionLine_ID() > 0) {
            MProductionLine line = (MProductionLine)transaction.getM_ProductionLine();
            MProduction production = (MProduction)line.getM_ProductionPlan().getM_Production();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), production, production.getMovementDate())) {
                return;
            }
        } else {
            if (transaction.getPP_Cost_Collector_ID() > 0) {
                MPPCostCollector costCollector = (MPPCostCollector)transaction.getPP_Cost_Collector();
                if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), costCollector, costCollector.getDateAcct())) {
                    // empty if block
                }
                return;
            }
            System.out.println("Document does not exist :" + transaction);
        }
    }

    public boolean clearAccounting(MAcctSchema accountSchema, I_M_CostType costType, PO model, Timestamp dateAcct) {
        String docBaseType;
        if (!accountSchema.getCostingMethod().equals(costType.getCostingMethod())) {
            return false;
        }
        if (model instanceof MMatchInv) {
            docBaseType = "MXI";
        } else if (model instanceof MMatchPO) {
            docBaseType = "MXP";
        } else if (model instanceof MProduction) {
            docBaseType = "MMP";
        } else {
            MDocType dt = MDocType.get(model.getCtx(), model.get_ValueAsInt("C_DocType_ID"));
            docBaseType = dt.getDocBaseType();
        }
        Boolean openPeriod = MPeriod.isOpen(model.getCtx(), dateAcct, docBaseType, model.getAD_Org_ID());
        if (!openPeriod.booleanValue()) {
            System.out.println("Period closed.");
            return false;
        }
        String sqlUpdate = "UPDATE " + model.get_TableName() + " SET Posted = 'N' WHERE " + model.get_TableName() + "_ID=?";
        DB.executeUpdate(sqlUpdate, new Object[]{model.get_ID()}, false, model.get_TrxName());
        String sqldelete = "DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?";
        DB.executeUpdate("DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?", new Object[]{model.get_ID(), model.get_Table_ID()}, false, model.get_TrxName());
        return true;
    }
}

