/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;

public class AveragePOCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = model;
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
    }

    public void calculate() {
        if (this.model instanceof MMatchInv) {
            return;
        }
        this.lastCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.model.getDateAcct(), this.costingLevel);
        if (this.model.getReversalLine_ID() > 0 && this.costDetail == null) {
            return;
        }
        if (this.costDetail != null && this.costDetail.isReversal() && this.model.getReversalLine_ID() > 0) {
            this.setReversalCostDetail();
            return;
        }
        if (this.lastCostDetail == null) {
            this.lastCostDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.transaction.get_TrxName());
            this.lastCostDetail.setDateAcct(this.model.getDateAcct());
        }
        BigDecimal quantityOnHand = this.getNewAccumulatedQuantity(this.lastCostDetail);
        if (this.transaction.getM_Transaction_ID() == this.lastCostDetail.getM_Transaction_ID()) {
            BigDecimal provisionOfPurchaseCost = BigDecimal.ZERO;
            BigDecimal provisionOfPurchaseCostLL = BigDecimal.ZERO;
            this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.transaction.getMovementQty());
            if (this.model instanceof MMatchInv && this.lastCostDetail.getC_InvoiceLine_ID() == 0) {
                provisionOfPurchaseCost = this.lastCostDetail.getCostAmt();
                provisionOfPurchaseCostLL = this.lastCostDetail.getCostAmtLL();
                MMatchInv iMatch = (MMatchInv)this.model;
                this.lastCostDetail.setC_InvoiceLine_ID(iMatch.getC_InvoiceLine_ID());
                this.lastCostDetail.saveEx();
                if (this.lastCostDetail != null && this.lastCostDetail.getM_CostDetail_ID() > 0) {
                    this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail);
                }
            }
            this.adjustCost = this.model.getMovementQty().multiply(this.costThisLevel).subtract(provisionOfPurchaseCost);
            this.adjustCostLowerLevel = this.model.getMovementQty().multiply(this.costLowLevel).subtract(provisionOfPurchaseCostLL);
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.adjustCost) : this.accumulatedAmount.add(this.adjustCost.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.adjustCostLowerLevel) : this.accumulatedAmountLowerLevel.add(this.adjustCostLowerLevel.negate());
            this.currentCostPrice = this.accumulatedAmount.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4);
            this.currentCostPriceLowerLevel = this.accumulatedAmountLowerLevel.divide(this.accumulatedQuantity.signum() != 0 ? this.accumulatedQuantity : BigDecimal.ONE, this.accountSchema.getCostingPrecision(), 4);
            if (this.adjustCost.add(this.adjustCostLowerLevel).signum() == 0) {
                return;
            }
            if (this.costDetail == null) {
                return;
            }
            this.costDetail.setCostAdjustment(this.adjustCost);
            this.costDetail.setAmt(this.costDetail.getCostAmt().add(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
            this.costDetail.setAmtLL(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
            this.updateAmountCost();
            return;
        }
        if (this.transaction.getMovementType().endsWith("+")) {
            if (quantityOnHand.signum() != 0 && this.getNewAccumulatedAmount(this.lastCostDetail).signum() == 0 && this.costThisLevel.signum() != 0) {
                this.adjustCost = quantityOnHand.add(this.transaction.getMovementQty()).multiply(this.costThisLevel).subtract(this.costThisLevel.multiply(this.transaction.getMovementQty()));
            } else if (quantityOnHand.add(this.transaction.getMovementQty()).signum() < 0 && this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4).signum() != 0 && this.costThisLevel.signum() == 0) {
                this.currentCostPrice = this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
                this.adjustCost = this.currentCostPrice.multiply(this.transaction.getMovementQty()).abs();
            }
            this.amount = this.transaction.getMovementQty().multiply(this.costThisLevel);
            this.amountLowerLevel = this.transaction.getMovementQty().multiply(this.costLowLevel);
            this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.transaction.getMovementQty());
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.amount) : this.accumulatedAmount.add(this.amount.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.amountLowerLevel) : this.accumulatedAmountLowerLevel.add(this.amountLowerLevel.negate());
            this.currentCostPrice = this.costThisLevel;
            this.currentCostPriceLowerLevel = this.costLowLevel;
        } else if (this.transaction.getMovementType().endsWith("-")) {
            if (quantityOnHand.add(this.transaction.getMovementQty()).signum() >= 0) {
                this.currentCostPrice = this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
                this.currentCostPriceLowerLevel = this.getNewCurrentCostPriceLowerLevel(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4);
            } else {
                this.currentCostPrice = CostEngine.getCostThisLevel(this.accountSchema, this.dimension.getM_CostType(), this.dimension.getM_CostElement(), this.transaction, this.model, this.costingLevel);
            }
            this.amount = this.transaction.getMovementQty().multiply(this.currentCostPrice);
            this.amountLowerLevel = this.transaction.getMovementQty().multiply(this.currentCostPriceLowerLevel);
            this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.lastCostDetail).add(this.transaction.getMovementQty());
            this.accumulatedAmount = this.getNewAccumulatedAmount(this.lastCostDetail);
            this.accumulatedAmount = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmount.add(this.amount) : this.accumulatedAmount.add(this.amount.negate());
            this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail);
            BigDecimal bigDecimal = this.accumulatedAmountLowerLevel = this.accumulatedQuantity.signum() > 0 ? this.accumulatedAmountLowerLevel.add(this.amountLowerLevel) : this.accumulatedAmountLowerLevel.add(this.amountLowerLevel.negate());
            if (this.costDetail != null) {
                this.costDetail.setAmt(this.currentCostPrice.multiply(this.transaction.getMovementQty().abs()));
                this.costDetail.setAmtLL(this.currentCostPriceLowerLevel.multiply(this.transaction.getMovementQty()).abs());
            }
        }
        if (this.costDetail == null) {
            return;
        }
        this.updateAmountCost();
    }

    private void createCostDetail() {
        if (this.model.getReversalLine_ID() > 0 && this.costDetail == null) {
            this.createReversalCostDetail();
            return;
        }
        if (this.model.getReversalLine_ID() > 0) {
            return;
        }
        int seqNo = this.lastCostDetail.getSeqNo() + 10;
        if (this.transaction.getM_Transaction_ID() != this.lastCostDetail.getM_Transaction_ID() && this.costDetail == null || this.adjustCost.add(this.adjustCostLowerLevel).signum() != 0 && this.costDetail == null) {
            BigDecimal movementQuantity = this.transaction.getMovementQty();
            if (this.adjustCost.add(this.adjustCostLowerLevel).signum() != 0 && (this.model instanceof MLandedCostAllocation || this.model instanceof MMatchInv)) {
                movementQuantity = Env.ZERO;
            }
            this.costDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.currentCostPrice.multiply(movementQuantity).abs(), this.currentCostPriceLowerLevel.multiply(movementQuantity).abs(), movementQuantity, this.transaction.get_TrxName());
            this.costDetail.setDateAcct(this.model.getDateAcct());
            this.costDetail.setSeqNo(seqNo);
            if (this.transaction != null) {
                this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
            }
            if (this.isSalesTransaction != null) {
                this.costDetail.setIsSOTrx(this.isSalesTransaction);
            } else {
                this.costDetail.setIsSOTrx(this.model.isSOTrx());
            }
            if (this.adjustCost.signum() != 0 || this.adjustCostLowerLevel.signum() != 0) {
                String description;
                String string = description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                if (this.adjustCost.signum() != 0) {
                    this.costDetail.setCostAdjustmentDate(this.model.getDateAcct());
                    this.costDetail.setCostAdjustment(this.adjustCost);
                    this.costDetail.setAmt(this.costDetail.getAmt().add(this.costDetail.getCostAdjustment()));
                    this.costDetail.setDescription(description + " Adjust Cost:" + this.adjustCost);
                }
                if (this.adjustCostLowerLevel.signum() != 0) {
                    description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                    this.costDetail.setCostAdjustmentDateLL(this.model.getDateAcct());
                    this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
                    this.costDetail.setAmt(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
                    this.costDetail.setDescription(description + " Adjust Cost LL:" + this.adjustCost);
                }
            }
            this.updateAmountCost();
            return;
        }
    }

    @Override
    public MCostDetail process() {
        this.calculate();
        this.createCostDetail();
        this.updateInventoryValue();
        this.createCostAdjustment();
        return this.costDetail;
    }

    public void createCostAdjustment() {
        if (!this.accountSchema.isAdjustCOGS()) {
            return;
        }
        if (this.costDetail == null || this.costDetail.isProcessing()) {
            return;
        }
        List<MCostDetail> cds = MCostDetail.getAfterDate(this.costDetail, this.costingLevel);
        if (cds == null || cds.size() == 0) {
            return;
        }
        MCostDetail last_cd = this.costDetail;
        this.costDetail = null;
        for (MCostDetail cd : cds) {
            cd.setSeqNo(last_cd.getSeqNo() + 10);
            cd.setProcessing(true);
            cd.saveEx();
            last_cd = cd;
        }
        for (MCostDetail cd : cds) {
            this.adjustCostDetail(cd);
            cd.setProcessing(false);
            cd.saveEx();
        }
    }

    @Override
    public void processCostDetail(MCostDetail costDetail) {
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cd, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cd).signum() != 0 && this.getNewAccumulatedAmount(cd).signum() != 0) {
            return this.getNewAccumulatedAmount(cd).divide(this.getNewAccumulatedQuantity(cd), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cd) {
        BigDecimal accumulatedAmount = Env.ZERO;
        if (cd.getQty().signum() > 0) {
            accumulatedAmount = cd.getCumulatedAmt().add(cd.getCostAmt()).add(cd.getCostAdjustment());
        } else if (cd.getQty().signum() < 0) {
            accumulatedAmount = cd.getCumulatedAmt().add(cd.getCostAmt().negate()).add(cd.getCostAdjustment().negate());
        } else if (cd.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cd).signum() > 0) {
                accumulatedAmount = cd.getCumulatedAmt().add(cd.getCostAmt()).add(cd.getCostAdjustment());
            } else if (this.getNewAccumulatedQuantity(cd).signum() < 0) {
                accumulatedAmount = cd.getCumulatedAmt().add(cd.getCostAmt().negate()).add(cd.getCostAdjustment().negate());
            }
        }
        return accumulatedAmount;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail costDetail, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(costDetail).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(costDetail).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(costDetail).divide(this.getNewAccumulatedQuantity(costDetail), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail costDetail) {
        BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
        accumulatedAmountLowerLevel = costDetail.getQty().signum() >= 0 ? costDetail.getCumulatedAmtLL().add(costDetail.getCostAmtLL()).add(costDetail.getCostAdjustmentLL()) : costDetail.getCumulatedAmtLL().add(costDetail.getCostAmtLL().negate()).add(costDetail.getCostAdjustmentLL().negate());
        return accumulatedAmountLowerLevel;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail costDetail) {
        return costDetail.getCumulatedQty().add(costDetail.getQty());
    }

    @Override
    public void updateAmountCost() {
        if (this.transaction.getMovementQty().signum() > 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().subtract(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().subtract(this.costDetail.getCostAdjustmentLL()));
        } else if (this.transaction.getMovementQty().signum() < 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().add(this.adjustCost));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().add(this.adjustCostLowerLevel));
        }
        this.costDetail.setCumulatedQty(this.getNewAccumulatedQuantity(this.lastCostDetail));
        this.costDetail.setCumulatedAmt(this.getNewAccumulatedAmount(this.lastCostDetail));
        this.costDetail.setCurrentCostPrice(this.currentCostPrice);
        this.costDetail.setCurrentCostPriceLL(this.currentCostPriceLowerLevel);
        String idColumnName = CostEngine.getIDColumnName(this.model);
        this.costDetail.set_ValueOfColumn(idColumnName, (Object)CostEngine.getIDColumn(this.model));
        if (this.model instanceof MInOutLine) {
            MInOutLine ioLine = (MInOutLine)this.model;
            this.costDetail.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
            this.costDetail.setC_InvoiceLine_ID(0);
        }
        if (this.model instanceof MMatchInv && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchInv iMatch = (MMatchInv)this.model;
            this.costDetail.setM_InOutLine_ID(iMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MMatchPO && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchPO poMatch = (MMatchPO)this.model;
            this.costDetail.setM_InOutLine_ID(poMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)this.model;
            this.costDetail.setM_InOutLine_ID(allocation.getM_InOutLine_ID());
            this.costDetail.setC_InvoiceLine_ID(allocation.getC_InvoiceLine_ID());
            this.costDetail.setProcessed(false);
        }
        this.costDetail.saveEx();
    }

    @Override
    public void updateInventoryValue() {
        if (this.accumulatedQuantity.signum() != 0) {
            this.dimension.setCurrentCostPrice(this.accumulatedAmount.divide(this.accumulatedQuantity, this.accountSchema.getCostingPrecision(), 4));
            this.dimension.setCurrentCostPriceLL(this.accumulatedAmountLowerLevel.divide(this.accumulatedQuantity, this.accountSchema.getCostingPrecision(), 4));
        }
        this.dimension.setCumulatedAmt(this.accumulatedAmount);
        this.dimension.setCumulatedAmtLL(this.accumulatedAmountLowerLevel);
        this.dimension.setCumulatedQty(this.accumulatedQuantity);
        this.dimension.setCurrentQty(this.accumulatedQuantity);
        this.dimension.saveEx();
    }

    @Override
    public void adjustCostDetail(MCostDetail costDetail) {
        Properties ctx = costDetail.getCtx();
        String trxName = costDetail.get_TrxName();
        int transactionId = costDetail.getM_Transaction_ID();
        int clientId = costDetail.getAD_Client_ID();
        MTransaction transaction = new MTransaction(ctx, transactionId, trxName);
        MCostType costType = (MCostType)costDetail.getM_CostType();
        MCostElement costElement = (MCostElement)costDetail.getM_CostElement();
        MAcctSchema accountSchema = (MAcctSchema)costDetail.getC_AcctSchema();
        if ("V+".equals(transaction.getMovementType())) {
            MInOutLine line = (MInOutLine)transaction.getDocumentLine();
            if ("M".equals(costElement.getCostElementType())) {
                if (costDetail.getM_InOutLine_ID() > 0 && costDetail.getQty().signum() != 0) {
                    CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, line, true);
                } else if (costDetail.getM_InOutLine_ID() > 0 && costDetail.getQty().signum() != 0 && costDetail.getC_OrderLine_ID() > 0) {
                    List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
                    for (MMatchPO mMatchPO : orderMatches) {
                        if (mMatchPO.getM_InOutLine_ID() != line.getM_InOutLine_ID() || mMatchPO.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                        CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, mMatchPO, true);
                    }
                } else if (costDetail.getM_InOutLine_ID() > 0 && costDetail.getQty().signum() == 0 && costDetail.getC_InvoiceLine_ID() > 0) {
                    List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
                    for (MMatchInv mMatchInv : invoiceMatches) {
                        if (mMatchInv.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                        CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, mMatchInv, true);
                    }
                }
            }
            for (MLandedCostAllocation allocation : MLandedCostAllocation.getOfInOuline(line, costElement.getM_CostElement_ID())) {
                CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, allocation, true);
            }
        } else {
            CostEngineFactory.getCostEngine(clientId).createCostDetail(accountSchema, costType, costElement, transaction, transaction.getDocumentLine(), true);
        }
    }
}

