/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MPPCostCollector;

public abstract class AbstractCostingMethod
implements ICostingMethod {
    protected final CLogger log = CLogger.getCLogger(this.getClass());
    protected MAcctSchema accountSchema;
    protected Timestamp dateAccounting;
    protected Boolean isOpenPeriod = null;
    protected BigDecimal movementQuantity = Env.ZERO;
    protected IDocumentLine model;
    protected MTransaction transaction;
    protected MCost dimension;
    protected Boolean isSalesTransaction;
    protected BigDecimal costThisLevel;
    protected BigDecimal costLowLevel;
    protected MCostDetail costDetail = null;
    protected BigDecimal accumulatedAmount = Env.ZERO;
    protected BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
    protected BigDecimal accumulatedQuantity = Env.ZERO;
    protected BigDecimal currentCostPrice = Env.ZERO;
    protected BigDecimal currentCostPriceLowerLevel = Env.ZERO;
    protected BigDecimal amount = Env.ZERO;
    protected BigDecimal amountLowerLevel = Env.ZERO;
    protected BigDecimal adjustCost = Env.ZERO;
    protected BigDecimal adjustCostLowerLevel = Env.ZERO;
    protected MCostDetail lastCostDetail = null;
    protected String costingLevel;

    protected List<MCostDetail> createCostDetails(MCost cost, MTransaction transaction) {
        IDocumentLine model = transaction.getDocumentLine();
        String idColumnName = model instanceof MMatchPO ? "C_OrderLine_ID" : (model instanceof MMatchInv ? "C_InvoiceLine_ID" : model.get_TableName() + "_ID");
        ArrayList<MCostDetail> list = new ArrayList<MCostDetail>();
        if (model.isSOTrx() || model instanceof MInventoryLine || model instanceof MMovementLine) {
            List<CostComponent> ccs = this.getCalculatedCosts();
            for (CostComponent cc : ccs) {
                MCostDetail cd = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), cc.getAmount(), Env.ZERO, cc.getQty(), this.model.get_TrxName());
                if (!cd.set_ValueOfColumnReturningBoolean(idColumnName, (Object)model.get_ID())) {
                    throw new AdempiereException("Cannot set " + idColumnName);
                }
                StringBuilder description = new StringBuilder();
                if (!Util.isEmpty(model.getDescription(), true)) {
                    description.append(model.getDescription());
                }
                if (model.isSOTrx()) {
                    description.append(model.isSOTrx() ? "(|->)" : "(|<-)");
                }
                if (model.isSOTrx()) {
                    cd.setIsSOTrx(model.isSOTrx());
                } else {
                    cd.setIsSOTrx(model.isSOTrx());
                }
                cd.setM_Transaction_ID(transaction.get_ID());
                cd.setDescription(description.toString());
                cd.saveEx();
                list.add(cd);
            }
        } else {
            int id;
            MCostDetail cd = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.costThisLevel.multiply(model.getMovementQty()), Env.ZERO, model.getMovementQty(), this.model.get_TrxName());
            if (model instanceof MMatchPO) {
                I_M_InOutLine iline = transaction.getM_InOutLine();
                I_C_OrderLine oline = iline.getC_OrderLine();
                id = oline.getC_OrderLine_ID();
            } else {
                id = model.get_ID();
            }
            if (!cd.set_ValueOfColumnReturningBoolean(idColumnName, (Object)id)) {
                throw new AdempiereException("Cannot set " + idColumnName);
            }
            if (model.isSOTrx()) {
                cd.setIsSOTrx(model.isSOTrx());
            } else {
                cd.setIsSOTrx(model.isSOTrx());
            }
            cd.setM_Transaction_ID(transaction.get_ID());
            cd.saveEx();
            list.add(cd);
        }
        return list;
    }

    protected abstract List<CostComponent> getCalculatedCosts();

    protected void updateInventoryValue() {
    }

    public void createReversalCostDetail() {
        MTransaction originalTransaction = MTransaction.getByDocumentLine(this.transaction);
        if (originalTransaction == null) {
            System.out.println("Transaction not found :" + this.transaction);
            return;
        }
        this.costDetail = new MCostDetail(this.model.getCtx(), 0, this.transaction.get_TrxName());
        this.lastCostDetail = MCostDetail.getByTransaction(originalTransaction.getDocumentLine(), originalTransaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
        if (this.lastCostDetail == null) {
            System.out.println("Detail Cost not found :" + originalTransaction);
            return;
        }
        MCostDetail.copyValues(this.lastCostDetail, this.costDetail);
        this.costDetail.setAD_Org_ID(this.lastCostDetail.getAD_Org_ID());
        this.costDetail.setM_Warehouse_ID(this.lastCostDetail.getM_Warehouse_ID());
        this.setReversalCostDetail();
        this.costDetail.setM_AttributeSetInstance_ID(this.transaction.getM_AttributeSetInstance_ID());
        this.costDetail.setDateAcct(this.model.getDateAcct());
        this.costDetail.setDescription("Reversal " + originalTransaction.getM_Transaction_ID());
        this.costDetail.setIsReversal(true);
        this.costDetail.saveEx();
        this.lastCostDetail.setDescription(this.lastCostDetail.getDescription() != null ? this.lastCostDetail.getDescription() : "|Reversal " + this.costDetail.getM_Transaction_ID());
        this.lastCostDetail.setIsReversal(true);
        this.lastCostDetail.saveEx(this.transaction.get_TrxName());
    }

    protected void setReversalCostDetail() {
        this.costDetail.setCurrentCostPrice(this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4));
        this.costDetail.setCurrentCostPriceLL(this.getNewCurrentCostPriceLowerLevel(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4));
        this.costDetail.setCurrentQty(Env.ZERO);
        this.costDetail.setQty(Env.ZERO);
        this.costDetail.setAmt(Env.ZERO);
        this.costDetail.setCostAmt(Env.ZERO);
        this.costDetail.setCostAdjustment(Env.ZERO);
        this.costDetail.setAmtLL(Env.ZERO);
        this.costDetail.setCostAmtLL(Env.ZERO);
        this.costDetail.setCostAdjustmentLL(Env.ZERO);
        this.costDetail.setCumulatedAmt(Env.ZERO);
        this.costDetail.setCumulatedAmtLL(Env.ZERO);
        this.costDetail.setCumulatedQty(Env.ZERO);
        this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        this.costDetail.setSeqNo(this.lastCostDetail.getSeqNo() + 10);
        this.costDetail.setQty(this.lastCostDetail.getQty().negate());
        this.costDetail.setAmt(this.lastCostDetail.getAmt());
        this.costDetail.setCostAmt(this.lastCostDetail.getCostAmt());
        this.costDetail.setCostAdjustment(this.lastCostDetail.getCostAdjustment());
        this.costDetail.setCostAdjustmentDate(this.lastCostDetail.getCostAdjustmentDate());
        this.currentCostPrice = this.lastCostDetail.getCurrentCostPrice();
        this.currentCostPriceLowerLevel = this.lastCostDetail.getCurrentCostPriceLL();
        this.updateAmountCost();
        this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.costDetail);
        this.accumulatedAmount = this.getNewAccumulatedAmount(this.costDetail);
        this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.costDetail);
        this.currentCostPrice = this.getNewCurrentCostPrice(this.costDetail, this.accountSchema.getCostingPrecision(), 4);
    }

    public abstract void updateAmountCost();

    public abstract BigDecimal getNewCurrentCostPrice(MCostDetail var1, int var2, int var3);

    public abstract BigDecimal getNewAccumulatedAmount(MCostDetail var1);

    public abstract BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail var1, int var2, int var3);

    public abstract BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail var1);

    public abstract BigDecimal getNewAccumulatedQuantity(MCostDetail var1);

    public void adjustCostDetail(MCostDetail costDetail) {
        MCostType costType = (MCostType)costDetail.getM_CostType();
        MCostElement costElement = (MCostElement)costDetail.getM_CostElement();
        MTransaction transaction = new MTransaction(costDetail.getCtx(), costDetail.getM_Transaction_ID(), costDetail.get_TrxName());
        IDocumentLine docLine = transaction.getDocumentLine();
        CostEngineFactory.getCostEngine(costDetail.getAD_Client_ID()).createCostDetail((MAcctSchema)costDetail.getC_AcctSchema(), costType, costElement, transaction, docLine, true);
    }

    public void clearAccounting(MCostDetail cd) {
        PO line;
        MTransaction trx = new MTransaction(cd.getCtx(), cd.getM_Transaction_ID(), cd.get_TrxName());
        IDocumentLine docLine = trx.getDocumentLine();
        MDocType dt = MDocType.get(cd.getCtx(), docLine.getC_DocType_ID());
        Boolean openPeriod = MPeriod.isOpen(cd.getCtx(), cd.getDateAcct(), dt.getDocBaseType(), cd.getAD_Org_ID());
        if (!openPeriod.booleanValue()) {
            return;
        }
        String sqldelete = "DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?";
        int ad_table_id = 0;
        int record_id = 0;
        if (cd.getC_OrderLine_ID() != 0) {
            line = (MOrderLine)cd.getC_OrderLine();
            ((MOrderLine)line).getParent().setPosted(false);
            ((MOrderLine)line).getParent().saveEx();
            record_id = ((MOrderLine)line).getParent().get_ID();
            ad_table_id = ((MOrderLine)line).getParent().get_Table_ID();
        }
        if (cd.getM_InOutLine_ID() != 0) {
            line = (MInOutLine)cd.getM_InOutLine();
            ((MInOutLine)line).getParent().setPosted(false);
            ((MInOutLine)line).getParent().saveEx();
            record_id = ((MInOutLine)line).getParent().get_ID();
            ad_table_id = ((MInOutLine)line).getParent().get_Table_ID();
        }
        if (cd.getM_InventoryLine_ID() != 0) {
            line = (MInventoryLine)cd.getM_InventoryLine();
            ((MInventoryLine)line).getParent().setPosted(false);
            ((MInventoryLine)line).getParent().saveEx();
            record_id = ((MInventoryLine)line).getParent().get_ID();
            ad_table_id = ((MInventoryLine)line).getParent().get_Table_ID();
        }
        if (cd.getM_MovementLine_ID() != 0) {
            line = (MMovementLine)cd.getM_MovementLine();
            ((MMovementLine)line).getParent().setPosted(false);
            ((MMovementLine)line).getParent().saveEx();
            record_id = ((MMovementLine)line).getParent().get_ID();
            ad_table_id = ((MMovementLine)line).getParent().get_Table_ID();
        }
        if (cd.getM_ProductionLine_ID() != 0) {
            // empty if block
        }
        if (cd.getPP_Cost_Collector_ID() != 0) {
            MPPCostCollector cc = (MPPCostCollector)cd.getPP_Cost_Collector();
            cc.setPosted(false);
            cc.saveEx();
            record_id = cc.get_ID();
            ad_table_id = cc.get_Table_ID();
        }
        int no = DB.executeUpdateEx(sqldelete, new Object[]{record_id, ad_table_id}, cd.get_TrxName());
    }
}

