/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MQuery;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;

public class GraphColumn {
    private MAchievement m_achievement = null;
    private MMeasureCalc m_mc = null;
    private MGoal m_goal = null;
    private MRequestType m_rt = null;
    private MProjectType m_pt = null;
    private int m_id = 0;
    private String m_measureDisplay = null;
    private Timestamp m_date = null;
    private String m_label = null;
    private double m_value = 0.0;
    private String m_labelValue = "";
    private double m_targetValue = 0.0;
    private double m_width = 0.0;
    private double m_height = 0.0;
    private static CLogger log = CLogger.getCLogger(GraphColumn.class);
    private static DecimalFormat s_format = DisplayType.getNumberFormat(11);

    public GraphColumn(String label, double value) {
        this.m_label = label;
        this.setValue(value);
    }

    public GraphColumn(MAchievement achievement) {
        this(achievement.getName(), achievement.getManualActual().doubleValue());
        this.m_achievement = achievement;
    }

    public GraphColumn(MGoal goal, BigDecimal data) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_goal = goal;
    }

    public GraphColumn(MMeasureCalc mc, BigDecimal data) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_mc = mc;
    }

    public GraphColumn(MRequestType rt, BigDecimal data, int id) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_rt = rt;
        this.m_id = id;
    }

    public GraphColumn(MProjectType pt, BigDecimal data, int id) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_pt = pt;
        this.m_id = id;
    }

    public MGoal getGoal() {
        return this.m_goal;
    }

    public MAchievement getAchievement() {
        return this.m_achievement;
    }

    public MMeasureCalc getMeasureCalc() {
        return this.m_mc;
    }

    public MRequestType getRequestType() {
        return this.m_rt;
    }

    public MProjectType getProjectType() {
        return this.m_pt;
    }

    public String getMeasureDisplay() {
        return this.m_measureDisplay;
    }

    public Timestamp getDate() {
        return this.m_date;
    }

    public int getID() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
        this.m_labelValue = this.m_label != null ? s_format.format(this.m_value) + " - " + this.m_label : s_format.format(this.m_value);
    }

    public void setLabel(Timestamp date, String MeasureDisplay) {
        if (date == null) {
            return;
        }
        this.m_date = date;
        this.m_measureDisplay = MeasureDisplay;
        SimpleDateFormat format = DisplayType.getDateFormat(15);
        String text = format.format(date);
        if ("5".equals(MeasureDisplay) || "3".equals(MeasureDisplay)) {
            String pattern = format.toPattern();
            String mmText = text;
            int index = pattern.indexOf("dd");
            if (index == 0) {
                mmText = text.substring(3);
            } else if (index > 0) {
                mmText = text.substring(0, index - 1);
                if (text.length() > index + 2) {
                    mmText = mmText + text.substring(index + 2);
                }
            }
            this.setLabel(mmText);
        } else {
            this.setLabel(text);
        }
    }

    public double getTargetValue() {
        return this.m_targetValue;
    }

    public void setTargetValue(double targetValue) {
        this.m_targetValue = targetValue;
    }

    public double getValue() {
        return this.m_value;
    }

    public void setValue(double value) {
        this.m_value = value;
        this.m_labelValue = this.m_label != null ? s_format.format(this.m_value) + " - " + this.m_label : s_format.format(this.m_value);
    }

    public double getColWidth() {
        return this.m_width;
    }

    public void setColWidth(double width) {
        this.m_width = width;
    }

    public double getColHeight() {
        return this.m_height;
    }

    public void setColHeight(double height) {
        this.m_height = height;
    }

    public MQuery getMQuery(MGoal mGoal) {
        MQuery query = null;
        if (this.getAchievement() != null) {
            MAchievement a2 = this.getAchievement();
            query = MQuery.getEqualQuery("PA_Measure_ID", a2.getPA_Measure_ID());
        } else if (this.getGoal() != null) {
            MGoal goal = this.getGoal();
            query = MQuery.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
        } else if (this.getMeasureCalc() != null) {
            MMeasureCalc mc = this.getMeasureCalc();
            query = mc.getQuery(mGoal.getRestrictions(false), this.getMeasureDisplay(), this.getDate(), MRole.getDefault());
        } else if (this.getProjectType() != null) {
            MProjectType pt = this.getProjectType();
            query = pt.getQuery(mGoal.getRestrictions(false), this.getMeasureDisplay(), this.getDate(), this.getID(), MRole.getDefault());
        } else if (this.getRequestType() != null) {
            MRequestType rt = this.getRequestType();
            query = rt.getQuery(mGoal.getRestrictions(false), this.getMeasureDisplay(), this.getDate(), this.getID(), MRole.getDefault());
        }
        return query;
    }
}

