/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.VirtualizerStore;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwapFileVirtualizerStore
implements VirtualizerStore {
    private static final Log log = LogFactory.getLog(SwapFileVirtualizerStore.class);
    private final JRSwapFile swap;
    private final boolean swapOwner;
    private final Map<String, JRSwapFile.SwapHandle> handles;

    public SwapFileVirtualizerStore(JRSwapFile swap, boolean swapOwner) {
        this.swap = swap;
        this.swapOwner = swapOwner;
        this.handles = Collections.synchronizedMap(new HashMap());
    }

    public String toString() {
        return "SwapFileVirtualizerStore " + this.swap.toString();
    }

    protected boolean isStored(JRVirtualizable<?> o) {
        return this.handles.containsKey(o.getUID());
    }

    @Override
    public boolean store(JRVirtualizable<?> o, VirtualizationSerializer serializer) {
        if (this.isStored(o)) {
            if (log.isTraceEnabled()) {
                log.trace("object " + o.getUID() + " already stored");
            }
            return false;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(3000);
            serializer.writeData(o, bout);
            byte[] data = bout.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace("writing " + data.length + " for object " + o.getUID() + " to " + this.swap);
            }
            JRSwapFile.SwapHandle handle = this.swap.write(data);
            this.handles.put(o.getUID(), handle);
            return true;
        }
        catch (IOException e) {
            log.error("Error virtualizing object " + o.getUID() + " to " + this.swap, e);
            throw new JRRuntimeException("Error virtualizing object", e);
        }
    }

    @Override
    public void retrieve(JRVirtualizable<?> o, boolean remove, VirtualizationSerializer serializer) {
        JRSwapFile.SwapHandle handle = this.handles.get(o.getUID());
        if (handle == null) {
            log.error("No swap handle found for " + o.getUID() + " in " + this);
            throw new JRRuntimeException("Unable to read virtualized data");
        }
        try {
            byte[] data = this.swap.read(handle, remove);
            if (log.isTraceEnabled()) {
                log.trace("read " + data.length + " for object " + o.getUID() + " from " + this.swap);
            }
            serializer.readData(o, new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            log.error("Error reading object data " + o.getUID() + " from " + this.swap, e);
            throw new JRRuntimeException("Error devirtualizing object", e);
        }
        if (remove) {
            this.handles.remove(o.getUID());
        }
    }

    @Override
    public void remove(String objectId) {
        JRSwapFile.SwapHandle handle = this.handles.remove(objectId);
        if (handle == null) {
            if (log.isTraceEnabled()) {
                log.trace("object " + objectId + " not found for removal");
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("removing object " + objectId + " from " + this.swap);
            }
            this.swap.free(handle);
        }
    }

    @Override
    public void dispose() {
        this.handles.clear();
        if (this.swapOwner) {
            if (log.isDebugEnabled()) {
                log.debug("disposing " + this.swap);
            }
            this.swap.dispose();
        }
    }
}

