/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    private static final Log log = LogFactory.getLog(AbstractThreadSubreportRunner.class);
    protected final JRBaseFiller subreportFiller;

    public AbstractThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport);
        this.subreportFiller = subreportFiller;
    }

    @Override
    public JRSubreportRunResult start() {
        this.doStart();
        return this.waitResult();
    }

    protected abstract void doStart();

    @Override
    public JRSubreportRunResult resume() {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notifying to continue");
        }
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": waiting for fill result");
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (this.subreportFiller.fillContext.isCanceled()) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.subreportFiller.fillerId + ": exception", e);
                }
            } else if (log.isErrorEnabled()) {
                log.error("Fill " + this.subreportFiller.fillerId + ": exception", e);
            }
            throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notified of fill result");
        }
        return this.runResult();
    }

    @Override
    public void cancel() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notifying to continue on cancel");
        }
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.subreportFiller.fillerId + ": still running, waiting");
            }
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error("Fill " + this.subreportFiller.fillerId + ": exception", e);
                }
                throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.subreportFiller.fillerId + ": wait ended");
            }
        }
    }

    @Override
    public void suspend() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notifying on suspend");
        }
        this.subreportFiller.notifyAll();
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": waiting to continue");
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (this.subreportFiller.fillContext.isCanceled()) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.subreportFiller.fillerId + ": exception", e);
                }
            } else if (log.isErrorEnabled()) {
                log.error("Fill " + this.subreportFiller.fillerId + ": exception", e);
            }
            throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notified to continue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.subreportFiller.fillerId + ": notifying of completion");
        }
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }
}

