/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementXlsHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterContext;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog(JRXlsExporter.class);
    public static final String XLS_EXPORTER_KEY = "net.sf.jasperreports.xls";
    public static short MAX_COLOR_INDEX = (short)56;
    public static short MIN_COLOR_INDEX = (short)10;
    private static Map<Color, HSSFColor> hssfColorsCache = new ReferenceMap();
    protected Map<StyleInfo, HSSFCellStyle> loadedCellStyles = new HashMap<StyleInfo, HSSFCellStyle>();
    protected Map<String, List<Hyperlink>> anchorLinks = new HashMap<String, List<Hyperlink>>();
    protected Map<Integer, List<Hyperlink>> pageLinks = new HashMap<Integer, List<Hyperlink>>();
    protected Map<String, HSSFName> anchorNames = new HashMap<String, HSSFName>();
    protected HSSFWorkbook workbook;
    protected HSSFSheet sheet;
    protected HSSFRow row;
    protected HSSFCell cell;
    protected HSSFCellStyle emptyCellStyle;
    protected CreationHelper createHelper;
    private HSSFPalette palette = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short customColorIndex = MIN_COLOR_INDEX;
    protected short backgroundMode = 1;
    protected HSSFDataFormat dataFormat;
    protected HSSFPatriarch patriarch;
    protected String password;
    protected JRXlsExporterContext exporterContext = new ExporterContext();

    public JRXlsExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void setParameters() {
        super.setParameters();
        this.nature = new JRXlsExporterNature(this.jasperReportsContext, this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
        this.password = this.getStringParameter(JRXlsExporterParameter.PASSWORD, "net.sf.jasperreports.export.xls.password");
    }

    @Override
    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    @Override
    protected void openWorkbook(OutputStream os) {
        if (this.workbookTemplate == null) {
            this.workbook = new HSSFWorkbook();
        } else {
            InputStream templateIs = null;
            try {
                templateIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(this.workbookTemplate);
                if (templateIs == null) {
                    throw new JRRuntimeException("Workbook template not found at : " + this.workbookTemplate);
                }
                this.workbook = new HSSFWorkbook(new POIFSFileSystem(templateIs));
                if (this.keepTemplateSheets.booleanValue()) {
                    this.sheetIndex += this.workbook.getNumberOfSheets();
                } else {
                    for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                        this.workbook.removeSheetAt(i);
                    }
                }
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                if (templateIs != null) {
                    try {
                        templateIs.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
        this.createHelper = this.workbook.getCreationHelper();
        this.firstPageNotSet = true;
        this.palette = this.workbook.getCustomPalette();
        this.customColorIndex = MIN_COLOR_INDEX;
    }

    @Override
    protected void createSheet(CutsInfo xCuts, String name) {
        this.sheet = this.workbook.createSheet(name);
        this.patriarch = this.sheet.createDrawingPatriarch();
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        printSetup.setLandscape(this.jasperPrint.getOrientationValue() == OrientationEnum.LANDSCAPE);
        short paperSize = this.getSuitablePaperSize(this.jasperPrint);
        if (paperSize != -1) {
            printSetup.setPaperSize(paperSize);
        }
        if (this.password != null) {
            this.sheet.protectSheet(this.password);
        }
        if (this.jasperPrint.getLeftMargin() != null) {
            this.sheet.setMargin((short)0, LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getLeftMargin().intValue()));
        }
        if (this.jasperPrint.getRightMargin() != null) {
            this.sheet.setMargin((short)1, LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getRightMargin().intValue()));
        }
        if (this.jasperPrint.getTopMargin() != null) {
            this.sheet.setMargin((short)2, LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getTopMargin().intValue()));
        }
        if (this.jasperPrint.getBottomMargin() != null) {
            this.sheet.setMargin((short)3, LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getBottomMargin().intValue()));
        }
        String fitWidth = this.getPropertiesUtil().getProperty(this.jasperPrint, "net.sf.jasperreports.export.xls.fit.width");
        if (!this.isValidScale(this.sheetPageScale) && fitWidth != null && fitWidth.length() > 0) {
            printSetup.setFitWidth(Short.valueOf(fitWidth).shortValue());
            this.sheet.setAutobreaks(true);
        }
        String fitHeight = this.getPropertiesUtil().getProperty(this.jasperPrint, "net.sf.jasperreports.export.xls.fit.height");
        if (!this.isValidScale(this.sheetPageScale) && fitHeight != null && fitHeight.length() > 0) {
            printSetup.setFitHeight(Short.valueOf(fitHeight).shortValue());
            this.sheet.setAutobreaks(true);
        }
        if (this.sheetHeaderLeft != null) {
            this.sheet.getHeader().setLeft(this.sheetHeaderLeft);
        }
        if (this.sheetHeaderCenter != null) {
            this.sheet.getHeader().setCenter(this.sheetHeaderCenter);
        }
        if (this.sheetHeaderRight != null) {
            this.sheet.getHeader().setRight(this.sheetHeaderRight);
        }
        if (this.sheetFooterLeft != null) {
            this.sheet.getFooter().setLeft(this.sheetFooterLeft);
        }
        if (this.sheetFooterCenter != null) {
            this.sheet.getFooter().setCenter(this.sheetFooterCenter);
        }
        if (this.sheetFooterRight != null) {
            this.sheet.getFooter().setRight(this.sheetFooterRight);
        }
        if (this.sheetDirection != null) {
            printSetup.setLeftToRight(this.sheetDirection == RunDirectionEnum.LTR);
            this.sheet.setRightToLeft(this.sheetDirection == RunDirectionEnum.RTL);
        }
        if (this.sheetFirstPageNumber != null && this.sheetFirstPageNumber > 0) {
            printSetup.setPageStart((short)this.sheetFirstPageNumber.intValue());
            printSetup.setUsePage(true);
            this.firstPageNotSet = false;
        } else if (this.documentFirstPageNumber != null && this.documentFirstPageNumber > 0 && this.firstPageNotSet) {
            printSetup.setPageStart((short)this.documentFirstPageNumber.intValue());
            printSetup.setUsePage(true);
            this.firstPageNotSet = false;
        }
        if (!(this.firstPageNotSet || this.sheet.getFooter().getCenter() != null && this.sheet.getFooter().getCenter().length() != 0)) {
            this.sheet.getFooter().setCenter("Page " + HeaderFooter.page());
        }
        boolean showGridlines = this.sheetShowGridlines != null ? this.sheetShowGridlines : (this.documentShowGridlines != null ? this.documentShowGridlines : true);
        this.sheet.setDisplayGridlines(showGridlines);
        this.maxRowFreezeIndex = 0;
        this.maxColumnFreezeIndex = 0;
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            for (String string : this.anchorNames.keySet()) {
                HSSFName anchor = this.anchorNames.get(string);
                List<Hyperlink> linkList = this.anchorLinks.get(string);
                int index = anchor.getSheetIndex();
                anchor.setRefersToFormula("'" + this.workbook.getSheetName(index) + "'!" + anchor.getRefersToFormula());
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    link.setAddress(anchor.getRefersToFormula());
                }
            }
            for (Object object : this.pageLinks.keySet()) {
                List<Hyperlink> linkList = this.pageLinks.get(object);
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    if (this.isOnePagePerSheet) {
                        link.setAddress("'" + this.workbook.getSheetName((Integer)object - 1) + "'!$A$1");
                        continue;
                    }
                    link.setAddress("'" + this.workbook.getSheetName(0) + "'!$A$1");
                }
            }
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                this.workbook.getSheetAt(i).setForceFormulaRecalculation(true);
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        if (autoFit) {
            this.sheet.autoSizeColumn(col, false);
        } else {
            this.sheet.setColumnWidth(col, Math.min(43 * width, 65280));
        }
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) {
        boolean isAutoFit;
        this.row = this.sheet.getRow(rowIndex);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowIndex);
        }
        boolean bl = isAutoFit = yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") && (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false;
        if (!isAutoFit) {
            this.row.setHeightInPoints((float)lastRowHeight);
        }
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell(colIndex);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = this.getWorkbookColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = this.getWorkbookColor(line.getLinePen().getLineColor()).getIndex();
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), boxStyle, this.isCellLocked(line), this.isCellHidden(line));
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = this.getWorkbookColor(element.getLinePen().getLineColor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isCellLocked(element), this.isCellHidden(element));
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    public void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = this.getWorkbookColor(textElement.getForecolor()).getIndex();
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(textElement);
        short horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        short verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont(textElement, forecolor, null, this.getTextLocale(textElement)), gridCell, this.isWrapText(textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit(textElement)), this.isCellLocked(textElement), this.isCellHidden(textElement));
        this.createTextCell(textElement, gridCell, colIndex, rowIndex, styledText, baseStyle, forecolor);
    }

    protected void createTextCell(final JRPrintText textElement, final JRExporterGridCell gridCell, final int colIndex, final int rowIndex, final JRStyledText styledText, final StyleInfo baseStyle, final short forecolor) throws JRException {
        String anchorName;
        String textStr;
        block12: {
            String formula = this.getFormula(textElement);
            textStr = styledText.getText();
            if (formula != null) {
                try {
                    String convertedPattern;
                    TextValue value = this.getTextValue(textElement, textStr);
                    if (value instanceof NumberTextValue) {
                        convertedPattern = this.getConvertedPattern(textElement, ((NumberTextValue)value).getPattern());
                        if (convertedPattern != null) {
                            baseStyle.setDataFormat(this.dataFormat.getFormat(convertedPattern));
                        }
                    } else if (value instanceof DateTextValue && (convertedPattern = this.getConvertedPattern(textElement, ((DateTextValue)value).getPattern())) != null) {
                        baseStyle.setDataFormat(this.dataFormat.getFormat(convertedPattern));
                    }
                    HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    this.cell.setCellType(2);
                    this.cell.setCellFormula(formula);
                    this.endCreateCell(cellStyle);
                    return;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block12;
                    log.warn(e.getMessage());
                }
            }
        }
        if (this.isDetectCellType) {
            TextValue value = this.getTextValue(textElement, textStr);
            value.handle(new TextValueHandler(){

                @Override
                public void handle(StringTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if ("none".equals(textElement.getMarkup())) {
                        JRXlsExporter.this.setStringCellValue(textValue.getText());
                    } else {
                        JRXlsExporter.this.setRichTextStringCellValue(styledText, forecolor, textElement, JRXlsExporter.this.getTextLocale(textElement));
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                @Override
                public void handle(NumberTextValue textValue) {
                    String convertedPattern = JRXlsExporter.this.getConvertedPattern(textElement, textValue.getPattern());
                    if (convertedPattern != null) {
                        baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(convertedPattern));
                    }
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().doubleValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                @Override
                public void handle(DateTextValue textValue) {
                    baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(JRXlsExporter.this.getConvertedPattern(textElement, textValue.getPattern())));
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    Date date = textValue.getValue();
                    if (date == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        date = JRXlsExporter.this.translateDateValue(textElement, date);
                        JRXlsExporter.this.cell.setCellValue(date);
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                @Override
                public void handle(BooleanTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().booleanValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }
            });
        } else {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            if ("none".equals(textElement.getMarkup())) {
                this.setStringCellValue(textStr);
            } else {
                this.setRichTextStringCellValue(styledText, forecolor, textElement, this.getTextLocale(textElement));
            }
            this.endCreateCell(cellStyle);
        }
        if (!this.ignoreAnchors && (anchorName = textElement.getAnchorName()) != null) {
            HSSFName aName = this.workbook.createName();
            aName.setNameName(JRStringUtil.getJavaIdentifier(anchorName));
            aName.setSheetIndex(this.workbook.getSheetIndex((Sheet)this.sheet));
            CellReference cRef = new CellReference(rowIndex, colIndex, true, true);
            aName.setRefersToFormula(cRef.formatAsString());
            this.anchorNames.put(anchorName, aName);
        }
        this.setHyperlinkCell(textElement);
    }

    protected HSSFCellStyle initCreateCell(JRExporterGridCell gridCell, int colIndex, int rowIndex, StyleInfo baseStyle) {
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(baseStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        return cellStyle;
    }

    protected void endCreateCell(HSSFCellStyle cellStyle) {
        this.cell.setCellStyle(cellStyle);
    }

    protected final void setStringCellValue(String textStr) {
        this.cell.setCellValue((RichTextString)new HSSFRichTextString(textStr));
    }

    protected final void setRichTextStringCellValue(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        if (styledText != null) {
            this.cell.setCellValue((RichTextString)this.getRichTextString(styledText, forecolor, defaultFont, locale));
        }
    }

    protected HSSFRichTextString getRichTextString(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        String text = styledText.getText();
        HSSFRichTextString richTextStr = new HSSFRichTextString(text);
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            JRFont runFont = attributes.isEmpty() ? defaultFont : new JRBaseFont(attributes);
            short runForecolor = attributes.get(TextAttribute.FOREGROUND) != null ? this.getWorkbookColor((Color)attributes.get(TextAttribute.FOREGROUND)).getIndex() : forecolor;
            HSSFFont font = this.getLoadedFont(runFont, runForecolor, attributes, locale);
            richTextStr.applyFont(iterator.getIndex(), runLimit, (Font)font);
            iterator.setIndex(runLimit);
        }
        return richTextStr;
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        int rowSpan;
        int n = rowSpan = this.isCollapseRowSpan ? 1 : gridCell.getRowSpan();
        if (gridCell.getColSpan() > 1 || rowSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex + gridCell.getColSpan() - 1));
            for (int i = 0; i < rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.getColSpan(); ++j) {
                    HSSFCell spanCell = spanRow.getCell(colIndex + j);
                    if (spanCell == null) {
                        spanCell = spanRow.createCell(colIndex + j);
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return 3;
            }
            case CENTER: {
                return 2;
            }
            case JUSTIFIED: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return 2;
            }
            case MIDDLE: {
                return 1;
            }
            case JUSTIFIED: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return 90;
            }
            case RIGHT: {
                return -90;
            }
        }
        return 0;
    }

    protected HSSFColor getWorkbookColor(Color awtColor) {
        byte red = (byte)awtColor.getRed();
        byte green = (byte)awtColor.getGreen();
        byte blue = (byte)awtColor.getBlue();
        HSSFColor color = null;
        if (this.createCustomPalette) {
            try {
                color = this.palette.findColor(red, green, blue) != null ? this.palette.findColor(red, green, blue) : this.palette.addColor(red, green, blue);
            }
            catch (Exception e) {
                if (this.customColorIndex < MAX_COLOR_INDEX) {
                    this.palette.setColorAtIndex(this.customColorIndex, red, green, blue);
                    short s = this.customColorIndex;
                    this.customColorIndex = (short)(s + 1);
                    color = this.palette.getColor(s);
                }
                color = this.palette.findSimilarColor(red, green, blue);
            }
        }
        return color == null ? JRXlsExporter.getNearestColor(awtColor) : color;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = hssfColorsCache.get(awtColor);
        if (color == null) {
            Set keys;
            Hashtable triplets = HSSFColor.getTripletHash();
            if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
                Object key2 = null;
                HSSFColor crtColor = null;
                short[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                for (Object key2 : keys) {
                    crtColor = (HSSFColor)triplets.get(key2);
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor, Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        HSSFFont cellFont = null;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontName, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontName = exportFont;
            }
        }
        short superscriptType = 0;
        if (attributes != null && attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            Object value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                superscriptType = 1;
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                superscriptType = 2;
            }
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != fontSize || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || !(cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) || cf.getItalic() != font.isItalic() || cf.getTypeOffset() != superscriptType) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            cellFont.setTypeOffset(superscriptType);
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(style.mode);
            cellStyle.setAlignment(style.horizontalAlignment);
            cellStyle.setVerticalAlignment(style.verticalAlignment);
            cellStyle.setRotation(style.rotation);
            cellStyle.setFont(style.font);
            cellStyle.setWrapText(style.lcWrapText);
            cellStyle.setLocked(style.lcCellLocked);
            cellStyle.setHidden(style.lcCellHidden);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            if (!this.isIgnoreCellBorder) {
                BoxStyle box = style.box;
                cellStyle.setBorderTop(box.borderStyle[0]);
                cellStyle.setTopBorderColor(box.borderColour[0]);
                cellStyle.setBorderLeft(box.borderStyle[1]);
                cellStyle.setLeftBorderColor(box.borderColour[1]);
                cellStyle.setBorderBottom(box.borderStyle[2]);
                cellStyle.setBottomBorderColor(box.borderColour[2]);
                cellStyle.setBorderRight(box.borderStyle[3]);
                cellStyle.setRightBorderColor(box.borderColour[3]);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        return this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell, true, false);
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean isCellLocked, boolean isCellHidden) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell, isCellLocked, isCellHidden);
        return this.getLoadedCellStyle(style);
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
        return this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, false);
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean isCellLocked, boolean isCellHidden) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, isCellLocked, isCellHidden);
        return this.getLoadedCellStyle(style);
    }

    protected static short getBorderStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return 6;
                }
                case DOTTED: {
                    return 7;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return 8;
                    }
                    return 3;
                }
            }
            if (lineWidth >= 2.0f) {
                return 5;
            }
            if (lineWidth >= 1.0f) {
                return 2;
            }
            if (lineWidth >= 0.5f) {
                return 1;
            }
            return 4;
        }
        return 0;
    }

    @Override
    public void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        try {
            int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
            int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
            int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
            int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
            int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
            availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
            int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
            availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
            Renderable renderer = element.getRenderable();
            if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
                if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                    renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, element.getOnErrorTypeValue());
                    if (renderer != null) {
                        renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, element.getOnErrorTypeValue());
                    }
                } else {
                    renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(element.getWidth(), element.getHeight()), ModeEnum.OPAQUE == element.getModeValue() ? element.getBackcolor() : null);
                }
            } else {
                renderer = null;
            }
            if (renderer != null) {
                int normalWidth = availableImageWidth;
                int normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
                if (dimension != null) {
                    normalWidth = (int)dimension.getWidth();
                    normalHeight = (int)dimension.getHeight();
                }
                float xalignFactor = 0.0f;
                switch (element.getHorizontalAlignmentValue()) {
                    case RIGHT: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case CENTER: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (element.getVerticalAlignmentValue()) {
                    case BOTTOM: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case MIDDLE: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                byte[] imageData = null;
                int topOffset = 0;
                int leftOffset = 0;
                int bottomOffset = 0;
                int rightOffset = 0;
                switch (element.getScaleImageValue()) {
                    case CLIP: {
                        int dpi = this.getPropertiesUtil().getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
                        double scale = (double)dpi / 72.0;
                        BufferedImage bi = new BufferedImage((int)(scale * (double)availableImageWidth), (int)(scale * (double)availableImageHeight), 2);
                        Graphics2D grx = bi.createGraphics();
                        grx.scale(scale, scale);
                        grx.clip(new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                        renderer.render(this.jasperReportsContext, grx, new Rectangle((int)(xalignFactor * (float)(availableImageWidth - normalWidth)), (int)(yalignFactor * (float)(availableImageHeight - normalHeight)), normalWidth, normalHeight));
                        topOffset = topPadding;
                        leftOffset = leftPadding;
                        bottomOffset = bottomPadding;
                        rightOffset = rightPadding;
                        imageData = JRImageLoader.getInstance(this.jasperReportsContext).loadBytesFromAwtImage((Image)bi, ImageTypeEnum.PNG);
                        break;
                    }
                    case FILL_FRAME: {
                        topOffset = topPadding;
                        leftOffset = leftPadding;
                        bottomOffset = bottomPadding;
                        rightOffset = rightPadding;
                        imageData = renderer.getImageData(this.jasperReportsContext);
                        break;
                    }
                    default: {
                        if (element.getHeight() <= 0) break;
                        double ratio = (double)normalWidth / (double)normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            normalWidth = availableImageWidth;
                            normalHeight = (int)((double)availableImageWidth / ratio);
                        } else {
                            normalWidth = (int)((double)availableImageHeight * ratio);
                            normalHeight = availableImageHeight;
                        }
                        topOffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        leftOffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        bottomOffset = bottomPadding + (int)((1.0f - yalignFactor) * (float)(availableImageHeight - normalHeight));
                        rightOffset = rightPadding + (int)((1.0f - xalignFactor) * (float)(availableImageWidth - normalWidth));
                        imageData = renderer.getImageData(this.jasperReportsContext);
                    }
                }
                short mode = this.backgroundMode;
                short backcolor = this.whiteIndex;
                if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                    mode = 1;
                    backcolor = this.getWorkbookColor(gridCell.getCellBackcolor()).getIndex();
                }
                short forecolor = this.getWorkbookColor(element.getLineBox().getPen().getLineColor()).getIndex();
                if (element.getModeValue() == ModeEnum.OPAQUE) {
                    backcolor = this.getWorkbookColor(element.getBackcolor()).getIndex();
                }
                HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isCellLocked(element), this.isCellHidden(element));
                this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
                this.cell = this.row.createCell(colIndex);
                this.cell.setCellStyle(cellStyle);
                double topPos = this.getRowRelativePosition(layout, yCutsRow, topOffset);
                double leftPos = this.getColumnRelativePosition(layout, colIndex, leftOffset);
                double bottomPos = this.getRowRelativePosition(layout, yCutsRow, element.getHeight() - bottomOffset);
                double rightPos = this.getColumnRelativePosition(layout, colIndex, element.getWidth() - rightOffset);
                HSSFClientAnchor anchor = new HSSFClientAnchor((int)((leftPos - (double)((int)leftPos)) * 1023.0), (int)((topPos - (double)((int)topPos)) * 255.0), (int)((rightPos - (double)((int)rightPos)) * 1023.0), (int)((bottomPos - (double)((int)bottomPos)) * 255.0), (short)(colIndex + (int)leftPos), (int)((short)(rowIndex + (int)topPos)), (short)(colIndex + (int)rightPos), (int)((short)(rowIndex + (int)bottomPos)));
                String currentAnchorType = JRPropertiesUtil.getOwnProperty(element, "net.sf.jasperreports.export.xls.image.anchor.type") != null ? JRPropertiesUtil.getOwnProperty(element, "net.sf.jasperreports.export.xls.image.anchor.type") : (this.imageAnchorType != null ? this.imageAnchorType : ImageAnchorTypeEnum.MOVE_NO_SIZE.getName());
                anchor.setAnchorType((int)ImageAnchorTypeEnum.getByName(currentAnchorType).getValue());
                int imgIndex = this.workbook.addPicture(imageData, 6);
                this.patriarch.createPicture(anchor, imgIndex);
            }
        }
        catch (Exception ex) {
            throw new JRException("The cell cannot be added", ex);
        }
        catch (Error err) {
            throw new JRException("The cell cannot be added", err);
        }
    }

    protected double getColumnRelativePosition(JRGridLayout layout, int col, int offset) {
        int colWidth;
        double colRelPos = 0.0;
        int colIndex = 0;
        for (int cumulativeColWidth = 0; cumulativeColWidth < offset; cumulativeColWidth += colWidth) {
            colWidth = layout.getColumnWidth(col + colIndex);
            if (cumulativeColWidth + colWidth < offset) {
                ++colIndex;
                continue;
            }
            colRelPos += (double)colIndex + (double)(offset - cumulativeColWidth) / (double)colWidth;
        }
        return colRelPos;
    }

    protected double getRowRelativePosition(JRGridLayout layout, int row, int offset) {
        int rowHeight;
        double rowRelPos = 0.0;
        int rowIndex = 0;
        for (int cumulativeRowHeight = 0; cumulativeRowHeight < offset; cumulativeRowHeight += rowHeight) {
            int n = rowHeight = this.isCollapseRowSpan ? layout.getMaxRowHeight(row + rowIndex) : layout.getRowHeight(row + rowIndex);
            if (cumulativeRowHeight + rowHeight < offset) {
                ++rowIndex;
                continue;
            }
            rowRelPos += (double)rowIndex + (double)(offset - cumulativeRowHeight) / (double)rowHeight;
        }
        return rowRelPos;
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) {
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            mode = 1;
            backcolor = this.getWorkbookColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = this.getWorkbookColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell, this.isCellLocked(frame), this.isCellHidden(frame));
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell(x);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementXlsHandler handler = (GenericElementXlsHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XLS_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug("No XLS generic element handler for " + element.getGenericType());
        }
    }

    private final short getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        int ps = -1;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 4; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 4) {
                    ps = 9;
                    break;
                }
                if (i != 5) break;
                ps = 11;
                break;
            }
            if (ps == -1 && (width == 110L && height == 220L || width == 220L && height == 110L)) {
                ps = 27;
            }
            if (ps == -1) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = 1;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = 5;
                } else if (width == 190L && height == 254L || width == 254L && height == 190L) {
                    ps = 7;
                }
            }
        }
        return (short)ps;
    }

    protected void setHyperlinkCell(JRPrintHyperlink hyperlink) {
        Hyperlink link;
        block17: {
            JRHyperlinkProducer customHandler;
            block18: {
                link = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", hyperlink);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.xls.ignore.hyperlink", false);
                }
                if (ignoreHyperlink.booleanValue()) break block17;
                customHandler = this.getHyperlinkProducer(hyperlink);
                if (customHandler != null) break block18;
                switch (hyperlink.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        String href = hyperlink.getHyperlinkReference();
                        if (href != null) {
                            link = this.createHelper.createHyperlink(1);
                            link.setAddress(href);
                            break;
                        }
                        break block17;
                    }
                    case LOCAL_ANCHOR: {
                        String href;
                        if (!this.ignoreAnchors && (href = hyperlink.getHyperlinkAnchor()) != null) {
                            link = this.createHelper.createHyperlink(2);
                            if (this.anchorLinks.containsKey(href)) {
                                this.anchorLinks.get(href).add(link);
                                break;
                            }
                            ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                            hrefList.add(link);
                            this.anchorLinks.put(href, hrefList);
                            break;
                        }
                        break block17;
                    }
                    case LOCAL_PAGE: {
                        Integer hrefPage = hyperlink.getHyperlinkPage();
                        if (hrefPage != null) {
                            link = this.createHelper.createHyperlink(2);
                            if (this.pageLinks.containsKey(hrefPage)) {
                                this.pageLinks.get(hrefPage).add(link);
                                break;
                            }
                            ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                            hrefList.add(link);
                            this.pageLinks.put(hrefPage, hrefList);
                            break;
                        }
                        break block17;
                    }
                    case REMOTE_ANCHOR: {
                        String href = hyperlink.getHyperlinkReference();
                        if (href != null && hyperlink.getHyperlinkAnchor() != null) {
                            href = href + "#" + hyperlink.getHyperlinkAnchor();
                            link = this.createHelper.createHyperlink(4);
                            link.setAddress(href);
                            break;
                        }
                        break block17;
                    }
                    case REMOTE_PAGE: {
                        String href = hyperlink.getHyperlinkReference();
                        if (href != null && hyperlink.getHyperlinkPage() != null) {
                            href = href + "#JR_PAGE_ANCHOR_0_" + hyperlink.getHyperlinkPage().toString();
                            link = this.createHelper.createHyperlink(4);
                            link.setAddress(href);
                            break;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            String href = customHandler.getHyperlink(hyperlink);
            if (href != null) {
                link = this.createHelper.createHyperlink(1);
                link.setAddress(href);
            }
        }
        if (link != null) {
            this.cell.setHyperlink(link);
        }
    }

    @Override
    protected String getExporterKey() {
        return XLS_EXPORTER_KEY;
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
        int maxRowIndex;
        int n = this.isFreezeRowEdge ? Math.max(rowIndex, this.maxRowFreezeIndex) : (maxRowIndex = isRowEdge ? rowIndex : Math.max(rowIndex, this.maxRowFreezeIndex));
        int maxColIndex = this.isFreezeColumnEdge ? Math.max(colIndex, this.maxColumnFreezeIndex) : (isColumnEdge ? colIndex : Math.max(colIndex, this.maxColumnFreezeIndex));
        this.sheet.createFreezePane(maxColIndex, maxRowIndex);
        this.maxRowFreezeIndex = maxRowIndex;
        this.maxColumnFreezeIndex = maxColIndex;
        this.isFreezeRowEdge = isRowEdge;
        this.isFreezeColumnEdge = isColumnEdge;
    }

    @Override
    protected void setSheetName(String sheetName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex((Sheet)this.sheet), sheetName);
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
        this.sheet.setAutoFilter(CellRangeAddress.valueOf((String)autoFilterRange));
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
        SortedMap<String, Integer> levelMap = levelInfo.getLevelMap();
        if (levelMap != null && levelMap.size() > 0) {
            for (String l : levelMap.keySet()) {
                if (level != null && l.compareTo(level) < 0) continue;
                Integer startIndex = (Integer)levelMap.get(l);
                if (levelInfo.getEndIndex() <= startIndex) continue;
                this.sheet.groupRow(startIndex.intValue(), levelInfo.getEndIndex().intValue());
            }
            this.sheet.setRowSumsBelow(false);
        }
    }

    @Override
    protected void setScale(Integer scale) {
        if (this.isValidScale(scale)) {
            HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
            printSetup.setScale((short)scale.intValue());
        }
    }

    class StyleInfo {
        protected final short mode;
        protected final short backcolor;
        protected final short horizontalAlignment;
        protected final short verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box;
        protected final boolean lcWrapText;
        protected final boolean lcCellLocked;
        protected final boolean lcCellHidden;
        private short lcDataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jRXlsExporter.new BoxStyle(gridCell), true, true, false);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked, boolean cellHidden) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jRXlsExporter.new BoxStyle(gridCell), wrapText, cellLocked, cellHidden);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean cellLocked, boolean cellHidden) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jRXlsExporter.new BoxStyle(gridCell), true, cellLocked, cellHidden);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jRXlsExporter.new BoxStyle(gridCell), wrapText, true, false);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, true, false);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, wrapText, true, false);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean cellLocked, boolean cellHidden) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, cellLocked, cellHidden);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean cellHidden) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.lcWrapText = wrapText;
            this.lcCellLocked = cellLocked;
            this.lcCellHidden = cellHidden;
            this.hashCode = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode;
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : (int)this.font.getIndex());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.lcDataFormat;
            hash = 31 * hash + (this.lcWrapText ? 0 : 1);
            hash = 31 * hash + (this.lcCellLocked ? 0 : 1);
            hash = 31 * hash + (this.lcCellHidden ? 0 : 1);
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.lcDataFormat = dataFormat;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.lcDataFormat != -1;
        }

        public short getDataFormat() {
            return this.lcDataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo s = (StyleInfo)o;
            return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndex() == this.font.getIndex()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation && s.lcWrapText == this.lcWrapText && s.lcCellLocked == JRXlsExporter.this.cellLocked && s.lcCellHidden == JRXlsExporter.this.cellHidden;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.lcDataFormat + "," + this.lcWrapText + "," + this.lcCellLocked + "," + this.lcCellHidden + ")";
        }
    }

    class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected short[] borderStyle = new short[4];
        protected short[] borderColour = new short[4];
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JRXlsExporter.getBorderStyle(pen);
            this.borderColour[side] = JRXlsExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            JRPrintElement element;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
            }
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JRXlsExporter.getBorderStyle(box.getTopPen());
            this.borderColour[0] = JRXlsExporter.this.getWorkbookColor(box.getTopPen().getLineColor()).getIndex();
            this.borderStyle[2] = JRXlsExporter.getBorderStyle(box.getBottomPen());
            this.borderColour[2] = JRXlsExporter.this.getWorkbookColor(box.getBottomPen().getLineColor()).getIndex();
            this.borderStyle[1] = JRXlsExporter.getBorderStyle(box.getLeftPen());
            this.borderColour[1] = JRXlsExporter.this.getWorkbookColor(box.getLeftPen().getLineColor()).getIndex();
            this.borderStyle[3] = JRXlsExporter.getBorderStyle(box.getRightPen());
            this.borderColour[3] = JRXlsExporter.this.getWorkbookColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == 0 && this.borderStyle[1] == 0 && this.borderStyle[2] == 0 && this.borderStyle[3] == 0) {
                short style = JRXlsExporter.getBorderStyle(pen);
                short colour = JRXlsExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
                this.borderStyle[0] = style;
                this.borderStyle[2] = style;
                this.borderStyle[1] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[2] = colour;
                this.borderColour[1] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0];
            hashCode = 31 * hashCode + this.borderColour[0];
            hashCode = 31 * hashCode + this.borderStyle[2];
            hashCode = 31 * hashCode + this.borderColour[2];
            hashCode = 31 * hashCode + this.borderStyle[1];
            hashCode = 31 * hashCode + this.borderColour[1];
            hashCode = 31 * hashCode + this.borderStyle[3];
            hashCode = 31 * hashCode + this.borderColour[3];
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
        }

        public String toString() {
            return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getExportPropertiesPrefix() {
            return "net.sf.jasperreports.export.xls.";
        }
    }
}

