/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GenericElementHandlerEnviroment {
    private static final Log log = LogFactory.getLog(GenericElementHandlerEnviroment.class);
    private final ReferenceMap handlersCache = new ReferenceMap(2, 0);
    private JasperReportsContext jasperReportsContext;

    private GenericElementHandlerEnviroment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static GenericElementHandlerEnviroment getDefaultInstance() {
        return new GenericElementHandlerEnviroment(DefaultJasperReportsContext.getInstance());
    }

    public static GenericElementHandlerEnviroment getInstance(JasperReportsContext jasperReportsContext) {
        return new GenericElementHandlerEnviroment(jasperReportsContext);
    }

    public GenericElementHandler getElementHandler(JRGenericElementType type, String exporterKey) {
        Map<String, GenericElementHandlerBundle> handlerBundles = this.getBundles();
        GenericElementHandlerBundle bundle = handlerBundles.get(type.getNamespace());
        if (bundle == null) {
            throw new JRRuntimeException("No generic element handlers found for namespace " + type.getNamespace());
        }
        return bundle.getHandler(type.getName(), exporterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, GenericElementHandlerBundle> getBundles() {
        Map<String, GenericElementHandlerBundle> handlerBundles;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.handlersCache;
        synchronized (referenceMap) {
            handlerBundles = (Map<String, GenericElementHandlerBundle>)this.handlersCache.get(cacheKey);
            if (handlerBundles == null) {
                handlerBundles = this.loadBundles();
                this.handlersCache.put(cacheKey, handlerBundles);
            }
        }
        return handlerBundles;
    }

    protected Map<String, GenericElementHandlerBundle> loadBundles() {
        List<GenericElementHandlerBundle> bundleList = this.jasperReportsContext.getExtensions(GenericElementHandlerBundle.class);
        HashMap<String, GenericElementHandlerBundle> bundles = new HashMap<String, GenericElementHandlerBundle>();
        for (GenericElementHandlerBundle bundle : bundleList) {
            String namespace = bundle.getNamespace();
            if (bundles.containsKey(namespace)) {
                log.warn("Found two generic element handler bundles for namespace " + namespace);
                continue;
            }
            bundles.put(namespace, bundle);
        }
        return bundles;
    }

    public static GenericElementHandler getHandler(JRGenericElementType type, String exporterKey) {
        return GenericElementHandlerEnviroment.getDefaultInstance().getElementHandler(type, exporterKey);
    }

    protected static Map<String, GenericElementHandlerBundle> getHandlerBundles() {
        return GenericElementHandlerEnviroment.getDefaultInstance().getBundles();
    }

    protected static Map<String, GenericElementHandlerBundle> loadHandlerBundles() {
        return GenericElementHandlerEnviroment.getDefaultInstance().loadBundles();
    }
}

