/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.export.Cut;

public class CutsInfo {
    private final List<Integer> cutOffsets = new ArrayList<Integer>();
    private Cut[] cuts;
    private Map<String, Object> propertiesMap = new HashMap<String, Object>();

    public CutsInfo() {
        this.addCutOffset(0);
    }

    public CutsInfo(Integer lastCutOffset) {
        this();
        this.addCutOffset(lastCutOffset);
    }

    public List<Integer> getCutOffsets() {
        return this.cutOffsets;
    }

    public int size() {
        return this.cutOffsets.size();
    }

    public void use() {
        if (this.cuts == null) {
            this.cuts = new Cut[this.cutOffsets.size()];
        }
    }

    public int getCutOffset(int index) {
        return this.cutOffsets.get(index);
    }

    public Cut getCut(int index) {
        Cut cut = this.cuts[index];
        if (cut == null) {
            this.cuts[index] = cut = new Cut();
        }
        return cut;
    }

    public void addUsage(int index, int usage) {
        Cut cut = this.getCut(index);
        int tmpUsage = cut.getUsage();
        cut.setUsage(tmpUsage |= usage);
    }

    public boolean addCutOffset(Integer cutOffset) {
        int idx = Collections.binarySearch(this.cutOffsets, cutOffset);
        if (idx >= 0) {
            return false;
        }
        this.cutOffsets.add(-idx - 1, cutOffset);
        return true;
    }

    public int indexOfCutOffset(Integer cutOffset) {
        int idx = Collections.binarySearch(this.cutOffsets, cutOffset);
        if (idx < 0) {
            idx = -1;
        }
        return idx;
    }

    public boolean isCutNotEmpty(int index) {
        return this.getCut(index).isCutNotEmpty();
    }

    public boolean isCutSpanned(int index) {
        return this.getCut(index).isCutSpanned();
    }

    public boolean isBreak(int index) {
        Cut cut = this.getCut(index);
        return (cut.getUsage() & 4) > 0;
    }

    public boolean hasCuts() {
        return !this.cutOffsets.isEmpty();
    }

    public int getFirstCutOffset() {
        return this.getCutOffset(0);
    }

    public int getLastCutOffset() {
        return this.getCutOffset(this.size() - 1);
    }

    public int getTotalLength() {
        return this.hasCuts() ? this.getLastCutOffset() - this.getFirstCutOffset() : 0;
    }

    public Map<String, Object> getPropertiesMap() {
        return this.propertiesMap;
    }
}

