/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRFloatLocaleConverter;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;

public abstract class JRAbstractTextDataSource
implements JRDataSource {
    private LocaleConvertUtilsBean convertBean;
    private Locale locale;
    private String datePattern;
    private String numberPattern;
    private TimeZone timeZone;

    protected Object convertStringValue(String text, Class<?> valueClass) {
        Object value = null;
        if (String.class.equals(valueClass)) {
            value = text;
        } else if (Number.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.numberPattern);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.datePattern);
        } else if (Boolean.class.equals(valueClass)) {
            value = Boolean.valueOf(text);
        }
        return value;
    }

    protected Object convertNumber(Number number, Class<?> valueClass) throws JRException {
        Number value = null;
        if (valueClass.equals(Byte.class)) {
            value = new Byte(number.byteValue());
        } else if (valueClass.equals(Short.class)) {
            value = new Short(number.shortValue());
        } else if (valueClass.equals(Integer.class)) {
            value = number.intValue();
        } else if (valueClass.equals(Long.class)) {
            value = new Long(number.longValue());
        } else if (valueClass.equals(Float.class)) {
            value = new Float(number.floatValue());
        } else if (valueClass.equals(Double.class)) {
            value = new Double(number.doubleValue());
        } else if (valueClass.equals(BigInteger.class)) {
            value = BigInteger.valueOf(number.longValue());
        } else if (valueClass.equals(BigDecimal.class)) {
            value = new BigDecimal(Double.toString(number.doubleValue()));
        } else {
            throw new JRException("Unknown number class " + valueClass.getName());
        }
        return value;
    }

    protected Number getFormattedNumber(NumberFormat numberFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        return FormatUtils.getFormattedNumber(numberFormat, fieldValue, valueClass);
    }

    protected Date getFormattedDate(DateFormat dateFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        return FormatUtils.getFormattedDate(dateFormat, fieldValue, valueClass);
    }

    protected LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            if (this.locale != null) {
                this.convertBean.setDefaultLocale(this.locale);
                this.convertBean.deregister();
            }
            this.convertBean.register(new JRDateLocaleConverter(this.timeZone), Date.class, this.locale);
            JRFloatLocaleConverter floatConverter = new JRFloatLocaleConverter(this.locale == null ? Locale.getDefault() : this.locale);
            this.convertBean.register(floatConverter, Float.class, this.locale);
            this.convertBean.register(floatConverter, Float.TYPE, this.locale);
        }
        return this.convertBean;
    }

    public void setTextAttributes(JRAbstractTextDataSource textDataSource) {
        this.setLocale(textDataSource.getLocale());
        this.setDatePattern(textDataSource.getDatePattern());
        this.setNumberPattern(textDataSource.getNumberPattern());
        this.setTimeZone(textDataSource.getTimeZone());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.convertBean = null;
    }

    public void setLocale(String locale) {
        this.setLocale(JRDataUtils.getLocale(locale));
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        this.convertBean = null;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
        this.convertBean = null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.convertBean = null;
    }

    public void setTimeZone(String timeZoneId) {
        this.setTimeZone(JRDataUtils.getTimeZone(timeZoneId));
    }
}

