/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.ElementStore;
import net.sf.jasperreports.engine.base.ElementsBlock;
import net.sf.jasperreports.engine.base.ElementsBlockList;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualizableElementList
extends AbstractList<JRPrintElement>
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(VirtualizableElementList.class);
    private final JRVirtualizationContext virtualizationContext;
    private ElementStore store;

    public VirtualizableElementList(JRVirtualizationContext virtualizationContext, JRVirtualPrintPage page) {
        this.virtualizationContext = virtualizationContext;
        this.initStore(page);
    }

    private void initStore(JRVirtualPrintPage page) {
        this.store = new ElementsBlock(this.virtualizationContext, page);
        if (log.isDebugEnabled()) {
            log.debug("created block " + this.store + " for " + this);
        }
    }

    public synchronized void set(List<JRPrintElement> elements) {
        this.clear();
        this.addAll(elements);
    }

    private void cacheInContext(JRPrintElement element) {
        this.virtualizationContext.cacheTemplate(element);
    }

    @Override
    public synchronized JRPrintElement get(int index) {
        return this.store.get(index);
    }

    @Override
    public synchronized int size() {
        return this.store.size();
    }

    @Override
    public synchronized JRPrintElement set(int index, JRPrintElement element) {
        this.cacheInContext(element);
        return this.store.set(index, element);
    }

    private void createBlockList() {
        ElementsBlockList blockList = new ElementsBlockList((ElementsBlock)this.store);
        blockList.addBlock();
        this.store = blockList;
    }

    @Override
    public synchronized boolean add(JRPrintElement element) {
        this.cacheInContext(element);
        if (!this.store.add(element)) {
            this.createBlockList();
            this.store.add(element);
        }
        return true;
    }

    @Override
    public synchronized void add(int index, JRPrintElement element) {
        this.cacheInContext(element);
        if (!this.store.add(index, element)) {
            this.createBlockList();
            this.store.add(index, element);
        }
    }

    @Override
    public synchronized JRPrintElement remove(int index) {
        return this.store.remove(index);
    }

    @Override
    public synchronized void clear() {
        JRVirtualPrintPage page = this.store.getPage();
        this.store.dispose();
        this.initStore(page);
    }

    public synchronized void dispose() {
        this.store.dispose();
    }
}

