/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.CrosstabDeepVisitor;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseCrosstab
extends JRBaseElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_RUN_DIRECTION = "runDirection";
    public static final String PROPERTY_IGNORE_WIDTH = "ignoreWidth";
    protected int id;
    protected JRCrosstabParameter[] parameters;
    protected JRVariable[] variables;
    protected JRExpression parametersMapExpression;
    protected JRCrosstabDataset dataset;
    protected JRCrosstabRowGroup[] rowGroups;
    protected JRCrosstabColumnGroup[] columnGroups;
    protected JRCrosstabMeasure[] measures;
    protected int columnBreakOffset;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected RunDirectionEnum runDirectionValue;
    protected JRCrosstabCell[][] cells;
    protected JRCellContents whenNoDataCell;
    protected JRCellContents headerCell;
    protected Boolean ignoreWidth;
    protected JRLineBox lineBox;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private byte runDirection;

    public JRBaseCrosstab(JRCrosstab crosstab, JRBaseObjectFactory factory, int id) {
        super(crosstab, factory);
        this.id = id;
        this.columnBreakOffset = crosstab.getColumnBreakOffset();
        this.repeatColumnHeaders = crosstab.isRepeatColumnHeaders();
        this.repeatRowHeaders = crosstab.isRepeatRowHeaders();
        this.runDirectionValue = crosstab.getRunDirectionValue();
        this.ignoreWidth = crosstab.getIgnoreWidth();
        this.dataset = factory.getCrosstabDataset(crosstab.getDataset());
        this.copyParameters(crosstab, factory);
        this.copyVariables(crosstab, factory);
        this.headerCell = factory.getCell(crosstab.getHeaderCell());
        this.copyRowGroups(crosstab, factory);
        this.copyColumnGroups(crosstab, factory);
        this.copyMeasures(crosstab, factory);
        this.copyCells(crosstab, factory);
        this.whenNoDataCell = factory.getCell(crosstab.getWhenNoDataCell());
        this.lineBox = crosstab.getLineBox().clone(this);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    private void copyParameters(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRCrosstabParameter[] crossParameters = crosstab.getParameters();
        if (crossParameters != null) {
            this.parameters = new JRCrosstabParameter[crossParameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getCrosstabParameter(crossParameters[i]);
            }
        }
        this.parametersMapExpression = factory.getExpression(crosstab.getParametersMapExpression());
    }

    private void copyVariables(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRVariable[] vars = crosstab.getVariables();
        if (vars != null) {
            this.variables = new JRVariable[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                this.variables[i] = factory.getVariable(vars[i]);
            }
        }
    }

    private void copyRowGroups(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRCrosstabRowGroup[] crossRowGroups = crosstab.getRowGroups();
        if (crossRowGroups != null) {
            this.rowGroups = new JRCrosstabRowGroup[crossRowGroups.length];
            for (int i = 0; i < crossRowGroups.length; ++i) {
                this.rowGroups[i] = factory.getCrosstabRowGroup(crossRowGroups[i]);
            }
        }
    }

    private void copyColumnGroups(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRCrosstabColumnGroup[] crossColumnGroups = crosstab.getColumnGroups();
        if (crossColumnGroups != null) {
            this.columnGroups = new JRCrosstabColumnGroup[crossColumnGroups.length];
            for (int i = 0; i < crossColumnGroups.length; ++i) {
                this.columnGroups[i] = factory.getCrosstabColumnGroup(crossColumnGroups[i]);
            }
        }
    }

    private void copyMeasures(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRCrosstabMeasure[] crossMeasures = crosstab.getMeasures();
        if (crossMeasures != null) {
            this.measures = new JRCrosstabMeasure[crossMeasures.length];
            for (int i = 0; i < crossMeasures.length; ++i) {
                this.measures[i] = factory.getCrosstabMeasure(crossMeasures[i]);
            }
        }
    }

    private void copyCells(JRCrosstab crosstab, JRBaseObjectFactory factory) {
        JRCrosstabCell[][] crossCells = crosstab.getCells();
        if (crossCells != null) {
            this.cells = new JRCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
            for (int i = 0; i <= this.rowGroups.length; ++i) {
                for (int j = 0; j <= this.columnGroups.length; ++j) {
                    this.cells[i][j] = factory.getCrosstabCell(crossCells[i][j]);
                }
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitCrosstab(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            new CrosstabDeepVisitor(visitor).deepVisitCrosstab(this);
        }
    }

    @Override
    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.cells;
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public static JRElement getElementByKey(JRCrosstab crosstab, String key) {
        JRElement element = null;
        if (crosstab.getHeaderCell() != null) {
            element = crosstab.getHeaderCell().getElementByKey(key);
        }
        if (element == null) {
            element = JRBaseCrosstab.getHeadersElement(crosstab.getRowGroups(), key);
        }
        if (element == null) {
            element = JRBaseCrosstab.getHeadersElement(crosstab.getColumnGroups(), key);
        }
        if (element == null) {
            if (crosstab instanceof JRDesignCrosstab) {
                List<JRCrosstabCell> cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
                Iterator<JRCrosstabCell> it = cellsList.iterator();
                while (element == null && it.hasNext()) {
                    JRCrosstabCell cell = it.next();
                    element = cell.getContents().getElementByKey(key);
                }
            } else {
                JRCrosstabCell[][] cells = crosstab.getCells();
                for (int i = cells.length - 1; element == null && i >= 0; --i) {
                    for (int j = cells[i].length - 1; element == null && j >= 0; --j) {
                        JRCrosstabCell cell = cells[i][j];
                        if (cell == null) continue;
                        element = cell.getContents().getElementByKey(key);
                    }
                }
            }
        }
        if (element == null && crosstab.getWhenNoDataCell() != null) {
            element = crosstab.getWhenNoDataCell().getElementByKey(key);
        }
        return element;
    }

    private static JRElement getHeadersElement(JRCrosstabGroup[] groups, String key) {
        JRElement element = null;
        if (groups != null) {
            for (int i = 0; element == null && i < groups.length; ++i) {
                JRCellContents crosstabHeader;
                JRCrosstabGroup group = groups[i];
                JRCellContents header = group.getHeader();
                element = header.getElementByKey(key);
                if (element == null) {
                    JRCellContents totalHeader = group.getTotalHeader();
                    element = totalHeader.getElementByKey(key);
                }
                if (element != null || !(group instanceof JRCrosstabColumnGroup) || (crosstabHeader = ((JRCrosstabColumnGroup)group).getCrosstabHeader()) == null) continue;
                element = crosstabHeader.getElementByKey(key);
            }
        }
        return element;
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        RunDirectionEnum old = this.runDirectionValue;
        this.runDirectionValue = runDirectionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_RUN_DIRECTION, old, this.runDirectionValue);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getIgnoreWidth() {
        return this.ignoreWidth;
    }

    @Override
    public void setIgnoreWidth(Boolean ignoreWidth) {
        Boolean old = this.ignoreWidth;
        this.ignoreWidth = ignoreWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_WIDTH, old, this.ignoreWidth);
    }

    @Override
    public void setIgnoreWidth(boolean ignoreWidth) {
        this.setIgnoreWidth((Boolean)ignoreWidth);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
        }
    }
}

